/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.AbstractLookupNode;

@GenerateUncached
public abstract class LookupVirtualMethodNode
extends AbstractLookupNode {
    static final int LIMIT = 2;

    public abstract Method[] execute(Klass var1, String var2, int var3) throws ArityException, UnknownIdentifierException;

    public boolean isInvocable(Klass klass, String member) {
        return this.isInvocable(klass, member, true, false);
    }

    @Specialization
    Method[] doPrimitive(PrimitiveKlass klass, String methodName, int arity) {
        return null;
    }

    @Specialization(guards={"methodName.equals(cachedMethodName)", "arity == cachedArity"}, limit="LIMIT")
    Method[] doArrayCached(ArrayKlass klass, String methodName, int arity, @Cached(value="methodName") String cachedMethodName, @Cached(value="arity") int cachedArity, @Cached(value="doGeneric(getJLObject(klass.getMeta()), methodName, arity)") Method[] methods) {
        return methods;
    }

    @Specialization(replaces={"doArrayCached"})
    Method[] doArrayGeneric(ArrayKlass klass, String methodName, int arity) throws ArityException, UnknownIdentifierException {
        return this.doGeneric(LookupVirtualMethodNode.getJLObject(klass.getMeta()), methodName, arity);
    }

    @Specialization(guards={"klass.equals(cachedKlass.getKlass())", "methodName.equals(cachedMethodName)", "arity == cachedArity"}, limit="LIMIT", assumptions={"cachedKlass.getAssumption()"})
    Method[] doCached(ObjectKlass klass, String methodName, int arity, @Cached(value="klass.getKlassVersion()") ObjectKlass.KlassVersion cachedKlass, @Cached(value="methodName") String cachedMethodName, @Cached(value="arity") int cachedArity, @Cached(value="doGeneric(cachedKlass.getKlass(), methodName, arity)") Method[] methods) {
        return methods;
    }

    @Specialization(replaces={"doCached"})
    Method[] doGeneric(ObjectKlass klass, String key, int arity) throws ArityException, UnknownIdentifierException {
        return this.doLookup(klass, key, true, false, arity);
    }

    protected static ObjectKlass getJLObject(Meta meta) {
        return meta.java_lang_Object;
    }

    public static boolean isCandidate(Method m) {
        return m.isPublic() && !m.isStatic() && !m.isSignaturePolymorphicDeclared();
    }

    @Override
    Method.MethodVersion[] getMethodArray(Klass k) {
        assert (k instanceof ObjectKlass);
        return ((ObjectKlass)k).getVTable();
    }
}

