/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.ParameterizedEspressoType;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.interop.WrappedProxyKlass;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@GenerateUncached
public abstract class ProxyInstantiateNode
extends EspressoNode {
    static final int LIMIT = 3;

    public abstract StaticObject execute(WrappedProxyKlass var1, Object var2, EspressoType var3);

    @Specialization(guards={"cachedTargetType == targetType", "cachedWrappedProxyKlass == proxyKlass"}, limit="LIMIT")
    StaticObject doParameterizedCached(WrappedProxyKlass proxyKlass, Object foreignObject, ParameterizedEspressoType targetType, @Cached(value="proxyKlass") WrappedProxyKlass cachedWrappedProxyKlass, @Cached(value="targetType") ParameterizedEspressoType cachedTargetType, @Bind(value="getLanguage()") EspressoLanguage language, @Cached(value="cachedWrappedProxyKlass.fillTypeArguments(cachedTargetType.getTypeArguments())", dimensions=1) EspressoType[] resolvedGenericTypes, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
        return cachedWrappedProxyKlass.createProxyInstance(resolvedGenericTypes, foreignObject, interop, language);
    }

    @Specialization(replaces={"doParameterizedCached"})
    StaticObject doParameterizedUncached(WrappedProxyKlass proxyKlass, Object foreignObject, ParameterizedEspressoType targetType, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
        EspressoType[] resolvedGenericTypes = proxyKlass.fillTypeArguments(targetType.getTypeArguments());
        return proxyKlass.createProxyInstance(resolvedGenericTypes, foreignObject, interop, language);
    }

    @Specialization(guards={"!isParameterizedType(targetType)", "cachedWrappedProxyKlass == proxyKlass"}, limit="LIMIT")
    StaticObject doNoGenericsCached(WrappedProxyKlass proxyKlass, Object foreignObject, EspressoType targetType, @Cached(value="proxyKlass") WrappedProxyKlass cachedWrappedProxyKlass, @Cached(value="cachedWrappedProxyKlass.fillTypeArguments()", dimensions=1) EspressoType[] resolvedGenericTypes, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
        return proxyKlass.createProxyInstance(resolvedGenericTypes, foreignObject, interop, language);
    }

    @Specialization(guards={"!isParameterizedType(targetType)"}, replaces={"doNoGenericsCached"})
    StaticObject doNoGenericsUncached(WrappedProxyKlass proxyKlass, Object foreignObject, EspressoType targetType, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
        EspressoType[] resolvedGenericTypes = proxyKlass.fillTypeArguments();
        return proxyKlass.createProxyInstance(resolvedGenericTypes, foreignObject, interop, language);
    }

    static boolean isParameterizedType(EspressoType type) {
        return type instanceof ParameterizedEspressoType;
    }
}

