/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.ParameterizedEspressoType;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.interop.LookupInternalTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.LookupProxyKlassNode;
import com.oracle.truffle.espresso.nodes.interop.LookupTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.nodes.interop.ProxyInstantiateNode;
import com.oracle.truffle.espresso.nodes.interop.ToPrimitiveFactory;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.nodes.interop.ToReferenceFactory;
import com.oracle.truffle.espresso.nodes.interop.WrappedProxyKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="Convert to Espresso")
public abstract class ToEspressoNode
extends EspressoNode {
    public abstract Object execute(Object var1) throws UnsupportedTypeException;

    public static boolean isStaticObject(Object value) {
        return value instanceof StaticObject;
    }

    @CompilerDirectives.TruffleBoundary
    public static ToEspressoNode createToEspresso(EspressoType targetType, Meta meta) {
        Klass rawType = targetType.getRawType();
        if (rawType.isPrimitive()) {
            switch (rawType.getJavaKind()) {
                case Boolean: {
                    return ToPrimitiveFactory.ToBooleanNodeGen.create();
                }
                case Byte: {
                    return ToPrimitiveFactory.ToByteNodeGen.create();
                }
                case Short: {
                    return ToPrimitiveFactory.ToShortNodeGen.create();
                }
                case Int: {
                    return ToPrimitiveFactory.ToIntNodeGen.create();
                }
                case Float: {
                    return ToPrimitiveFactory.ToFloatNodeGen.create();
                }
                case Long: {
                    return ToPrimitiveFactory.ToLongNodeGen.create();
                }
                case Double: {
                    return ToPrimitiveFactory.ToDoubleNodeGen.create();
                }
                case Char: {
                    return ToPrimitiveFactory.ToCharNodeGen.create();
                }
                case Void: {
                    return ToReferenceFactory.ToVoidNodeGen.create();
                }
            }
        }
        return ToReference.createToReference(targetType, meta);
    }

    @CompilerDirectives.TruffleBoundary
    public static ToEspressoNode getUncachedToEspresso(EspressoType targetType, Meta meta) {
        Klass rawType = targetType.getRawType();
        if (rawType.isPrimitive()) {
            switch (rawType.getJavaKind()) {
                case Boolean: {
                    return ToPrimitiveFactory.ToBooleanNodeGen.getUncached();
                }
                case Byte: {
                    return ToPrimitiveFactory.ToByteNodeGen.getUncached();
                }
                case Short: {
                    return ToPrimitiveFactory.ToShortNodeGen.getUncached();
                }
                case Int: {
                    return ToPrimitiveFactory.ToIntNodeGen.getUncached();
                }
                case Float: {
                    return ToPrimitiveFactory.ToFloatNodeGen.getUncached();
                }
                case Long: {
                    return ToPrimitiveFactory.ToLongNodeGen.getUncached();
                }
                case Double: {
                    return ToPrimitiveFactory.ToDoubleNodeGen.getUncached();
                }
                case Char: {
                    return ToPrimitiveFactory.ToCharNodeGen.getUncached();
                }
                case Void: {
                    return ToReferenceFactory.ToVoidNodeGen.getUncached();
                }
            }
        }
        return ToReference.getUncachedToReference(targetType, meta);
    }

    public static boolean isHostString(Object obj) {
        return obj instanceof String;
    }

    public static boolean isArray(EspressoType type) {
        return type.getRawType().isArray();
    }

    public static boolean isTypeMappingEnabled(EspressoType type) {
        return type.getRawType().getTypeConversionState() == 3;
    }

    public static boolean isTypeConverterEnabled(EspressoType type) {
        return type.getRawType().getTypeConversionState() == 1;
    }

    public static boolean isInternalTypeConverterEnabled(EspressoType type) {
        return type.getRawType().getTypeConversionState() == 2;
    }

    public static boolean isBuiltInCollectionMapped(EspressoType type) {
        return type.getRawType().getTypeConversionState() == 4;
    }

    public static boolean isForeignException(EspressoType type, Meta meta) {
        return meta.polyglot != null && meta.polyglot.ForeignException.equals(type.getRawType());
    }

    public static String getMetaName(Object metaObject, InteropLibrary interop) {
        assert (interop.isMetaObject(metaObject));
        try {
            return interop.asString(interop.getMetaQualifiedName(metaObject));
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void checkHasAllFieldsOrThrow(Object value, ObjectKlass klass, InteropLibrary interopLibrary, Meta meta) throws UnsupportedTypeException {
        CompilerAsserts.partialEvaluationConstant((Object)klass);
        if (meta.isBoxed(klass)) {
            try {
                if (klass == meta.java_lang_Integer && interopLibrary.fitsInInt(value) || klass == meta.java_lang_Long && interopLibrary.fitsInLong(value) || klass == meta.java_lang_Float && interopLibrary.fitsInFloat(value) || klass == meta.java_lang_Double && interopLibrary.fitsInDouble(value) || klass == meta.java_lang_Boolean && interopLibrary.isBoolean(value) || klass == meta.java_lang_Short && interopLibrary.fitsInShort(value) || klass == meta.java_lang_Byte && interopLibrary.fitsInByte(value) || klass == meta.java_lang_Character && interopLibrary.isString(value) && interopLibrary.asString(value).length() == 1) {
                    return;
                }
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
        for (Field f : klass.getDeclaredFields()) {
            if (f.isStatic() || interopLibrary.isMemberExisting(value, f.getNameAsString())) continue;
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)(klass.getTypeAsString() + " due to missing field: " + f.getNameAsString()));
        }
        if (klass.getSuperClass() != null) {
            ToEspressoNode.checkHasAllFieldsOrThrow(value, klass.getSuperKlass(), interopLibrary, meta);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static UnsupportedTypeException unsupportedType(Object value, Klass targetType) {
        return UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", targetType.getNameAsString()));
    }

    @NodeInfo(shortName="Generic toEspresso node")
    @GenerateUncached
    @ImportStatic(value={ToEspressoNode.class})
    public static abstract class GenericToEspresso
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract Object execute(Object var1, EspressoType var2) throws UnsupportedTypeException;

        public static boolean isStaticObject(Object value) {
            return value instanceof StaticObject;
        }

        @Specialization
        public static Object doStaticObject(StaticObject value, EspressoType targetType, @Bind Node node, @Cached InstanceOf.Dynamic instanceOf, @Cached InlinedBranchProfile error) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), targetType.getRawType())) {
                return value;
            }
            error.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", targetType.getRawType().getTypeName()));
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public static Object doForeignNull(Object value, EspressoType targetType, @Bind Node node, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached InlinedBranchProfile error) throws UnsupportedTypeException {
            if (targetType.getRawType().isPrimitive()) {
                error.enter(node);
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", targetType.getRawType().getTypeName()));
            }
            return StaticObject.createForeignNull(EspressoLanguage.get(node), value);
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeMappingEnabled(targetType)", "!isStaticObject(value)"})
        public static Object doMappedInterface(Object value, EspressoType targetType, @Bind Node node, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached InlinedBranchProfile error) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToEspressoNode.getMetaName(metaObject, interop), targetType.getRawType());
                if (proxyKlass != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            error.enter(node);
            throw ToEspressoNode.unsupportedType(value, targetType.getRawType());
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)"})
        public static Object doArray(Object value, ArrayKlass targetType, @Bind Node node, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached InlinedBranchProfile error) throws UnsupportedTypeException {
            Meta meta = EspressoContext.get(node).getMeta();
            if (targetType == meta._byte_array && interop.hasBufferElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(node), meta._byte_array, value, interop);
            }
            if (interop.hasArrayElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(node), targetType, value, interop);
            }
            error.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public static Object doTypeConverter(Object value, EspressoType targetType, @Bind Node node, @Cached LookupTypeConverterNode lookupTypeConverter, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached InlinedBranchProfile error) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverter.execute(metaName);
                if (converter != null) {
                    StaticObject result;
                    StaticObject foreignWrapper = StaticObject.createForeign(EspressoLanguage.get(node), targetType.getRawType(), value, interop);
                    if (targetType instanceof ParameterizedEspressoType) {
                        ParameterizedEspressoType parameterizedEspressoType = (ParameterizedEspressoType)targetType;
                        EspressoLanguage.get(node).getTypeArgumentProperty().setObject((Object)foreignWrapper, (Object)parameterizedEspressoType.getTypeArguments());
                    }
                    if (instanceOf.execute((result = (StaticObject)converter.convert(foreignWrapper)).getKlass(), targetType.getRawType())) {
                        return result;
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            error.enter(node);
            throw ToEspressoNode.unsupportedType(value, targetType.getRawType());
        }

        @Specialization(guards={"!interop.isNull(value)", "isInternalTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public static Object doInternalTypeConverter(Object value, EspressoType targetType, @Bind Node node, @Cached ToReference.DynamicToReference converterToEspresso, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverter, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.InternalTypeConverter converter = lookupInternalTypeConverter.execute(metaName);
                if (converter != null) {
                    return converter.convertInternal(interop, value, EspressoContext.get(node).getMeta(), converterToEspresso, targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw ToEspressoNode.unsupportedType(value, targetType.getRawType());
        }

        @Specialization(guards={"!interop.isNull(value)", "isBuiltInCollectionMapped(targetType)", "!isStaticObject(value)"})
        public static Object doBuiltinCollectionMapped(Object value, EspressoType targetType, @Bind Node node, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached InlinedBranchProfile converterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    converterProfile.enter(node);
                    EspressoContext context = EspressoContext.get(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(context.getLanguage(), context.getMeta().java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), targetType.getRawType())) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, targetType.getRawType())) != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getRawType().getTypeName());
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)", "!isArray(targetType)", "!isTypeConverterEnabled(targetType)", "!isTypeMappingEnabled(targetType)", "!isBuiltInCollectionMapped(targetType)", "!isInternalTypeConverterEnabled(targetType)"})
        public static Object doGeneric(Object value, EspressoType targetType, @Bind Node node, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached ToReference.DynamicToReference converterToEspresso, @Cached InlinedBranchProfile unknownProfile) throws UnsupportedTypeException {
            Meta meta = EspressoContext.get(node).getMeta();
            ToEspressoNode uncachedToEspresso = ToEspressoNode.getUncachedToEspresso(targetType, meta);
            if (uncachedToEspresso != null) {
                return uncachedToEspresso.execute(value);
            }
            unknownProfile.enter(node);
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, targetType, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, meta);
            if (result != null) {
                return result;
            }
            Klass klass = targetType.getRawType();
            if (klass instanceof ObjectKlass) {
                ObjectKlass rawType = (ObjectKlass)klass;
                ToEspressoNode.checkHasAllFieldsOrThrow(value, rawType, interop, meta);
                return StaticObject.createForeign(EspressoLanguage.get(node), rawType, value, interop);
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getRawType().getTypeAsString());
        }
    }

    @NodeInfo(shortName="Dynamic toEspresso node")
    @GenerateUncached
    public static abstract class DynamicToEspresso
    extends EspressoNode {
        protected static final int LIMIT = 4;

        public abstract Object execute(Object var1, EspressoType var2) throws UnsupportedTypeException;

        protected static ToEspressoNode createToEspressoNode(EspressoType targetType) {
            return ToEspressoNode.createToEspresso(targetType, targetType.getRawType().getMeta());
        }

        @Specialization(guards={"targetType == cachedTargetType"}, limit="LIMIT")
        public Object doCached(Object value, EspressoType targetType, @Cached(value="targetType") EspressoType cachedTargetType, @Cached(value="createToEspressoNode(cachedTargetType)") ToEspressoNode toEspressoNode) throws UnsupportedTypeException {
            return toEspressoNode.execute(value);
        }

        @Specialization(replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        public Object doGeneric(Object value, EspressoType targetType, @Cached GenericToEspresso genericToEspresso) throws UnsupportedTypeException {
            return genericToEspresso.execute(value, targetType);
        }
    }
}

