/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="Convert value to primitive")
public abstract class ToPrimitive
extends ToEspressoNode {

    @NodeInfo(shortName="To double")
    @GenerateUncached
    public static abstract class ToDouble
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        double doHost(Double value) {
            return value;
        }

        @Specialization
        double doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && EspressoInterop.fitsInDouble(value)) {
                try {
                    return EspressoInterop.asDouble(value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("Contract violation: if fitsInDouble returns true, asDouble must succeed.");
                }
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to double"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostDouble(value)", "interop.fitsInDouble(value)"})
        double doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return interop.asDouble(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInDouble returns true, asDouble must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"double");
        }

        static boolean isHostDouble(Object value) {
            return value instanceof Double;
        }
    }

    @NodeInfo(shortName="To float")
    @GenerateUncached
    public static abstract class ToFloat
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        float doHost(Float value) {
            return value.floatValue();
        }

        @Specialization
        float doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && EspressoInterop.fitsInFloat(value)) {
                try {
                    return EspressoInterop.asFloat(value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("Contract violation: if fitsInFloat returns true, asFloat must succeed.");
                }
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to float"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostFloat(value)", "interop.fitsInFloat(value)"})
        float doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return interop.asFloat(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInFloat returns true, asFloat must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"float");
        }

        static boolean isHostFloat(Object value) {
            return value instanceof Float;
        }
    }

    @NodeInfo(shortName="To long")
    @GenerateUncached
    public static abstract class ToLong
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        long doHost(Long value) {
            return value;
        }

        @Specialization
        long doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && EspressoInterop.fitsInLong(value)) {
                try {
                    return EspressoInterop.asLong(value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("Contract violation: if fitsInLong returns true, asLong must succeed.");
                }
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to long"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostLong(value)", "interop.fitsInLong(value)"})
        long doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return interop.asLong(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInLong returns true, asLong must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"long");
        }

        static boolean isHostLong(Object value) {
            return value instanceof Long;
        }
    }

    @NodeInfo(shortName="To char")
    @GenerateUncached
    public static abstract class ToChar
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        char doHost(Character value) {
            return value.charValue();
        }

        @Specialization
        char doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && value.getKlass() == this.getMeta().java_lang_Character) {
                return ((Character)this.getMeta().java_lang_Character_value.get(value)).charValue();
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to char"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostCharacter(value)", "interop.isString(value)"})
        char doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            try {
                String s = interop.asString(value);
                if (s.length() == 1) {
                    return s.charAt(0);
                }
                exceptionProfile.enter();
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", s, " to char"));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isString returns true, asString must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"char");
        }

        static boolean isHostCharacter(Object value) {
            return value instanceof Character;
        }
    }

    @NodeInfo(shortName="To short")
    @GenerateUncached
    public static abstract class ToShort
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        short doHost(Short value) {
            return value;
        }

        @Specialization
        short doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && EspressoInterop.fitsInShort(value)) {
                try {
                    return EspressoInterop.asShort(value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("Contract violation: if fitsInShort returns true, asShort must succeed.");
                }
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to short"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostShort(value)", "interop.fitsInShort(value)"})
        short doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return interop.asShort(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInShort returns true, asShort must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"short");
        }

        static boolean isHostShort(Object value) {
            return value instanceof Short;
        }
    }

    @NodeInfo(shortName="To byte")
    @GenerateUncached
    public static abstract class ToByte
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        byte doHost(Byte value) {
            return value;
        }

        @Specialization
        byte doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && EspressoInterop.fitsInByte(value)) {
                try {
                    return EspressoInterop.asByte(value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("Contract violation: if fitsInByte returns true, asByte must succeed.");
                }
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to byte"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostByte(value)", "interop.fitsInByte(value)"})
        byte doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return interop.asByte(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInByte returns true, asByte must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"byte");
        }

        static boolean isHostByte(Object value) {
            return value instanceof Byte;
        }
    }

    @NodeInfo(shortName="To int")
    @GenerateUncached
    public static abstract class ToInt
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        int doHost(Integer value) {
            return value;
        }

        @Specialization
        int doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && EspressoInterop.fitsInInt(value)) {
                try {
                    return EspressoInterop.asInt(value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("Contract violation: if fitsInInt returns true, asInt must succeed.");
                }
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to int"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostInteger(value)", "interop.fitsInInt(value)"})
        int doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return interop.asInt(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInInt returns true, asInt must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"int");
        }

        static boolean isHostInteger(Object value) {
            return value instanceof Integer;
        }
    }

    @NodeInfo(shortName="To boolean")
    @GenerateUncached
    public static abstract class ToBoolean
    extends ToPrimitive {
        protected static final int LIMIT = 2;

        @Specialization
        boolean doHost(Boolean value) {
            return value;
        }

        @Specialization
        boolean doEspresso(StaticObject value, @Cached BranchProfile exceptionProfile) throws UnsupportedTypeException {
            if (value != null && !StaticObject.isNull(value) && value.getKlass() == this.getMeta().java_lang_Boolean) {
                return (Boolean)this.getMeta().java_lang_Boolean_value.get(value);
            }
            exceptionProfile.enter();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to boolean"));
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostBoolean(value)", "interop.isBoolean(value)"})
        boolean doForeign(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return interop.asBoolean(value);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isBoolean returns true, asBoolean must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"boolean");
        }

        static boolean isHostBoolean(Object value) {
            return value instanceof Boolean;
        }
    }
}

