/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.ParameterizedEspressoType;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.interop.LookupInternalTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.LookupProxyKlassNode;
import com.oracle.truffle.espresso.nodes.interop.LookupTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.nodes.interop.ProxyInstantiateNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.ToPrimitive;
import com.oracle.truffle.espresso.nodes.interop.ToReferenceFactory;
import com.oracle.truffle.espresso.nodes.interop.WrappedProxyKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@NodeInfo(shortName="Convert to Espresso StaticObject")
@GenerateUncached
public abstract class ToReference
extends ToEspressoNode {
    @Override
    public abstract StaticObject execute(Object var1) throws UnsupportedTypeException;

    @CompilerDirectives.TruffleBoundary
    public static ToReference createToReference(EspressoType targetType, Meta meta) {
        Klass rawType = targetType.getRawType();
        if (rawType == meta.java_lang_Void) {
            return ToReferenceFactory.ToVoidNodeGen.create();
        }
        if (rawType == meta.java_lang_Boolean) {
            return ToReferenceFactory.ToBooleanNodeGen.create();
        }
        if (rawType == meta.java_lang_Character) {
            return ToReferenceFactory.ToCharNodeGen.create();
        }
        if (rawType == meta.java_lang_Integer) {
            return ToReferenceFactory.ToIntegerNodeGen.create();
        }
        if (rawType == meta.java_lang_Byte) {
            return ToReferenceFactory.ToByteNodeGen.create();
        }
        if (rawType == meta.java_lang_Short) {
            return ToReferenceFactory.ToShortNodeGen.create();
        }
        if (rawType == meta.java_lang_Long) {
            return ToReferenceFactory.ToLongNodeGen.create();
        }
        if (rawType == meta.java_lang_Float) {
            return ToReferenceFactory.ToFloatNodeGen.create();
        }
        if (rawType == meta.java_lang_Double) {
            return ToReferenceFactory.ToDoubleNodeGen.create();
        }
        if (rawType == meta.java_lang_Number) {
            return ToReferenceFactory.ToNumberNodeGen.create();
        }
        if (rawType == meta._byte_array) {
            return ToReferenceFactory.ToByteArrayNodeGen.create();
        }
        if (rawType.isArray()) {
            return ToReferenceFactory.ToArrayNodeGen.create((ArrayKlass)targetType);
        }
        if (rawType.isJavaLangObject()) {
            return ToReferenceFactory.ToJavaLangObjectNodeGen.create();
        }
        if (rawType == meta.java_lang_String) {
            return ToReferenceFactory.ToStringNodeGen.create();
        }
        if (rawType.isInterface()) {
            if (ToReference.isBuiltInCollectionMapped(targetType)) {
                if (rawType == meta.java_util_List) {
                    return ToReferenceFactory.ToListNodeGen.create(targetType);
                }
                if (rawType == meta.java_util_Set) {
                    return ToReferenceFactory.ToSetNodeGen.create(targetType);
                }
                if (rawType == meta.java_util_Collection) {
                    return ToReferenceFactory.ToCollectionNodeGen.create(targetType);
                }
                if (rawType == meta.java_lang_Iterable) {
                    return ToReferenceFactory.ToIterableNodeGen.create(targetType);
                }
                if (rawType == meta.java_util_Iterator) {
                    return ToReferenceFactory.ToIteratorNodeGen.create(targetType);
                }
                if (rawType == meta.java_util_Map) {
                    return ToReferenceFactory.ToMapNodeGen.create(targetType);
                }
            }
            if (rawType == meta.java_lang_CharSequence) {
                return ToReferenceFactory.ToCharSequenceNodeGen.create();
            }
            if (ToReference.isTypeMappingEnabled(targetType)) {
                return ToReferenceFactory.ToMappedInterfaceNodeGen.create(targetType);
            }
            return ToReferenceFactory.ToUnknownNodeGen.create(targetType);
        }
        if (ToReference.isForeignException(targetType, meta)) {
            return ToReferenceFactory.ToForeignExceptionNodeGen.create();
        }
        if (rawType == meta.java_lang_Throwable) {
            return ToReferenceFactory.ToThrowableNodeGen.create();
        }
        if (rawType == meta.java_lang_Exception) {
            return ToReferenceFactory.ToExceptionNodeGen.create();
        }
        if (rawType == meta.java_lang_RuntimeException) {
            return ToReferenceFactory.ToRuntimeExceptionNodeGen.create();
        }
        if (rawType == meta.java_time_LocalDate) {
            return ToReferenceFactory.ToLocalDateNodeGen.create();
        }
        if (rawType == meta.java_time_LocalTime) {
            return ToReferenceFactory.ToLocalTimeNodeGen.create();
        }
        if (rawType == meta.java_time_LocalDateTime) {
            return ToReferenceFactory.ToLocalDateTimeNodeGen.create();
        }
        if (rawType == meta.java_time_ZonedDateTime) {
            return ToReferenceFactory.ToZonedDateTimeNodeGen.create();
        }
        if (rawType == meta.java_time_Instant) {
            return ToReferenceFactory.ToInstantNodeGen.create();
        }
        if (rawType == meta.java_time_Duration) {
            return ToReferenceFactory.ToDurationNodeGen.create();
        }
        if (rawType == meta.java_time_ZoneId) {
            return ToReferenceFactory.ToZoneIdNodeGen.create();
        }
        if (rawType == meta.java_util_Date) {
            return ToReferenceFactory.ToDateNodeGen.create();
        }
        if (rawType == meta.java_math_BigInteger) {
            return ToReferenceFactory.ToBigIntegerNodeGen.create();
        }
        if (ToReference.isTypeConverterEnabled(targetType)) {
            return ToReferenceFactory.ToMappedTypeNodeGen.create(targetType);
        }
        if (ToReference.isInternalTypeConverterEnabled(targetType)) {
            return ToReferenceFactory.ToMappedInternalTypeNodeGen.create(targetType);
        }
        return ToReferenceFactory.ToUnknownNodeGen.create(targetType);
    }

    @CompilerDirectives.TruffleBoundary
    public static ToReference getUncachedToReference(EspressoType targetType, Meta meta) {
        Klass rawType = targetType.getRawType();
        if (rawType == meta.java_lang_Void) {
            return ToReferenceFactory.ToVoidNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Boolean) {
            return ToReferenceFactory.ToBooleanNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Character) {
            return ToReferenceFactory.ToCharNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Integer) {
            return ToReferenceFactory.ToIntegerNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Byte) {
            return ToReferenceFactory.ToByteNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Short) {
            return ToReferenceFactory.ToShortNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Long) {
            return ToReferenceFactory.ToLongNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Float) {
            return ToReferenceFactory.ToFloatNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Double) {
            return ToReferenceFactory.ToDoubleNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Number) {
            return ToReferenceFactory.ToNumberNodeGen.getUncached();
        }
        if (rawType == meta._byte_array) {
            return ToReferenceFactory.ToByteArrayNodeGen.getUncached();
        }
        if (rawType.isArray()) {
            return null;
        }
        if (rawType.isJavaLangObject()) {
            return ToReferenceFactory.ToJavaLangObjectNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_String) {
            return ToReferenceFactory.ToStringNodeGen.getUncached();
        }
        if (rawType.isInterface()) {
            if (rawType == meta.java_lang_CharSequence) {
                return ToReferenceFactory.ToCharSequenceNodeGen.getUncached();
            }
            return null;
        }
        if (ToReference.isForeignException(targetType, meta)) {
            return ToReferenceFactory.ToForeignExceptionNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Throwable) {
            return ToReferenceFactory.ToThrowableNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_Exception) {
            return ToReferenceFactory.ToExceptionNodeGen.getUncached();
        }
        if (rawType == meta.java_lang_RuntimeException) {
            return ToReferenceFactory.ToRuntimeExceptionNodeGen.getUncached();
        }
        if (rawType == meta.java_time_LocalDate) {
            return ToReferenceFactory.ToLocalDateNodeGen.getUncached();
        }
        if (rawType == meta.java_time_LocalTime) {
            return ToReferenceFactory.ToLocalTimeNodeGen.getUncached();
        }
        if (rawType == meta.java_time_LocalDateTime) {
            return ToReferenceFactory.ToLocalDateTimeNodeGen.getUncached();
        }
        if (rawType == meta.java_time_ZonedDateTime) {
            return ToReferenceFactory.ToZonedDateTimeNodeGen.getUncached();
        }
        if (rawType == meta.java_time_Instant) {
            return ToReferenceFactory.ToInstantNodeGen.getUncached();
        }
        if (rawType == meta.java_time_Duration) {
            return ToReferenceFactory.ToDurationNodeGen.getUncached();
        }
        if (rawType == meta.java_time_ZoneId) {
            return ToReferenceFactory.ToZoneIdNodeGen.getUncached();
        }
        if (rawType == meta.java_util_Date) {
            return ToReferenceFactory.ToDateNodeGen.getUncached();
        }
        if (rawType == meta.java_math_BigInteger) {
            return ToReferenceFactory.ToBigIntegerNodeGen.getUncached();
        }
        return null;
    }

    private static Object getMetaObjectOrThrow(Object value, InteropLibrary interop, Klass targetType) throws UnsupportedTypeException {
        try {
            return interop.getMetaObject(value);
        }
        catch (UnsupportedMessageException e) {
            throw ToReference.unsupportedType(value, targetType);
        }
    }

    private static Object getMetaObjectOrNull(Object value, InteropLibrary interop) {
        try {
            return interop.getMetaObject(value);
        }
        catch (UnsupportedMessageException e) {
            return null;
        }
    }

    private static StaticObject tryTypeConversion(Object value, InteropLibrary interop, LookupProxyKlassNode lookupProxyKlassNode, ProxyInstantiateNode proxyInstantiateNode, LookupTypeConverterNode lookupTypeConverterNode, LookupInternalTypeConverterNode lookupInternalTypeConverterNode, DynamicToReference converterToEspresso, Meta meta) throws UnsupportedTypeException {
        Object metaObject = ToReference.getMetaObjectOrThrow(value, interop, meta.java_lang_Object);
        String metaName = ToReference.getMetaName(metaObject, interop);
        PolyglotTypeMappings.InternalTypeConverter internalConverter = lookupInternalTypeConverterNode.execute(metaName);
        if (internalConverter != null) {
            return internalConverter.convertInternal(interop, value, meta, converterToEspresso, meta.java_lang_Object);
        }
        PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
        if (converter != null) {
            if (interop.isException(value)) {
                return (StaticObject)converter.convert(StaticObject.createForeignException(converterToEspresso.getContext(), value, interop));
            }
            return (StaticObject)converter.convert(StaticObject.createForeign(converterToEspresso.getLanguage(), meta.java_lang_Object, value, interop));
        }
        if (interop.isException(value)) {
            return StaticObject.createForeignException(converterToEspresso.getContext(), value, interop);
        }
        WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, meta.java_lang_Object);
        if (proxyKlass != null) {
            return proxyInstantiateNode.execute(proxyKlass, value, meta.java_lang_Object);
        }
        return StaticObject.createForeign(converterToEspresso.getLanguage(), meta.java_lang_Object, value, interop);
    }

    static StaticObject tryConverterForUnknownTarget(Object value, EspressoType targetType, InteropLibrary interop, LookupTypeConverterNode lookupTypeConverterNode, LookupInternalTypeConverterNode lookupInternalTypeConverterNode, DynamicToReference converterToEspresso, Meta meta) throws UnsupportedTypeException {
        StaticObject foreignWrapper;
        Object metaObject = ToReference.getMetaObjectOrNull(value, interop);
        if (metaObject == null) {
            return null;
        }
        String metaName = ToReference.getMetaName(metaObject, interop);
        PolyglotTypeMappings.InternalTypeConverter internalConverter = lookupInternalTypeConverterNode.execute(metaName);
        if (internalConverter != null) {
            return internalConverter.convertInternal(interop, value, meta, converterToEspresso, meta.java_lang_Object);
        }
        PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
        boolean isException = interop.isException(value);
        StaticObject staticObject = foreignWrapper = isException ? StaticObject.createForeignException(converterToEspresso.getContext(), value, interop) : null;
        if (converter != null) {
            if (foreignWrapper == null) {
                foreignWrapper = StaticObject.createForeign(converterToEspresso.getLanguage(), meta.java_lang_Object, value, interop);
            }
            if (targetType instanceof ParameterizedEspressoType) {
                ParameterizedEspressoType parameterizedEspressoType = (ParameterizedEspressoType)targetType;
                meta.getLanguage().getTypeArgumentProperty().setObject((Object)foreignWrapper, (Object)parameterizedEspressoType.getTypeArguments());
            }
            StaticObject result = (StaticObject)converter.convert(foreignWrapper);
            if (!targetType.getRawType().isAssignableFrom(result.getKlass())) {
                return null;
            }
            return result;
        }
        return foreignWrapper;
    }

    @NeverDefault
    static InstanceOf createInstanceOf(Klass targetType) {
        return InstanceOf.create(targetType, false);
    }

    static boolean isHostNumber(Object obj) {
        return obj instanceof Number;
    }

    static boolean isEspressoString(StaticObject obj, Meta meta) {
        return obj.getKlass() == meta.java_lang_String;
    }

    static boolean isBoxedPrimitive(Object obj) {
        return obj instanceof Number || obj instanceof Character || obj instanceof Boolean;
    }

    static boolean isEspressoException(Object obj) {
        return obj instanceof EspressoException;
    }

    @Idempotent
    static boolean isTypeMappingEnabled(EspressoContext context) {
        return context.getPolyglotTypeMappings().hasMappings();
    }

    static boolean isHostObject(EspressoContext context, Object value) {
        return context.getEnv().isHostObject(value);
    }

    @NodeInfo(shortName="void target type")
    @GenerateUncached
    static abstract class ToVoid
    extends ToReference {
        ToVoid() {
        }

        @Specialization
        public StaticObject doVoid(Object value) {
            return StaticObject.NULL;
        }
    }

    @NodeInfo(shortName="boolean target type")
    @GenerateUncached
    static abstract class ToBoolean
    extends ToReference {
        protected static final int LIMIT = 2;

        ToBoolean() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doBoolean(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToBoolean toBoolean, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxBoolean((Boolean)toBoolean.execute(value));
        }
    }

    @NodeInfo(shortName="char target type")
    @GenerateUncached
    static abstract class ToChar
    extends ToReference {
        protected static final int LIMIT = 2;

        ToChar() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doChar(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToChar toChar, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxCharacter(((Character)toChar.execute(value)).charValue());
        }
    }

    @NodeInfo(shortName="integer target type")
    @GenerateUncached
    static abstract class ToInteger
    extends ToReference {
        protected static final int LIMIT = 2;

        ToInteger() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doInteger(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToInt toInt, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxInteger((Integer)toInt.execute(value));
        }
    }

    @NodeInfo(shortName="byte target type")
    @GenerateUncached
    static abstract class ToByte
    extends ToReference {
        protected static final int LIMIT = 2;

        ToByte() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doByte(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToByte toByte, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxByte((Byte)toByte.execute(value));
        }
    }

    @GenerateUncached
    static abstract class ToShort
    extends ToReference {
        protected static final int LIMIT = 2;

        ToShort() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doShort(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToShort toShort, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxShort((Short)toShort.execute(value));
        }
    }

    @NodeInfo(shortName="long target type")
    @GenerateUncached
    static abstract class ToLong
    extends ToReference {
        protected static final int LIMIT = 2;

        ToLong() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doLong(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToLong toLong, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxLong((Long)toLong.execute(value));
        }
    }

    @NodeInfo(shortName="float target type")
    @GenerateUncached
    static abstract class ToFloat
    extends ToReference {
        protected static final int LIMIT = 2;

        ToFloat() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doFloat(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToFloat toFloat, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxFloat(((Float)toFloat.execute(value)).floatValue());
        }
    }

    @NodeInfo(shortName="double target type")
    @GenerateUncached
    static abstract class ToDouble
    extends ToReference {
        protected static final int LIMIT = 2;

        ToDouble() {
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)"})
        public StaticObject doDouble(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToPrimitive.ToDouble toDouble, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            return meta.boxDouble((Double)toDouble.execute(value));
        }
    }

    @NodeInfo(shortName="Number type mapping")
    @GenerateUncached
    public static abstract class ToNumber
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_lang_Number)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Number.getTypeAsString());
        }

        @Specialization
        StaticObject doHostInteger(Integer value) {
            return this.getMeta().boxInteger(value);
        }

        @Specialization
        StaticObject doHostByte(Byte value) {
            return this.getMeta().boxByte(value);
        }

        @Specialization
        StaticObject doHostShort(Short value) {
            return this.getMeta().boxShort(value);
        }

        @Specialization
        StaticObject doHostLong(Long value) {
            return this.getMeta().boxLong(value);
        }

        @Specialization
        StaticObject doHostFloat(Float value) {
            return this.getMeta().boxFloat(value.floatValue());
        }

        @Specialization
        StaticObject doHostDouble(Double value) {
            return this.getMeta().boxDouble(value);
        }

        @Specialization(guards={"interop.isNumber(value)", "!isStaticObject(value)", "!isHostNumber(value)"})
        StaticObject doForeignNumber(Object value, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (interop.fitsInBigInteger(value) || interop.fitsInDouble(value)) {
                return StaticObject.createForeign(this.getLanguage(), meta.polyglot.EspressoForeignNumber, value, interop);
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Number.getTypeAsString());
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Number.getTypeAsString());
        }
    }

    @NodeInfo(shortName="byte array type mapping")
    @GenerateUncached
    public static abstract class ToByteArray
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta._byte_array)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta._byte_array.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.hasBufferElements(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)"})
        StaticObject doForeignBuffer(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(EspressoLanguage.get(this), meta._byte_array, value, interop);
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.hasArrayElements(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)"})
        StaticObject doForeignArray(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(EspressoLanguage.get(this), meta._byte_array, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta()._byte_array.getTypeAsString());
        }
    }

    @NodeInfo(shortName="array type mapping")
    public static abstract class ToArray
    extends ToReference {
        protected static final int LIMIT = 4;
        private final ArrayKlass targetType;

        protected ToArray(ArrayKlass targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), this.targetType)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)"})
        StaticObject doForeignArray(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeign(EspressoLanguage.get(this), this.targetType, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getTypeAsString());
        }
    }

    @NodeInfo(shortName="j.l.Object target type")
    @GenerateUncached
    @ImportStatic(value={EspressoContext.class})
    public static abstract class ToJavaLangObject
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization
        public StaticObject doEspresso(StaticObject value) {
            return value;
        }

        @Specialization
        StaticObject doEspressoException(EspressoException value) {
            return value.getGuestException();
        }

        @Specialization
        StaticObject doHostString(String value, @Bind(value="getMeta()") Meta meta) {
            return meta.toGuestString(value);
        }

        @Specialization
        StaticObject doHostInteger(Integer value) {
            return this.getMeta().boxInteger(value);
        }

        @Specialization
        StaticObject doHostBoolean(Boolean value) {
            return this.getMeta().boxBoolean(value);
        }

        @Specialization
        StaticObject doHostByte(Byte value) {
            return this.getMeta().boxByte(value);
        }

        @Specialization
        StaticObject doHostChar(Character value) {
            return this.getMeta().boxCharacter(value.charValue());
        }

        @Specialization
        StaticObject doHostShort(Short value) {
            return this.getMeta().boxShort(value);
        }

        @Specialization
        StaticObject doHostLong(Long value) {
            return this.getMeta().boxLong(value);
        }

        @Specialization
        StaticObject doHostFloat(Float value) {
            return this.getMeta().boxFloat(value.floatValue());
        }

        @Specialization
        StaticObject doHostDouble(Double value) {
            return this.getMeta().boxDouble(value);
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"interop.isBoolean(value)", "!isStaticObject(value)"})
        StaticObject doForeignBoolean(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            try {
                return this.getMeta().boxBoolean(interop.asBoolean(value));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isBoolean returns true, asBoolean must succeed.");
            }
        }

        @Specialization(guards={"interop.isNumber(value)", "!isStaticObject(value)", "!isHostNumber(value)"})
        StaticObject doForeignNumber(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context) throws UnsupportedTypeException {
            if (interop.fitsInBigInteger(value) || interop.fitsInDouble(value)) {
                return StaticObject.createForeign(this.getLanguage(), context.getMeta().polyglot.EspressoForeignNumber, value, interop);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"unsupported number");
        }

        @Specialization(guards={"interop.isString(value)", "!isStaticObject(value)"})
        StaticObject doForeignString(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                String hostString = interop.asString(value);
                return meta.toGuestString(hostString);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isString returns true, asString must succeed.");
            }
        }

        @Specialization(guards={"interop.isException(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)", "!isBoxedPrimitive(value)"})
        static StaticObject doForeignException(Object value, @Bind Node node, @Bind(value="get(node)") EspressoContext context, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached InlinedBranchProfile errorProfile) {
            if (ToJavaLangObject.isTypeMappingEnabled(context)) {
                try {
                    return ToReference.tryTypeConversion(value, interop, lookupProxyKlassNode, proxyInstantiateNode, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
                }
                catch (UnsupportedTypeException ex) {
                    errorProfile.enter(node);
                }
            }
            return StaticObject.createForeignException(context, value, interop);
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "!isTypeMappingEnabled(context)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignArray(Object value, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeign(EspressoLanguage.get(this), this.getMeta().java_lang_Object, value, interop);
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "isTypeMappingEnabled(context)", "!interop.hasMetaObject(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignArrayNoMetaObject(Object value, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(this.getLanguage(), meta.java_lang_Object, value, interop);
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "isTypeMappingEnabled(context)", "interop.hasMetaObject(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignArrayTypeMapping(Object value, @Bind(value="getContext()") EspressoContext context, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso) throws UnsupportedTypeException {
            return ToReference.tryTypeConversion(value, interop, lookupProxyKlassNode, proxyInstantiateNode, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.hasBufferElements(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignBuffer(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(EspressoLanguage.get(this), meta._byte_array, value, interop);
        }

        @Specialization(guards={"!isTypeMappingEnabled(context)", "interop.hasMetaObject(value)", "!interop.hasArrayElements(value)", "!interop.hasBufferElements(value)", "!interop.isException(value)", "!interop.isNumber(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)", "!isBoxedPrimitive(value)"})
        StaticObject doJavaLangObjectForeignWrapper(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getContext()") EspressoContext context, @Bind(value="getMeta()") Meta meta) {
            return StaticObject.createForeign(this.getLanguage(), meta.java_lang_Object, value, interop);
        }

        @Specialization(guards={"isTypeMappingEnabled(context)", "interop.hasMetaObject(value)", "!interop.isNumber(value)", "!interop.isException(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)", "!isEspressoException(value)", "!isBoxedPrimitive(value)"})
        StaticObject doForeignTypeMapping(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Bind(value="getContext()") EspressoContext context) throws UnsupportedTypeException {
            return ToReference.tryTypeConversion(value, interop, lookupProxyKlassNode, proxyInstantiateNode, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
        }

        @Specialization(guards={"!interop.hasMetaObject(value)", "!interop.hasArrayElements(value)", "!interop.isBoolean(value)", "!interop.isNumber(value)", "!interop.isString(value)", "!isStaticObject(value)", "!interop.isNull(value)", "!isHostString(value)"})
        StaticObject doForeignObject(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeign(EspressoLanguage.get(this), this.getMeta().java_lang_Object, value, interop);
        }

        @Fallback
        StaticObject doUnsupportedType(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"java.lang.Object");
        }
    }

    @NodeInfo(shortName="j.l.String target type")
    @GenerateUncached
    public static abstract class ToString
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        StaticObject doHostString(String value, @Bind(value="getMeta()") Meta meta) {
            return meta.toGuestString(value);
        }

        @Specialization(guards={"isEspressoString(value, meta)"})
        StaticObject doEspressoString(StaticObject value, @Bind(value="getMeta()") Meta meta) {
            return value;
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostString(value)", "interop.isString(value)"})
        StaticObject doForeignString(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                String hostString = interop.asString(value);
                return meta.toGuestString(hostString);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isString returns true, asString must succeed.");
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "!interop.isString(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_String.getTypeAsString());
        }
    }

    @NodeInfo(shortName="List type mapping")
    public static abstract class ToList
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToList(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"interop.hasArrayElements(value)", "interop.hasMetaObject(value)", "!isStaticObject(value)"})
        public StaticObject doMappedList(Object value, @Bind Node node, @Bind(value="getContext()") EspressoContext context, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached InlinedBranchProfile converterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToList.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    converterProfile.enter(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(context.getLanguage(), context.getMeta().java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), context.getMeta().java_util_List)) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, context.getMeta().java_util_List)) != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_List.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType.getRawType())") InstanceOf instanceOf) throws UnsupportedTypeException {
            if (!instanceOf.execute(value.getKlass())) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_List.getTypeAsString());
            }
            return value;
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_List.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Set type mapping")
    public static abstract class ToSet
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToSet(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"interop.hasMetaObject(value)", "isHostObject(getContext(), value)", "!isStaticObject(value)"})
        public StaticObject doMappedSet(Object value, @Bind Node node, @Bind(value="getMeta()") Meta meta, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached InlinedBranchProfile converterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToSet.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    converterProfile.enter(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(meta.getLanguage(), meta.java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), meta.java_util_Set)) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, meta.java_util_Set)) != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Set.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType.getRawType())") InstanceOf instanceOf) throws UnsupportedTypeException {
            if (!instanceOf.execute(value.getKlass())) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Set.getTypeAsString());
            }
            return value;
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Set.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Collection type mapping")
    public static abstract class ToCollection
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToCollection(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"interop.hasIterator(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)", "!isStaticObject(value)"})
        public StaticObject doMappedCollection(Object value, @Bind Node node, @Bind(value="getMeta()") Meta meta, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached InlinedBranchProfile converterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToCollection.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    converterProfile.enter(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(meta.getLanguage(), meta.java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), meta.java_util_Collection)) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, meta.java_util_Collection)) != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Collection.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType.getRawType())") InstanceOf instanceOf) throws UnsupportedTypeException {
            if (!instanceOf.execute(value.getKlass())) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Collection.getTypeAsString());
            }
            return value;
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Collection.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Iterable type mapping")
    public static abstract class ToIterable
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToIterable(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"interop.hasIterator(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)", "!isStaticObject(value)"})
        public StaticObject doMappedIterable(Object value, @Bind Node node, @Bind(value="getMeta()") Meta meta, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached InlinedBranchProfile converterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToIterable.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    converterProfile.enter(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(meta.getLanguage(), meta.java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), meta.java_lang_Iterable)) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, meta.java_lang_Iterable)) != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Iterable.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType.getRawType())") InstanceOf instanceOf) throws UnsupportedTypeException {
            if (!instanceOf.execute(value.getKlass())) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Iterable.getTypeAsString());
            }
            return value;
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Iterable.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Iterator type mapping")
    public static abstract class ToIterator
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToIterator(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"interop.isIterator(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)", "!isStaticObject(value)"})
        public StaticObject doMappedIterator(Object value, @Bind Node node, @Bind(value="getMeta()") Meta meta, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached InlinedBranchProfile converterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToIterator.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    converterProfile.enter(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(meta.getLanguage(), meta.java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), meta.java_util_Iterator)) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, meta.java_util_Iterator)) != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Iterator.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType.getRawType())") InstanceOf instanceOf) throws UnsupportedTypeException {
            if (!instanceOf.execute(value.getKlass())) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Iterator.getTypeAsString());
            }
            return value;
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Iterator.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Map type mapping")
    public static abstract class ToMap
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToMap(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"interop.hasHashEntries(value)", "interop.hasMetaObject(value)", "isHostObject(getContext(), value)", "!isStaticObject(value)"})
        public StaticObject doMappedMap(Object value, @Bind Node node, @Bind(value="getMeta()") Meta meta, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached InlinedBranchProfile converterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToMap.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    converterProfile.enter(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(meta.getLanguage(), meta.java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), meta.java_util_Map)) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, meta.java_util_Map)) != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Map.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType.getRawType())") InstanceOf instanceOf) throws UnsupportedTypeException {
            if (!instanceOf.execute(value.getKlass())) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Map.getTypeAsString());
            }
            return value;
        }

        @Fallback
        public StaticObject unsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Map.getTypeAsString());
        }
    }

    @NodeInfo(shortName="j.l.CharSequence target type")
    @GenerateUncached
    public static abstract class ToCharSequence
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        StaticObject doHostString(String value, @Bind(value="getMeta()") Meta meta) {
            return meta.toGuestString(value);
        }

        @Specialization(guards={"isEspressoString(value, meta)"})
        StaticObject doEspressoString(StaticObject value, @Bind(value="getMeta()") Meta meta) {
            return value;
        }

        @Specialization(guards={"!isEspressoString(value, meta)"})
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_lang_CharSequence)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_CharSequence.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!isHostString(value)", "interop.isString(value)"})
        StaticObject doForeignString(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                String hostString = interop.asString(value);
                return meta.toGuestString(hostString);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isString returns true, asString must succeed.");
            }
        }

        @Fallback
        StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_String.getTypeAsString());
        }
    }

    @NodeInfo(shortName="interface type mapping")
    public static abstract class ToMappedInterface
    extends ToReference {
        protected static final int LIMIT = 4;
        private final EspressoType targetType;

        ToMappedInterface(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), this.targetType.getRawType())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getRawType().getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!interop.isNull(value)", "isHostObject(getContext(), value)"})
        StaticObject doForeignInterface(Object value, @Bind Node node, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToMappedInterface.getMetaName(metaObject, interop), this.targetType.getRawType());
                if (proxyKlass != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw ToMappedInterface.unsupportedType(value, this.targetType.getRawType());
        }
    }

    @NodeInfo(shortName="unknown type mapping")
    @ImportStatic(value={ToReference.class})
    public static abstract class ToUnknown
    extends ToReference {
        protected static final int LIMIT = 4;
        protected final EspressoType targetType;

        ToUnknown(EspressoType targetType) {
            this.targetType = targetType;
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || this.targetType.getRawType().isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getRawType().getTypeAsString());
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)"})
        static StaticObject doForeignWrapper(Object value, @Bind Node node, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="get(node)") EspressoContext context, @Bind(value="targetType") EspressoType target, @Cached(value="getUncachedToReference(targetType, context.getMeta())") ToReference uncachedToReference, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached InlinedBranchProfile unknownProfile, @Cached InlinedBranchProfile noConverterProfile) throws UnsupportedTypeException {
            if (uncachedToReference != null) {
                return uncachedToReference.execute(value);
            }
            unknownProfile.enter(node);
            StaticObject result = ToUnknown.tryConverterForUnknownTarget(value, target, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
            if (result != null) {
                return result;
            }
            if (target.getRawType().isAbstract()) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)target.getRawType().getTypeAsString());
            }
            noConverterProfile.enter(node);
            ToUnknown.checkHasAllFieldsOrThrow(value, (ObjectKlass)target.getRawType(), interop, context.getMeta());
            return StaticObject.createForeign(EspressoLanguage.get(node), target.getRawType(), value, interop);
        }

        @Specialization
        public StaticObject doUnknown(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getRawType().getTypeAsString());
        }
    }

    @NodeInfo(shortName="foreign exception type mapping")
    @GenerateUncached
    public static abstract class ToForeignException
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeignException(Object value, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Bind(value="getContext()") EspressoContext context) {
            return StaticObject.createForeignException(context, value, interop);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), this.getMeta().polyglot.ForeignException)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().polyglot.ForeignException.getTypeAsString());
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().polyglot.ForeignException.getTypeAsString());
        }
    }

    @NodeInfo(shortName="throwable type mapping")
    @GenerateUncached
    public static abstract class ToThrowable
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || meta.java_lang_Throwable.isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Throwable.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspressoException(EspressoException value) {
            return value.getGuestException();
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeign(Object value, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Bind(value="getContext()") EspressoContext context) throws UnsupportedTypeException {
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, this.getMeta().java_lang_Throwable, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
            if (result != null) {
                return result;
            }
            return StaticObject.createForeignException(context, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Throwable.getTypeAsString());
        }
    }

    @NodeInfo(shortName="exception type mapping")
    @GenerateUncached
    public static abstract class ToException
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || meta.java_lang_Exception.isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Exception.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspressoException(EspressoException value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            StaticObject guestException = value.getGuestException();
            if (meta.java_lang_Exception.isAssignableFrom(guestException.getKlass())) {
                return guestException;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_Exception.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeign(Object value, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Bind(value="getContext()") EspressoContext context) throws UnsupportedTypeException {
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, this.getMeta().java_lang_Exception, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
            if (result != null) {
                return result;
            }
            return StaticObject.createForeignException(context, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_Exception.getTypeAsString());
        }
    }

    @NodeInfo(shortName="runtime exception type mapping")
    @GenerateUncached
    public static abstract class ToRuntimeException
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(language, value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || meta.java_lang_RuntimeException.isAssignableFrom(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_RuntimeException.getTypeAsString());
        }

        @Specialization
        public StaticObject doEspressoException(EspressoException value, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            StaticObject guestException = value.getGuestException();
            if (meta.java_lang_RuntimeException.isAssignableFrom(guestException.getKlass())) {
                return guestException;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_lang_RuntimeException.getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "interop.isException(value)", "!isEspressoException(value)"})
        StaticObject doForeign(Object value, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Bind(value="getContext()") EspressoContext context, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso) throws UnsupportedTypeException {
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, this.getMeta().java_lang_RuntimeException, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, context.getMeta());
            if (result != null) {
                return result;
            }
            return StaticObject.createForeignException(context, value, interop);
        }

        @Fallback
        public StaticObject doUnsupported(Object value) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_lang_RuntimeException.getTypeAsString());
        }
    }

    @NodeInfo(shortName="LocalDate type mapping")
    @GenerateUncached
    public static abstract class ToLocalDate
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_LocalDate)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_LocalDate.getTypeAsString());
        }

        @Specialization(guards={"interop.isDate(value)"})
        StaticObject doForeignLocalDate(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                LocalDate localDate = interop.asDate(value);
                return (StaticObject)meta.java_time_LocalDate_of.invokeDirectStatic(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isDate returns true, asDate must succeed.");
            }
        }

        @Specialization(guards={"!interop.isDate(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_LocalDate.getTypeAsString());
        }
    }

    @NodeInfo(shortName="LocalTime type mapping")
    @GenerateUncached
    public static abstract class ToLocalTime
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_LocalTime)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_LocalTime.getTypeAsString());
        }

        @Specialization(guards={"interop.isTime(value)"})
        StaticObject doForeignLocalTime(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                LocalTime localTime = interop.asTime(value);
                return (StaticObject)meta.java_time_LocalTime_of.invokeDirectStatic(localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isTime returns true, asTime must succeed.");
            }
        }

        @Specialization(guards={"!interop.isTime(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_LocalTime.getTypeAsString());
        }
    }

    @NodeInfo(shortName="LocalDateTime type mapping")
    @GenerateUncached
    public static abstract class ToLocalDateTime
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_LocalDateTime)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_LocalDateTime.getTypeAsString());
        }

        @Specialization(guards={"interop.isTime(value)", "interop.isDate(value)"})
        StaticObject doForeignLocalDateTime(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                LocalDate localDate = interop.asDate(value);
                LocalTime localTime = interop.asTime(value);
                StaticObject guestLocalDate = (StaticObject)meta.java_time_LocalDate_of.invokeDirectStatic(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
                StaticObject guestLocalTime = (StaticObject)meta.java_time_LocalTime_of.invokeDirectStatic(localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
                return (StaticObject)meta.java_time_LocalDateTime_of.invokeDirectStatic(guestLocalDate, guestLocalTime);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isDate returns true, asDate must succeed.");
            }
        }

        @Specialization(guards={"!interop.isTime(value)", "!interop.isDate(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_LocalDateTime.getTypeAsString());
        }
    }

    @NodeInfo(shortName="ZonedDateTime type mapping")
    @GenerateUncached
    public static abstract class ToZonedDateTime
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_ZonedDateTime)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_ZonedDateTime.getTypeAsString());
        }

        @Specialization(guards={"interop.isInstant(value)", "interop.isTimeZone(value)"})
        StaticObject doForeignDateTime(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Instant instant = interop.asInstant(value);
                ZoneId zoneId = interop.asTimeZone(value);
                StaticObject guestInstant = (StaticObject)meta.java_time_Instant_ofEpochSecond.invokeDirectStatic(instant.getEpochSecond(), instant.getNano());
                StaticObject guestZoneID = (StaticObject)meta.java_time_ZoneId_of.invokeDirectStatic(meta.toGuestString(zoneId.getId()));
                return (StaticObject)meta.java_time_ZonedDateTime_ofInstant.invokeDirectStatic(guestInstant, guestZoneID);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isTime returns true, asTime must succeed.");
            }
        }

        @Specialization(guards={"!interop.isInstant(value)", "!interop.isTimeZone(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_ZonedDateTime.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Instant type mapping")
    @GenerateUncached
    public static abstract class ToInstant
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_Instant)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_Instant.getTypeAsString());
        }

        @Specialization(guards={"interop.isInstant(value)"})
        StaticObject doForeignInstant(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Instant instant = interop.asInstant(value);
                return (StaticObject)meta.java_time_Instant_ofEpochSecond.invokeDirectStatic(instant.getEpochSecond(), instant.getNano());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isInstant returns true, asInstant must succeed.");
            }
        }

        @Specialization(guards={"!interop.isInstant(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_Instant.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Duration type mapping")
    @GenerateUncached
    public static abstract class ToDuration
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_Duration)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_Duration.getTypeAsString());
        }

        @Specialization(guards={"interop.isDuration(value)"})
        StaticObject doForeignDuration(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Duration duration = interop.asDuration(value);
                StaticObject guestDuration = meta.getAllocator().createNew(meta.java_time_Duration);
                meta.java_time_Duration_seconds.setLong(guestDuration, duration.getSeconds());
                meta.java_time_Duration_nanos.setInt(guestDuration, duration.getNano());
                return guestDuration;
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isDuration returns true, asDuration must succeed.");
            }
        }

        @Specialization(guards={"!interop.isDuration(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_Duration.getTypeAsString());
        }
    }

    @NodeInfo(shortName="ZoneId type mapping")
    @GenerateUncached
    public static abstract class ToZoneId
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_time_ZoneId)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_time_ZoneId.getTypeAsString());
        }

        @Specialization(guards={"interop.isTimeZone(value)"})
        StaticObject doForeignZoneId(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                ZoneId zoneId = interop.asTimeZone(value);
                return (StaticObject)meta.java_time_ZoneId_of.invokeDirectStatic(meta.toGuestString(zoneId.getId()));
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isZoneId returns true, asTimeZone must succeed.");
            }
        }

        @Specialization(guards={"!interop.isTimeZone(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_time_ZoneId.getTypeAsString());
        }
    }

    @NodeInfo(shortName="Date type mapping")
    @GenerateUncached
    public static abstract class ToDate
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_util_Date)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_util_Date.getTypeAsString());
        }

        @Specialization(guards={"interop.isInstant(value)"})
        StaticObject doForeignDate(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                Instant instant = interop.asInstant(value);
                StaticObject guestInstant = (StaticObject)meta.java_time_Instant_ofEpochSecond.invokeDirectStatic(instant.getEpochSecond(), instant.getNano());
                return (StaticObject)meta.java_util_Date_from.invokeDirectStatic(guestInstant);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if isInstant returns true, asInstant must succeed.");
            }
        }

        @Specialization(guards={"!interop.isInstant(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_util_Date.getTypeAsString());
        }
    }

    @NodeInfo(shortName="BigInteger type mapping")
    @GenerateUncached
    public static abstract class ToBigInteger
    extends ToReference {
        protected static final int LIMIT = 4;

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), meta.java_math_BigInteger)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)meta.java_math_BigInteger.getTypeAsString());
        }

        @CompilerDirectives.TruffleBoundary
        private StaticObject toGuestBigInteger(Meta meta, BigInteger bigInteger) {
            byte[] bytes = bigInteger.toByteArray();
            StaticObject guestBigInteger = this.getAllocator().createNew(meta.java_math_BigInteger);
            meta.java_math_BigInteger_init.invokeDirectSpecial(guestBigInteger, StaticObject.wrap(bytes, meta));
            return guestBigInteger;
        }

        @Specialization(guards={"interop.fitsInBigInteger(value)"})
        StaticObject doForeignBigInteger(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Bind(value="getMeta()") Meta meta) {
            try {
                BigInteger bigInteger = interop.asBigInteger(value);
                return this.toGuestBigInteger(meta, bigInteger);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsInBigInteger returns true, asBigInteger must succeed.");
            }
        }

        @Specialization(guards={"!interop.fitsInBigInteger(value)"})
        StaticObject doUnsupported(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.getMeta().java_math_BigInteger.getTypeAsString());
        }
    }

    @NodeInfo(shortName="custom type converter")
    @ImportStatic(value={ToReference.class})
    public static abstract class ToMappedType
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToMappedType(EspressoType targetType) {
            this.targetType = targetType;
        }

        static InstanceOf createInstanceOf(EspressoType targetType) {
            return InstanceOf.create(targetType.getRawType(), false);
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType)") InstanceOf instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getRawType().getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!interop.isNull(value)", "isHostObject(getContext(), value)"})
        StaticObject doForeignConverter(Object value, @Bind Node node, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached InstanceOf.Dynamic instanceOf, @Bind(value="getContext()") EspressoContext context, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToMappedType.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    StaticObject result;
                    StaticObject foreign = interop.isException(value) ? StaticObject.createForeignException(context, value, interop) : StaticObject.createForeign(this.getLanguage(), this.targetType.getRawType(), value, interop);
                    EspressoType espressoType = this.targetType;
                    if (espressoType instanceof ParameterizedEspressoType) {
                        ParameterizedEspressoType parameterizedEspressoType = (ParameterizedEspressoType)espressoType;
                        context.getLanguage().getTypeArgumentProperty().setObject((Object)foreign, (Object)parameterizedEspressoType.getTypeArguments());
                    }
                    if (instanceOf.execute((result = (StaticObject)converter.convert(foreign)).getKlass(), this.targetType.getRawType())) {
                        return result;
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw ToEspressoNode.unsupportedType(value, this.targetType.getRawType());
        }
    }

    @NodeInfo(shortName="custom type converter")
    @ImportStatic(value={ToReference.class})
    public static abstract class ToMappedInternalType
    extends ToReference {
        protected static final int LIMIT = 4;
        final EspressoType targetType;

        ToMappedInternalType(EspressoType targetType) {
            this.targetType = targetType;
        }

        static InstanceOf createInstanceOf(EspressoType targetType) {
            return InstanceOf.create(targetType.getRawType(), false);
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        StaticObject doForeignNull(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization
        public StaticObject doEspresso(StaticObject value, @Cached(value="createInstanceOf(targetType)") InstanceOf instanceOf) throws UnsupportedTypeException {
            assert (!value.isForeignObject());
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass())) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)this.targetType.getRawType().getTypeAsString());
        }

        @Specialization(guards={"!isStaticObject(value)", "!interop.isNull(value)", "isHostObject(getContext(), value)"})
        StaticObject doForeignInternalConverter(Object value, @Cached.Shared(value="value") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupInternalTypeConverterNode lookupTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached InlinedBranchProfile errorProfile, @Bind(value="getMeta()") Meta meta) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToMappedInternalType.getMetaName(metaObject, interop);
                PolyglotTypeMappings.InternalTypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    return converter.convertInternal(interop, value, meta, converterToEspresso, this.targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter((Node)this);
            throw ToEspressoNode.unsupportedType(value, this.targetType.getRawType());
        }
    }

    @NodeInfo(shortName="Dynamic toEspresso node")
    @GenerateUncached
    public static abstract class DynamicToReference
    extends EspressoNode {
        protected static final int LIMIT = 4;

        public abstract StaticObject execute(Object var1, EspressoType var2) throws UnsupportedTypeException;

        protected static ToReference createToEspressoNode(EspressoType targetType) {
            return ToReference.createToReference(targetType, targetType.getRawType().getMeta());
        }

        @Specialization(guards={"targetType == cachedTargetType"}, limit="LIMIT")
        public StaticObject doCached(Object value, EspressoType targetType, @Cached(value="targetType") EspressoType cachedTargetType, @Cached(value="createToEspressoNode(cachedTargetType)") ToReference toEspressoNode) throws UnsupportedTypeException {
            return toEspressoNode.execute(value);
        }

        @Specialization(replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        public StaticObject doGeneric(Object value, EspressoType targetType, @Cached GenericToReference genericToReference) throws UnsupportedTypeException {
            return genericToReference.execute(value, targetType);
        }
    }

    @NodeInfo(shortName="Generic toEspresso node")
    @GenerateUncached
    @ImportStatic(value={ToEspressoNode.class})
    public static abstract class GenericToReference
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract StaticObject execute(Object var1, EspressoType var2) throws UnsupportedTypeException;

        @Specialization
        public StaticObject doStaticObject(StaticObject value, EspressoType targetType, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            Klass rawType = targetType.getRawType();
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), rawType)) {
                return value;
            }
            try {
                Meta meta = this.getMeta();
                if (rawType == meta.java_lang_Double && EspressoInterop.fitsInDouble(value)) {
                    return meta.boxDouble(EspressoInterop.asDouble(value));
                }
                if (rawType == meta.java_lang_Float && EspressoInterop.fitsInFloat(value)) {
                    return meta.boxFloat(EspressoInterop.asFloat(value));
                }
                if (rawType == meta.java_lang_Long && EspressoInterop.fitsInLong(value)) {
                    return meta.boxLong(EspressoInterop.asLong(value));
                }
                if (rawType == meta.java_lang_Integer && EspressoInterop.fitsInInt(value)) {
                    return meta.boxInteger(EspressoInterop.asInt(value));
                }
                if (rawType == meta.java_lang_Short && EspressoInterop.fitsInShort(value)) {
                    return meta.boxShort(EspressoInterop.asShort(value));
                }
                if (rawType == meta.java_lang_Byte && EspressoInterop.fitsInByte(value)) {
                    return meta.boxByte(EspressoInterop.asByte(value));
                }
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("Contract violation: if fitsIn* returns true, as* must succeed.");
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", targetType.getRawType().getTypeAsString()));
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doForeignNull(Object value, EspressoType targetType, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeMappingEnabled(targetType)", "!isStaticObject(value)"})
        public static StaticObject doMappedInterface(Object value, EspressoType targetType, @Bind Node node, @Cached LookupProxyKlassNode lookupProxyKlassNode, @Cached ProxyInstantiateNode proxyInstantiateNode, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached @Cached.Shared InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                WrappedProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToEspressoNode.getMetaName(metaObject, interop), targetType.getRawType());
                if (proxyKlass != null) {
                    return proxyInstantiateNode.execute(proxyKlass, value, targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw ToEspressoNode.unsupportedType(value, targetType.getRawType());
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)"})
        public StaticObject doArray(Object value, ArrayKlass targetType, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop) throws UnsupportedTypeException {
            if (targetType == this.getMeta()._byte_array && interop.hasBufferElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(this), this.getMeta()._byte_array, value, interop);
            }
            if (interop.hasArrayElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(this), targetType, value, interop);
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public static StaticObject doTypeConverter(Object value, EspressoType targetType, @Bind Node node, @Cached @Cached.Exclusive LookupTypeConverterNode lookupTypeConverterNode, @Cached @Cached.Shared InlinedBranchProfile errorProfile, @Cached InstanceOf.Dynamic instanceOf, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    StaticObject result;
                    StaticObject foreign = interop.isException(value) ? StaticObject.createForeignException(EspressoContext.get(node), value, interop) : StaticObject.createForeign(EspressoLanguage.get(node), targetType.getRawType(), value, interop);
                    if (targetType instanceof ParameterizedEspressoType) {
                        ParameterizedEspressoType parameterizedEspressoType = (ParameterizedEspressoType)targetType;
                        EspressoLanguage.get(node).getTypeArgumentProperty().setObject((Object)foreign, (Object)parameterizedEspressoType.getTypeArguments());
                    }
                    if (instanceOf.execute((result = (StaticObject)converter.convert(foreign)).getKlass(), targetType.getRawType())) {
                        return result;
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw ToEspressoNode.unsupportedType(value, targetType.getRawType());
        }

        @Specialization(guards={"!interop.isNull(value)", "isInternalTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public static StaticObject doInternalTypeConverter(Object value, EspressoType targetType, @Bind Node node, @Cached @Cached.Exclusive LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached @Cached.Exclusive DynamicToReference converterToEspresso, @Cached @Cached.Shared InlinedBranchProfile errorProfile, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.InternalTypeConverter converter = lookupInternalTypeConverterNode.execute(metaName);
                if (converter != null) {
                    return converter.convertInternal(interop, value, EspressoContext.get(node).getMeta(), converterToEspresso, targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw ToEspressoNode.unsupportedType(value, targetType.getRawType());
        }

        @Specialization(guards={"!interop.isNull(value)", "isBuiltInCollectionMapped(targetType)", "!isStaticObject(value)"})
        public static StaticObject doBuiltinTypeConverter(Object value, EspressoType targetType, @Bind Node node, @Cached @Cached.Exclusive LookupTypeConverterNode lookupTypeConverterNode, @Cached @Cached.Exclusive LookupProxyKlassNode lookupProxyKlassNode, @Cached @Cached.Exclusive ProxyInstantiateNode proxyInstantiatorNode, @CachedLibrary(limit="LIMIT") @Cached.Exclusive InteropLibrary interop, @Cached InstanceOf.Dynamic instanceOf, @Cached InlinedBranchProfile noConverterProfile, @Cached InlinedBranchProfile errorProfile) throws UnsupportedTypeException {
            try {
                WrappedProxyKlass proxyKlass;
                Object metaObject = interop.getMetaObject(value);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                Klass rawType = targetType.getRawType();
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverterNode.execute(metaName);
                if (converter != null) {
                    noConverterProfile.enter(node);
                    EspressoContext context = EspressoContext.get(node);
                    StaticObject foreignWrapper = StaticObject.createForeign(context.getLanguage(), context.getMeta().java_lang_Object, value, interop);
                    StaticObject result = (StaticObject)converter.convert(foreignWrapper);
                    if (instanceOf.execute(result.getKlass(), targetType.getRawType())) {
                        return result;
                    }
                }
                if ((proxyKlass = lookupProxyKlassNode.execute(metaObject, metaName, rawType)) != null) {
                    return proxyInstantiatorNode.execute(proxyKlass, value, targetType);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            errorProfile.enter(node);
            throw ToEspressoNode.unsupportedType(value, targetType.getRawType());
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)", "!isArray(targetType)", "!isTypeConverterEnabled(targetType)", "!isInternalTypeConverterEnabled(targetType)", "!isBuiltInCollectionMapped(targetType)", "!isTypeMappingEnabled(targetType)"})
        public static StaticObject doGeneric(Object value, EspressoType targetType, @Bind Node node, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached LookupTypeConverterNode lookupTypeConverterNode, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverterNode, @Cached DynamicToReference converterToEspresso, @Cached InlinedBranchProfile unknownProfile, @Cached InlinedBranchProfile noConverterProfile) throws UnsupportedTypeException {
            Meta meta = EspressoContext.get(node).getMeta();
            ToReference uncachedToReference = ToReference.getUncachedToReference(targetType, meta);
            if (uncachedToReference != null) {
                return uncachedToReference.execute(value);
            }
            unknownProfile.enter(node);
            StaticObject result = ToReference.tryConverterForUnknownTarget(value, targetType, interop, lookupTypeConverterNode, lookupInternalTypeConverterNode, converterToEspresso, meta);
            if (result != null) {
                return result;
            }
            if (targetType.getRawType().isAbstract()) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getRawType().getTypeAsString());
            }
            if (targetType instanceof ObjectKlass) {
                ObjectKlass rawType = (ObjectKlass)targetType;
                noConverterProfile.enter(node);
                ToEspressoNode.checkHasAllFieldsOrThrow(value, rawType, interop, meta);
                return StaticObject.createForeign(EspressoLanguage.get(node), rawType, value, interop);
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getRawType().getTypeAsString());
        }
    }
}

