/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.ParameterizedEspressoType;
import com.oracle.truffle.espresso.impl.generics.reflectiveObjects.ParameterizedTypeImpl;
import com.oracle.truffle.espresso.impl.generics.reflectiveObjects.ParameterizedTypeVariable;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Collections;
import java.util.Map;

public final class WrappedProxyKlass {
    private final ObjectKlass proxyKlass;
    private final EspressoType[] genericTypeArray;
    private final Map<String, Integer> typeVariableIdentifiers;

    WrappedProxyKlass(ObjectKlass proxyKlass, EspressoType[] genericTypeArray, Map<String, Integer> typeVariableIdentifiers) {
        this.proxyKlass = proxyKlass;
        this.genericTypeArray = genericTypeArray;
        this.typeVariableIdentifiers = typeVariableIdentifiers;
    }

    WrappedProxyKlass(ObjectKlass proxyKlass, int numTypeIdentifiers) {
        this.proxyKlass = proxyKlass;
        this.typeVariableIdentifiers = Collections.emptyMap();
        this.genericTypeArray = new EspressoType[numTypeIdentifiers];
    }

    StaticObject createProxyInstance(EspressoType[] resolvedGenericTypes, Object foreignObject, InteropLibrary interop, EspressoLanguage language) {
        StaticObject foreign = StaticObject.createForeign(language, this.proxyKlass, foreignObject, interop);
        language.getTypeArgumentProperty().setObject((Object)foreign, (Object)resolvedGenericTypes);
        return foreign;
    }

    @CompilerDirectives.TruffleBoundary
    EspressoType[] fillTypeArguments(EspressoType[] types) {
        EspressoType[] result = (EspressoType[])this.genericTypeArray.clone();
        System.arraycopy(types, 0, result, 0, types.length);
        this.fillTypeVariableTypes(result);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    EspressoType[] fillTypeArguments() {
        EspressoType[] result = (EspressoType[])this.genericTypeArray.clone();
        this.fillTypeVariableTypes(result);
        return result;
    }

    private void fillTypeVariableTypes(EspressoType[] types) {
        for (int i = this.typeVariableIdentifiers.size(); i < types.length; ++i) {
            EspressoType returnType = types[i];
            if (returnType == null) {
                types[i] = this.proxyKlass.getMeta().java_lang_Object;
                continue;
            }
            if (!(returnType instanceof ParameterizedEspressoType)) continue;
            ParameterizedEspressoType parameterizedReturnType = (ParameterizedEspressoType)returnType;
            types[i] = this.resolveType(parameterizedReturnType, this.typeVariableIdentifiers, this.proxyKlass.getMeta(), types);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private EspressoType resolveType(ParameterizedEspressoType type, Map<String, Integer> identifiers, Meta meta, EspressoType[] types) {
        EspressoType[] typeArguments = type.getTypeArguments();
        for (int i = 0; i < typeArguments.length; ++i) {
            EspressoType typeArgument = typeArguments[i];
            if (typeArgument instanceof ParameterizedTypeVariable) {
                ParameterizedTypeVariable variable = (ParameterizedTypeVariable)typeArgument;
                Integer variableIndex = identifiers.get(variable.getIdentifier());
                if (variableIndex == null) {
                    typeArguments[i] = meta.java_lang_Object;
                    continue;
                }
                typeArguments[i] = types[variableIndex];
                continue;
            }
            if (!(typeArgument instanceof ParameterizedEspressoType)) continue;
            ParameterizedEspressoType argType = (ParameterizedEspressoType)typeArgument;
            typeArguments[i] = this.resolveType(argType, identifiers, meta, types);
        }
        return ParameterizedTypeImpl.make(type.getRawType(), typeArguments, type.getOwnerType());
    }
}

