/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.methodhandle;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.methodhandle.LinkToInterfaceNode;
import com.oracle.truffle.espresso.nodes.methodhandle.LinkToSpecialNode;
import com.oracle.truffle.espresso.nodes.methodhandle.LinkToStaticNode;
import com.oracle.truffle.espresso.nodes.methodhandle.LinkToVirtualNode;
import com.oracle.truffle.espresso.nodes.methodhandle.Linker;
import com.oracle.truffle.espresso.nodes.methodhandle.MethodHandleIntrinsicNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeDynamicCallSiteNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.MethodHandleIntrinsics;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class MHLinkToNode
extends MethodHandleIntrinsicNode {
    private final int argCount;
    private final Linker linker;
    private final Field hiddenVmtarget;
    private final boolean hasReceiver;
    static final int INLINE_CACHE_SIZE_LIMIT = 5;

    MHLinkToNode(Method method, MethodHandleIntrinsics.PolySigIntrinsics id) {
        super(method);
        this.argCount = Signatures.parameterCount(method.getParsedSignature());
        this.hiddenVmtarget = method.getMeta().HIDDEN_VMTARGET;
        this.hasReceiver = id != MethodHandleIntrinsics.PolySigIntrinsics.LinkToStatic;
        this.linker = MHLinkToNode.findLinker(id);
        assert (method.isStatic());
    }

    @Override
    public Object call(Object[] args) {
        assert (this.getMethod().isStatic());
        Method.MethodVersion resolutionSeed = this.getTarget(args);
        Object[] basicArgs = MHLinkToNode.unbasic(args, resolutionSeed.getMethod().getParsedSignature(), 0, this.argCount - 1, this.hasReceiver);
        if (!resolutionSeed.getRedefineAssumption().isValid() && resolutionSeed.getMethod().isRemovedByRedefinition()) {
            ObjectKlass receiverKlass = this.hasReceiver ? ((StaticObject)basicArgs[0]).getKlass() : resolutionSeed.getMethod().getDeclaringKlass();
            resolutionSeed = EspressoContext.get(this).getClassRedefinition().handleRemovedMethod(resolutionSeed.getMethod(), receiverKlass).getMethodVersion();
        }
        Method target = this.linker.linkTo(resolutionSeed.getMethod(), args);
        Object result = this.executeCall(basicArgs, target.getMethodVersion());
        return MHLinkToNode.rebasic(result, target.getReturnKind());
    }

    protected abstract Object executeCall(Object[] var1, Method.MethodVersion var2);

    public static boolean canInline(Method.MethodVersion target, Method.MethodVersion cachedTarget) {
        return target.getMethod().identity() == cachedTarget.getMethod().identity();
    }

    @Specialization(limit="INLINE_CACHE_SIZE_LIMIT", guards={"inliningEnabled()", "canInline(target, cachedTarget)"})
    Object doCallDirect(Object[] args, Method.MethodVersion target, @Cached(value="target") Method.MethodVersion cachedTarget, @Cached(value="create(target.getCallTarget())") DirectCallNode directCallNode) {
        hits.inc();
        return directCallNode.call(args);
    }

    @Specialization(replaces={"doCallDirect"})
    Object doCallIndirect(Object[] args, Method.MethodVersion target, @Cached(value="create()") IndirectCallNode callNode) {
        miss.inc();
        return callNode.call(target.getCallTarget(), args);
    }

    @ExplodeLoop
    static Object[] unbasic(Object[] args, Symbol<Symbol.Type>[] targetSig, int from, int length, boolean inclReceiver) {
        Object[] res = new Object[length];
        int start = 0;
        if (inclReceiver) {
            res[start++] = args[from];
        }
        for (int i = start; i < length; ++i) {
            Symbol<Symbol.Type> t = Signatures.parameterType(targetSig, i - start);
            res[i] = InvokeDynamicCallSiteNode.unbasic(args[i + from], t);
        }
        return res;
    }

    public static Object rebasic(Object obj, JavaKind rKind) {
        switch (rKind) {
            case Boolean: {
                return (Boolean)obj != false ? 1 : 0;
            }
            case Byte: {
                return (int)((Byte)obj).byteValue();
            }
            case Char: {
                return (int)((Character)obj).charValue();
            }
            case Short: {
                return (int)((Short)obj).shortValue();
            }
        }
        return obj;
    }

    private static Linker findLinker(MethodHandleIntrinsics.PolySigIntrinsics id) {
        switch (id) {
            case LinkToVirtual: {
                return LinkToVirtualNode.virtualLinker;
            }
            case LinkToStatic: {
                return LinkToStaticNode.staticLinker;
            }
            case LinkToSpecial: {
                return LinkToSpecialNode.specialLinker;
            }
            case LinkToInterface: {
                return LinkToInterfaceNode.interfaceLinker;
            }
        }
        throw EspressoError.shouldNotReachHere("unrecognized linkTo intrinsic: " + String.valueOf((Object)id));
    }

    private Method.MethodVersion getTarget(Object[] args) {
        assert (args.length >= 1);
        StaticObject memberName = (StaticObject)args[args.length - 1];
        assert (memberName.getKlass().getType() == Symbol.Type.java_lang_invoke_MemberName);
        return ((Method)this.hiddenVmtarget.getHiddenObject(memberName)).getMethodVersion();
    }
}

