/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.methodhandle;

import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.perf.DebugCounter;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoNode;

public abstract class MethodHandleIntrinsicNode
extends EspressoNode {
    protected static final DebugCounter hits = DebugCounter.create("MH cache hits");
    protected static final DebugCounter miss = DebugCounter.create("MH cache miss");
    protected final Method method;

    public MethodHandleIntrinsicNode(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    @Idempotent
    public boolean inliningEnabled() {
        return this.getContext().getEspressoEnv().InlineMethodHandle;
    }

    public abstract Object call(Object[] var1);

    public Object processReturnValue(Object obj, JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return (Integer)obj != 0;
            }
            case Byte: {
                return (byte)((Integer)obj).intValue();
            }
            case Char: {
                return Character.valueOf((char)((Integer)obj).intValue());
            }
            case Short: {
                return (short)((Integer)obj).intValue();
            }
        }
        return obj;
    }
}

