/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.nodes.BciProvider;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.quick.BaseQuickNodeWrapper;
import com.oracle.truffle.espresso.vm.continuation.UnwindContinuationException;

@ExportLibrary(value=NodeLibrary.class)
@GenerateWrapper(yieldExceptions={UnwindContinuationException.class})
public abstract class BaseQuickNode
extends EspressoNode
implements BciProvider,
InstrumentableNode {
    public static final BaseQuickNode[] EMPTY_ARRAY = new BaseQuickNode[0];

    public abstract int execute(VirtualFrame var1, boolean var2);

    public boolean isInstrumentable() {
        return true;
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probeNode) {
        return new BaseQuickNodeWrapper(this, probeNode);
    }

    public boolean removedByRedefinition() {
        return false;
    }

    @ExplodeLoop
    public final BytecodeNode getBytecodeNode() {
        Node parent = this.getParent();
        while (!(parent instanceof BytecodeNode)) {
            parent = parent.getParent();
        }
        return (BytecodeNode)parent;
    }

    @ExportMessage
    public final boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    public final Object getScope(Frame frame, boolean nodeEnter) {
        return this.getScopeSlowPath(frame != null ? frame.materialize() : null, nodeEnter);
    }

    @CompilerDirectives.TruffleBoundary
    private Object getScopeSlowPath(MaterializedFrame frame, boolean nodeEnter) {
        return this.getBytecodeNode().getScope((Frame)frame, nodeEnter);
    }
}

