/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.nodes.quick.BaseQuickNode;
import com.oracle.truffle.espresso.vm.continuation.UnwindContinuationException;

@GeneratedBy(value=BaseQuickNode.class)
final class BaseQuickNodeWrapper
extends BaseQuickNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private BaseQuickNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    BaseQuickNodeWrapper(BaseQuickNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public BaseQuickNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        int returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame, isContinuationResume);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, (Object)returnValue);
            }
            catch (UnwindContinuationException e) {
                this.probeNode.onYield(frame, e.getYieldValue());
                throw e;
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = (Integer)result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public int getBci(Frame frame) {
        return this.delegateNode.getBci(frame);
    }
}

