/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class CheckCastQuickNode
extends QuickNode {
    static final int stackEffectOf_CHECKCAST = Bytecodes.stackEffectOf(192);
    final Klass typeToCheck;
    @Node.Child
    InstanceOf instanceOf;

    public CheckCastQuickNode(Klass typeToCheck, int top, int callerBCI) {
        super(top, callerBCI);
        assert (!typeToCheck.isPrimitive());
        this.typeToCheck = typeToCheck;
        this.instanceOf = InstanceOf.create(typeToCheck, true);
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        BytecodeNode root = this.getBytecodeNode();
        StaticObject receiver = EspressoFrame.peekObject((Frame)frame, this.top - 1);
        if (StaticObject.isNull(receiver) || this.instanceOf.execute(receiver.getKlass())) {
            return stackEffectOf_CHECKCAST;
        }
        root.enterImplicitExceptionProfile();
        EspressoFrame.popObject((Frame)frame, this.top - 1);
        Meta meta = this.typeToCheck.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, this.getExceptionMessage(root, receiver));
    }

    @CompilerDirectives.TruffleBoundary
    private String getExceptionMessage(BytecodeNode root, StaticObject receiver) {
        return String.valueOf(receiver.getKlass().getType()) + " cannot be cast to: " + String.valueOf(this.typeToCheck.getType()) + " in context " + root.getMethod().toString();
    }
}

