/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeContinuableNode;

@GeneratedBy(value=InvokeContinuableNode.class)
final class InvokeContinuableNodeWrapper
extends InvokeContinuableNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private InvokeContinuableNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    InvokeContinuableNodeWrapper(InvokeContinuableNode copy, InvokeContinuableNode delegateNode, ProbeNode probeNode) {
        super(copy);
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public InvokeContinuableNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    protected int resumeContinuation(VirtualFrame frame) {
        int returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onResume(frame);
                returnValue = this.delegateNode.resumeContinuation(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, (Object)returnValue);
            }
            catch (BytecodeNode.EspressoOSRReturnException e) {
                this.probeNode.onYield(frame, e.getYieldValue());
                throw e;
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = (Integer)result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }
}

