/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.methodhandle.MHInvokeGenericNode;
import com.oracle.truffle.espresso.nodes.methodhandle.MethodHandleIntrinsicNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class InvokeHandleNode
extends InvokeQuickNode {
    @Node.Child
    private MethodHandleIntrinsicNode intrinsic;
    private final boolean hasReceiver;
    private final int argCount;

    public InvokeHandleNode(Method method, MHInvokeGenericNode.MethodHandleInvoker invoker, int top, int curBCI) {
        super(method, top, curBCI);
        this.hasReceiver = !method.isStatic();
        this.intrinsic = (MethodHandleIntrinsicNode)this.insert(method.spawnIntrinsicNode(invoker));
        this.argCount = method.getParameterCount() + (method.isStatic() ? 0 : 1) + (method.isInvokeIntrinsic() ? 1 : 0);
    }

    @Override
    protected Object[] getArguments(VirtualFrame frame) {
        Object[] args = new Object[this.argCount];
        EspressoFrame.popBasicArgumentsWithArray(frame, this.top, this.method.getMethod().getParsedSignature(), this.hasReceiver, args);
        return args;
    }

    @Override
    public int execute(VirtualFrame frame, boolean isContinuationResume) {
        Object[] args = this.getArguments(frame);
        if (this.hasReceiver) {
            this.nullCheck((StaticObject)args[0]);
        }
        return this.pushResult(frame, this.intrinsic.processReturnValue(this.intrinsic.call(args), this.method.getMethod().getReturnKind()));
    }
}

