/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeSpecialQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeStaticQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeVirtualQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.GuardedInlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodPredicate;
import com.oracle.truffle.espresso.resolver.ResolvedCall;

public class ConditionalInlinedMethodNode
extends InlinedMethodNode {
    private final Recipes recipes;
    @Node.Child
    protected InvokeQuickNode fallbackNode;
    private final InlinedMethodPredicate condition;

    public ConditionalInlinedMethodNode(ResolvedCall resolvedCall, int top, int opcode, int callerBCI, int statementIndex, Recipes recipes, InlinedMethodPredicate condition) {
        super(resolvedCall.getResolvedMethod().getMethodVersion(), top, opcode, callerBCI, statementIndex, null);
        this.fallbackNode = ConditionalInlinedMethodNode.getFallback(resolvedCall, top, callerBCI);
        this.condition = condition;
        this.recipes = recipes;
    }

    @Override
    public final int execute(VirtualFrame frame, boolean isContinuationResume) {
        this.preludeChecks(frame);
        if (this.condition.isValid(this.getContext(), this.method, frame, this)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            InlinedMethodNode replacement = ConditionalInlinedMethodNode.getDefinitiveNode(this.recipes, this.inlinedMethod(), this.top, this.opcode, this.getCallerBCI(), this.statementIndex);
            return this.getBytecodeNode().replaceQuickAt(frame, this.opcode, this.getCallerBCI(), this, replacement);
        }
        return this.fallbackNode.execute(frame, false);
    }

    public static InlinedMethodNode getDefinitiveNode(Recipes recipes, Method.MethodVersion inlinedMethod, int top, int opcode, int callerBci, int statementIndex) {
        InlinedMethodNode.BodyNode newBody = recipes.cookBody();
        InlinedMethodPredicate guard = recipes.cookGuard();
        InlinedMethodNode replacement = guard == null ? new InlinedMethodNode(inlinedMethod, top, opcode, callerBci, statementIndex, newBody) : new GuardedInlinedMethodNode(inlinedMethod, top, opcode, callerBci, statementIndex, newBody, guard);
        return replacement;
    }

    static InvokeQuickNode getFallback(ResolvedCall resolvedCall, int top, int callerBCI) {
        switch (resolvedCall.getCallKind()) {
            case STATIC: {
                return new InvokeStaticQuickNode(resolvedCall.getResolvedMethod(), top, callerBCI);
            }
            case DIRECT: {
                return new InvokeSpecialQuickNode(resolvedCall.getResolvedMethod(), top, callerBCI);
            }
            case VTABLE_LOOKUP: {
                return new InvokeVirtualQuickNode(resolvedCall.getResolvedMethod(), top, callerBCI);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.unimplemented("Conditional bytecode-level inlining only available for invokestatic, invokespecial and invokevirtual");
    }

    public static interface Recipes {
        public InlinedMethodNode.BodyNode cookBody();

        public InlinedMethodPredicate cookGuard();
    }
}

