/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.preinit;

import com.oracle.truffle.espresso.classfile.ClassfileParser;
import com.oracle.truffle.espresso.classfile.ClassfileStream;
import com.oracle.truffle.espresso.classfile.ParserException;
import com.oracle.truffle.espresso.classfile.ParserKlass;
import com.oracle.truffle.espresso.classfile.ParsingContext;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.verifier.MethodVerifier;

public interface ParserKlassProvider {
    public ParserKlass getParserKlass(ClassLoadingEnv var1, StaticObject var2, Symbol<Symbol.Type> var3, byte[] var4, ClassRegistry.ClassDefinitionInfo var5);

    default public int getCachedParserKlassCount() {
        return 0;
    }

    public static ParserKlass parseKlass(ClassRegistry.ClassDefinitionInfo info, ClassLoadingEnv env, StaticObject loader, Symbol<Symbol.Type> typeOrNull, byte[] bytes) {
        boolean verifiable = MethodVerifier.needsVerify(env.getLanguage(), loader);
        boolean loaderIsBootOrPlatform = env.loaderIsBootOrPlatform(loader);
        Meta meta = env.getMeta();
        try {
            return ClassfileParser.parse(env.getParsingContext(), new ClassfileStream(bytes, null), verifiable, loaderIsBootOrPlatform, typeOrNull, info.isHidden, info.forceAllowVMAnnotations);
        }
        catch (ParserException.ClassFormatError | ValidationException validationOrBadFormat) {
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, validationOrBadFormat.getMessage());
        }
        catch (ParserException.UnsupportedClassVersionError unsupportedClassVersionError) {
            throw meta.throwExceptionWithMessage(meta.java_lang_UnsupportedClassVersionError, unsupportedClassVersionError.getMessage());
        }
        catch (ParserException.NoClassDefFoundError noClassDefFoundError) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, noClassDefFoundError.getMessage());
        }
        catch (ParserException parserException) {
            throw EspressoError.shouldNotReachHere("Not a validation nor parser exception", parserException);
        }
    }

    public static Symbol<Symbol.Name> getClassName(Meta meta, ParsingContext parsingContext, byte[] bytes) {
        try {
            return ClassfileParser.getClassName(parsingContext, bytes);
        }
        catch (ParserException.ClassFormatError | ValidationException validationOrBadFormat) {
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, validationOrBadFormat.getMessage());
        }
        catch (ParserException.UnsupportedClassVersionError unsupportedClassVersionError) {
            throw meta.throwExceptionWithMessage(meta.java_lang_UnsupportedClassVersionError, unsupportedClassVersionError.getMessage());
        }
        catch (ParserException.NoClassDefFoundError noClassDefFoundError) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, noClassDefFoundError.getMessage());
        }
        catch (ParserException parserException) {
            throw EspressoError.shouldNotReachHere("Not a validation nor parser exception", parserException);
        }
    }
}

