/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.ImmutableConstantPool;
import com.oracle.truffle.espresso.classfile.ParserField;
import com.oracle.truffle.espresso.classfile.ParserKlass;
import com.oracle.truffle.espresso.classfile.ParserMethod;
import com.oracle.truffle.espresso.classfile.attributes.EnclosingMethodAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jdwp.api.RedefineInfo;
import com.oracle.truffle.espresso.meta.ModifiersProvider;
import com.oracle.truffle.espresso.preinit.ParserKlassProvider;
import com.oracle.truffle.espresso.redefinition.HotSwapClassInfo;
import com.oracle.truffle.espresso.redefinition.ImmutableClassInfo;
import com.oracle.truffle.espresso.redefinition.InnerClassRedefiner;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;

public abstract class ClassInfo {
    private final boolean isNewInnerTestKlass;
    private final boolean isEnumSwitchmapHelper;

    public ClassInfo(boolean isEnumSwitchmapHelper, boolean isNewInnerTestKlass) {
        this.isEnumSwitchmapHelper = isEnumSwitchmapHelper;
        this.isNewInnerTestKlass = isNewInnerTestKlass;
    }

    public boolean isNewInnerTestKlass() {
        return this.isNewInnerTestKlass;
    }

    public boolean isEnumSwitchmapHelper() {
        return this.isEnumSwitchmapHelper;
    }

    public static ImmutableClassInfo create(Klass klass, InnerClassRedefiner innerClassRedefiner) {
        StringBuilder hierarchy = new StringBuilder();
        StringBuilder methods = new StringBuilder();
        StringBuilder fields = new StringBuilder();
        StringBuilder enclosing = new StringBuilder();
        Symbol<Symbol.Name> name = klass.getName();
        boolean enumHelper = false;
        Matcher matcher = InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(name.toString());
        if (matcher.matches()) {
            if (klass.getDeclaredFields().length == 1 && klass.getDeclaredFields()[0].getName().toString().startsWith("$SwitchMap$")) {
                enumHelper = true;
            }
            if (!enumHelper) {
                hierarchy.append(klass.getSuperClass().getTypeAsString()).append(";");
                for (Klass klass2 : klass.getImplementedInterfaces()) {
                    hierarchy.append(klass2.getTypeAsString()).append(";");
                }
                for (ModifiersProvider modifiersProvider : klass.getDeclaredMethods()) {
                    methods.append(((Method)modifiersProvider).getNameAsString()).append(";");
                    methods.append(((Method)modifiersProvider).getSignatureAsString()).append(";");
                }
                for (ModifiersProvider modifiersProvider : klass.getDeclaredFields()) {
                    fields.append(((Field)modifiersProvider).getTypeAsString()).append(";");
                    fields.append(((Field)modifiersProvider).getNameAsString()).append(";");
                }
                ObjectKlass objectKlass = (ObjectKlass)klass;
                ConstantPool pool = klass.getConstantPool();
                NameAndTypeConstant nmt = pool.nameAndTypeAt(objectKlass.getEnclosingMethod().getMethodIndex());
                enclosing.append(nmt.getName(pool)).append(";").append(nmt.getDescriptor(pool));
            }
        }
        ArrayList<ImmutableClassInfo> inners = new ArrayList<ImmutableClassInfo>(1);
        Set<ObjectKlass> loadedInnerClasses = innerClassRedefiner.findLoadedInnerClasses(klass);
        for (Klass klass3 : loadedInnerClasses) {
            matcher = InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(klass3.getNameAsString());
            if (!matcher.matches()) continue;
            inners.add(innerClassRedefiner.getGlobalClassInfo(klass3));
        }
        return new ImmutableClassInfo((ObjectKlass)klass, name, klass.getDefiningClassLoader(), hierarchy.toString(), methods.toString(), fields.toString(), enclosing.toString(), inners, null, enumHelper, false);
    }

    public static HotSwapClassInfo create(RedefineInfo redefineInfo, EspressoContext context, boolean isNewInnerTestKlass) {
        ObjectKlass klass = (ObjectKlass)redefineInfo.getKlass();
        return ClassInfo.create(klass, klass.getName(), redefineInfo.getClassBytes(), klass.getDefiningClassLoader(), context, isNewInnerTestKlass);
    }

    public static HotSwapClassInfo create(Symbol<Symbol.Name> name, byte[] bytes, StaticObject definingLoader, EspressoContext context, boolean isNewInnerTestKlass) {
        return ClassInfo.create(null, name, bytes, definingLoader, context, isNewInnerTestKlass);
    }

    public static HotSwapClassInfo create(ObjectKlass klass, Symbol<Symbol.Name> name, byte[] bytes, StaticObject definingLoader, EspressoContext context, boolean isNewInnerTestKlass) {
        Symbol<Symbol.Type> type = context.getTypes().fromName(name);
        ParserKlass parserKlass = ParserKlassProvider.parseKlass(ClassRegistry.ClassDefinitionInfo.EMPTY, context.getClassLoadingEnv(), definingLoader, type, bytes);
        StringBuilder hierarchy = new StringBuilder();
        StringBuilder methods = new StringBuilder();
        StringBuilder fields = new StringBuilder();
        StringBuilder enclosing = new StringBuilder();
        boolean enumHelper = false;
        Matcher matcher = InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(name.toString());
        if (matcher.matches()) {
            if (parserKlass.getFields().length == 1 && parserKlass.getFields()[0].getName().toString().startsWith("$SwitchMap$")) {
                enumHelper = true;
            }
            if (!enumHelper) {
                hierarchy.append(parserKlass.getSuperKlass().toString()).append(";");
                for (Symbol<Symbol.Type> itf : parserKlass.getSuperInterfaces()) {
                    hierarchy.append(itf.toString()).append(";");
                }
                for (ParserMethod method : parserKlass.getMethods()) {
                    methods.append(method.getName().toString()).append(";");
                    methods.append(method.getSignature().toString()).append(";");
                }
                for (ParserField field : parserKlass.getFields()) {
                    fields.append(field.getType().toString()).append(";");
                    fields.append(field.getName().toString()).append(";");
                }
                ImmutableConstantPool pool = parserKlass.getConstantPool();
                EnclosingMethodAttribute attr = (EnclosingMethodAttribute)parserKlass.getAttribute(EnclosingMethodAttribute.NAME);
                NameAndTypeConstant nmt = pool.nameAndTypeAt(attr.getMethodIndex());
                enclosing.append(nmt.getName(pool)).append(";").append(nmt.getDescriptor(pool));
            }
        }
        return new HotSwapClassInfo(klass, name, definingLoader, hierarchy.toString(), methods.toString(), fields.toString(), enclosing.toString(), new ArrayList<HotSwapClassInfo>(1), bytes, enumHelper, isNewInnerTestKlass);
    }

    public static ImmutableClassInfo copyFrom(HotSwapClassInfo info) {
        ArrayList<ImmutableClassInfo> inners = new ArrayList<ImmutableClassInfo>();
        for (HotSwapClassInfo innerClass : info.getHotSwapInnerClasses()) {
            inners.add(ClassInfo.copyFrom(innerClass));
        }
        return new ImmutableClassInfo(info.getKlass(), info.getName(), info.getClassLoader(), info.finalClassFingerprint, info.finalMethodFingerprint, info.finalFieldFingerprint, info.finalEnclosingMethodFingerprint, inners, info.getBytes(), info.isEnumSwitchmapHelper(), info.isNewInnerTestKlass());
    }

    public abstract String getClassFingerprint();

    public abstract String getMethodFingerprint();

    public abstract String getFieldFingerprint();

    public abstract String getEnclosingMethodFingerprint();

    public abstract ArrayList<? extends ClassInfo> getInnerClasses();

    public abstract Symbol<Symbol.Name> getName();

    public abstract StaticObject getClassLoader();

    public abstract ObjectKlass getKlass();

    public abstract byte[] getBytes();

    public int match(ClassInfo other) {
        if (!this.getClassFingerprint().equals(other.getClassFingerprint())) {
            return 0;
        }
        if (this.isEnumSwitchmapHelper) {
            return 0;
        }
        int score = 0;
        score += this.getMethodFingerprint().equals(other.getMethodFingerprint()) ? 8 : 0;
        score += this.getEnclosingMethodFingerprint().equals(other.getEnclosingMethodFingerprint()) ? 4 : 0;
        score += this.getFieldFingerprint().equals(other.getFieldFingerprint()) ? 2 : 0;
        return score += this.getInnerClasses().size() == other.getInnerClasses().size() ? 1 : 0;
    }
}

