/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition;

import com.oracle.truffle.espresso.classfile.ParserField;
import com.oracle.truffle.espresso.classfile.ParserMethod;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DetectedChange {
    private final List<ParserField> addedStaticFields = new ArrayList<ParserField>();
    private final List<ParserField> addedInstanceFields = new ArrayList<ParserField>();
    private final List<Field> removedFields = new ArrayList<Field>();
    private final Map<Method, ParserMethod> changedMethodBodies = new HashMap<Method, ParserMethod>();
    private final List<ParserMethod> addedMethods = new ArrayList<ParserMethod>();
    private final Set<Method.MethodVersion> removedMethods = new HashSet<Method.MethodVersion>();
    private final Set<Method> unchangedMethods = new HashSet<Method>();
    private boolean classInitializerChanged;
    private Map<ParserField, Field> mappedCompatibleFields = new HashMap<ParserField, Field>();
    private ObjectKlass superKlass;
    private ObjectKlass[] superInterfaces;
    private boolean isChangedSuperClass;

    public void addNewField(ParserField parserField) {
        if (parserField.isStatic()) {
            this.addedStaticFields.add(parserField);
        } else {
            this.addedInstanceFields.add(parserField);
        }
    }

    public void addNewFields(ArrayList<ParserField> newFields) {
        for (ParserField newField : newFields) {
            this.addNewField(newField);
        }
    }

    public void addCompatibleFields(Map<ParserField, Field> compatibleFields) {
        this.mappedCompatibleFields = compatibleFields;
    }

    public Map<ParserField, Field> getMappedCompatibleFields() {
        return Collections.unmodifiableMap(this.mappedCompatibleFields);
    }

    public List<ParserField> getAddedStaticFields() {
        return Collections.unmodifiableList(this.addedStaticFields);
    }

    public List<ParserField> getAddedInstanceFields() {
        return Collections.unmodifiableList(this.addedInstanceFields);
    }

    public void addRemovedFields(ArrayList<Field> removed) {
        this.removedFields.addAll(removed);
    }

    public List<Field> getRemovedFields() {
        return Collections.unmodifiableList(this.removedFields);
    }

    void addMethodBodyChange(Method oldMethod, ParserMethod newMethod) {
        this.changedMethodBodies.put(oldMethod, newMethod);
        if (oldMethod.getName() == Symbol.Name._clinit_) {
            this.classInitializerChanged = true;
        }
    }

    public Map<Method, ParserMethod> getChangedMethodBodies() {
        return Collections.unmodifiableMap(this.changedMethodBodies);
    }

    public List<ParserMethod> getAddedMethods() {
        return Collections.unmodifiableList(this.addedMethods);
    }

    public Set<Method.MethodVersion> getRemovedMethods() {
        return Collections.unmodifiableSet(this.removedMethods);
    }

    public Set<Method> getUnchangedMethods() {
        return Collections.unmodifiableSet(this.unchangedMethods);
    }

    public void addNewMethod(ParserMethod method) {
        this.addedMethods.add(method);
    }

    public void addRemovedMethod(Method.MethodVersion method) {
        this.removedMethods.add(method);
    }

    public void addNewMethods(List<ParserMethod> newMethods) {
        this.addedMethods.addAll(newMethods);
    }

    public void addUnchangedMethod(Method method) {
        this.unchangedMethods.add(method);
    }

    public boolean clinitChanged() {
        return this.classInitializerChanged;
    }

    public ObjectKlass getSuperKlass() {
        return this.superKlass;
    }

    public ObjectKlass[] getSuperInterfaces() {
        return this.superInterfaces;
    }

    public void addSuperKlass(ObjectKlass klass) {
        this.superKlass = klass;
    }

    public void addSuperInterfaces(ObjectKlass[] interfaces) {
        this.superInterfaces = interfaces;
    }

    public void markChangedSuperClass() {
        this.isChangedSuperClass = true;
    }

    public boolean isChangedSuperClass() {
        return this.isChangedSuperClass;
    }
}

