/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition;

import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.redefinition.ClassInfo;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.ArrayList;
import java.util.Arrays;

public final class HotSwapClassInfo
extends ClassInfo {
    private ObjectKlass thisKlass;
    private byte[] bytes;
    private byte[] patchedBytes;
    private final StaticObject classLoader;
    private final Symbol<Symbol.Name> originalName;
    private Symbol<Symbol.Name> newName;
    private String classFingerprint;
    private String methodFingerprint;
    private String fieldFingerprint;
    private String enclosingMethodFingerprint;
    final String finalClassFingerprint;
    final String finalMethodFingerprint;
    final String finalFieldFingerprint;
    final String finalEnclosingMethodFingerprint;
    private final ArrayList<HotSwapClassInfo> innerClasses;
    private HotSwapClassInfo outerClassInfo;
    private int nextNewClass = 1;

    HotSwapClassInfo(ObjectKlass klass, Symbol<Symbol.Name> originalName, StaticObject classLoader, String classFingerprint, String methodFingerprint, String fieldFingerprint, String enclosingMethodFingerprint, ArrayList<HotSwapClassInfo> inners, byte[] bytes, boolean isEnumSwitchmapHelper, boolean isNewInnerTestKlass) {
        super(isEnumSwitchmapHelper, isNewInnerTestKlass);
        this.thisKlass = klass;
        this.originalName = originalName;
        this.classLoader = classLoader;
        this.classFingerprint = classFingerprint;
        this.methodFingerprint = methodFingerprint;
        this.fieldFingerprint = fieldFingerprint;
        this.enclosingMethodFingerprint = enclosingMethodFingerprint;
        this.innerClasses = inners;
        this.bytes = bytes;
        this.finalClassFingerprint = classFingerprint;
        this.finalMethodFingerprint = methodFingerprint;
        this.finalFieldFingerprint = fieldFingerprint;
        this.finalEnclosingMethodFingerprint = enclosingMethodFingerprint;
    }

    public static HotSwapClassInfo createForSuperClassChanged(ObjectKlass klass) {
        return new HotSwapClassInfo(klass, null, null, null, null, null, null, null, null, false, false);
    }

    @Override
    public ObjectKlass getKlass() {
        return this.thisKlass;
    }

    public void setKlass(ObjectKlass klass) {
        this.thisKlass = klass;
    }

    @Override
    public Symbol<Symbol.Name> getName() {
        return this.originalName;
    }

    public Symbol<Symbol.Name> getNewName() {
        return this.newName != null ? this.newName : this.originalName;
    }

    public void rename(Symbol<Symbol.Name> name) {
        this.newName = name;
    }

    public boolean isRenamed() {
        return this.newName != null && !this.newName.equals(this.originalName);
    }

    @Override
    public ArrayList<? extends ClassInfo> getInnerClasses() {
        return this.innerClasses;
    }

    public void addInnerClass(HotSwapClassInfo inner) {
        this.innerClasses.add(inner);
        inner.setOuterClass(this);
    }

    public boolean knowsInnerClass(Symbol<Symbol.Name> innerName) {
        for (ClassInfo classInfo : this.innerClasses) {
            if (!innerName.equals(classInfo.getName())) continue;
            return true;
        }
        return false;
    }

    private void setOuterClass(HotSwapClassInfo classInfo) {
        this.outerClassInfo = classInfo;
    }

    public HotSwapClassInfo getOuterClassInfo() {
        return this.outerClassInfo;
    }

    void outerRenamed(String oldName, String replacementName) {
        this.methodFingerprint = this.methodFingerprint != null ? this.methodFingerprint.replace(oldName, replacementName) : null;
        this.fieldFingerprint = this.fieldFingerprint != null ? this.fieldFingerprint.replace(oldName, replacementName) : null;
    }

    @Override
    public String getClassFingerprint() {
        return this.classFingerprint;
    }

    @Override
    public String getMethodFingerprint() {
        return this.methodFingerprint;
    }

    @Override
    public String getFieldFingerprint() {
        return this.fieldFingerprint;
    }

    @Override
    public String getEnclosingMethodFingerprint() {
        return this.enclosingMethodFingerprint;
    }

    @Override
    public StaticObject getClassLoader() {
        return this.classLoader;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public void patchBytes(byte[] patchBytes) {
        this.patchedBytes = patchBytes;
    }

    public boolean isPatched() {
        return this.patchedBytes != null && !Arrays.equals(this.patchedBytes, this.bytes);
    }

    public byte[] getPatchedBytes() {
        return this.patchedBytes;
    }

    public String addHotClassMarker() {
        return String.valueOf(this.getNewName()) + "$hot" + this.nextNewClass++;
    }

    public ArrayList<HotSwapClassInfo> getHotSwapInnerClasses() {
        return this.innerClasses;
    }
}

