/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition;

import com.oracle.truffle.espresso.classfile.ParserException;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.ConstantPoolPatcher;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jdwp.api.RedefineInfo;
import com.oracle.truffle.espresso.preinit.ParserKlassProvider;
import com.oracle.truffle.espresso.redefinition.ClassInfo;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import com.oracle.truffle.espresso.redefinition.DefineKlassListener;
import com.oracle.truffle.espresso.redefinition.HotSwapClassInfo;
import com.oracle.truffle.espresso.redefinition.ImmutableClassInfo;
import com.oracle.truffle.espresso.redefinition.RedefinitionNotSupportedException;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InnerClassRedefiner {
    public static final Pattern ANON_INNER_CLASS_PATTERN = Pattern.compile(".*\\$\\d+.*");
    public static final int METHOD_FINGERPRINT_EQUALS = 8;
    public static final int ENCLOSING_METHOD_FINGERPRINT_EQUALS = 4;
    public static final int FIELD_FINGERPRINT_EQUALS = 2;
    public static final int NUMBER_INNER_CLASSES = 1;
    public static final int MAX_SCORE = 15;
    public static final String HOT_CLASS_MARKER = "$hot";
    private final EspressoContext context;
    private final Map<StaticObject, Map<Symbol<Symbol.Name>, ImmutableClassInfo>> innerClassInfoMap = new WeakHashMap<StaticObject, Map<Symbol<Symbol.Name>, ImmutableClassInfo>>();
    private final Map<StaticObject, Map<Symbol<Symbol.Type>, Set<ObjectKlass>>> innerKlassCache = new WeakHashMap<StaticObject, Map<Symbol<Symbol.Type>, Set<ObjectKlass>>>();
    private final Map<Symbol<Symbol.Name>, HotSwapClassInfo> hotswapState = new HashMap<Symbol<Symbol.Name>, HotSwapClassInfo>();

    public InnerClassRedefiner(EspressoContext context) {
        this.context = context;
    }

    public HotSwapClassInfo[] matchAnonymousInnerClasses(List<RedefineInfo> redefineInfos, List<ObjectKlass> removedInnerClasses) throws RedefinitionNotSupportedException {
        this.hotswapState.clear();
        ArrayList<RedefineInfo> unhandled = new ArrayList<RedefineInfo>(redefineInfos);
        HashMap<Symbol<Symbol.Name>, HotSwapClassInfo> handled = new HashMap<Symbol<Symbol.Name>, HotSwapClassInfo>(redefineInfos.size());
        int handledSize = 0;
        int previousHandledSize = -1;
        while (!unhandled.isEmpty() && handledSize > previousHandledSize) {
            Iterator<RedefineInfo> it = unhandled.iterator();
            while (it.hasNext()) {
                RedefineInfo redefineInfo = it.next();
                Symbol<Symbol.Name> klassName = ParserKlassProvider.getClassName(this.context.getMeta(), this.context.getClassLoadingEnv().getParsingContext(), redefineInfo.getClassBytes());
                if (handled.containsKey(klassName)) {
                    ClassRedefinition.LOGGER.warning(() -> "Ignoring duplicate redefinition requests for name " + String.valueOf(klassName));
                    it.remove();
                    continue;
                }
                Matcher matcher = ANON_INNER_CLASS_PATTERN.matcher(klassName.toString());
                if (matcher.matches()) {
                    redefineInfo.clearKlass();
                    HotSwapClassInfo info = (HotSwapClassInfo)handled.get(this.getOuterClassName(klassName));
                    if (info == null) continue;
                    HotSwapClassInfo classInfo = ClassInfo.create(klassName, redefineInfo.getClassBytes(), info.getClassLoader(), this.context, redefineInfo.isInnerTestKlass());
                    info.addInnerClass(classInfo);
                    handled.put(klassName, classInfo);
                    it.remove();
                    continue;
                }
                it.remove();
                if (redefineInfo.getKlass() == null) continue;
                HotSwapClassInfo classInfo = ClassInfo.create(redefineInfo, this.context, redefineInfo.isInnerTestKlass());
                handled.put(klassName, classInfo);
                this.hotswapState.put(klassName, classInfo);
            }
            previousHandledSize = handledSize;
            handledSize = handled.size();
        }
        HashMap<StaticObject, Map<Symbol<Symbol.Name>, Symbol<Symbol.Name>>> renamingRules = new HashMap<StaticObject, Map<Symbol<Symbol.Name>, Symbol<Symbol.Name>>>(0);
        for (HotSwapClassInfo info : this.hotswapState.values()) {
            this.matchClassInfo(info, removedInnerClasses, renamingRules);
        }
        ArrayList<HotSwapClassInfo> result = new ArrayList<HotSwapClassInfo>();
        InnerClassRedefiner.collectAllHotswapClasses(this.hotswapState.values(), result);
        for (HotSwapClassInfo classInfo : result) {
            Map rules;
            if (classInfo.getBytes() == null || (rules = (Map)renamingRules.get(classInfo.getClassLoader())) == null || rules.isEmpty()) continue;
            try {
                classInfo.patchBytes(ConstantPoolPatcher.patchConstantPool(classInfo.getBytes(), rules, this.context));
            }
            catch (ParserException.ClassFormatError ex) {
                throw new RedefinitionNotSupportedException(60);
            }
        }
        this.hotswapState.clear();
        return result.toArray(new HotSwapClassInfo[0]);
    }

    private static void collectAllHotswapClasses(Collection<HotSwapClassInfo> infos, ArrayList<HotSwapClassInfo> result) {
        for (HotSwapClassInfo info : infos) {
            result.add(info);
            InnerClassRedefiner.collectAllHotswapClasses(info.getInnerClasses(), result);
        }
    }

    private void fetchMissingInnerClasses(HotSwapClassInfo hotswapInfo) throws RedefinitionNotSupportedException {
        StaticObject definingLoader = hotswapInfo.getClassLoader();
        HashSet<Symbol<Symbol.Name>> innerNames = new HashSet<Symbol<Symbol.Name>>(1);
        try {
            this.searchConstantPoolForDirectInnerAnonymousClassNames(hotswapInfo, innerNames);
        }
        catch (ParserException.ClassFormatError ex) {
            throw new RedefinitionNotSupportedException(60);
        }
        for (Symbol symbol : innerNames) {
            if (hotswapInfo.knowsInnerClass(symbol)) continue;
            byte[] classBytes = null;
            StaticObject resourceGuestString = this.context.getMeta().toGuestString(String.valueOf(symbol) + ".class");
            assert (this.context.getCurrentPlatformThread() != null);
            StaticObject inputStream = (StaticObject)this.context.getMeta().java_lang_ClassLoader_getResourceAsStream.invokeDirectVirtual(definingLoader, resourceGuestString);
            if (StaticObject.notNull(inputStream)) {
                classBytes = this.readAllBytes(inputStream);
            }
            if (classBytes == null) continue;
            hotswapInfo.addInnerClass(ClassInfo.create(symbol, classBytes, definingLoader, this.context, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] readAllBytes(StaticObject inputStream) {
        int readLen;
        byte[] buf = new byte[4096];
        StaticObject guestBuf = StaticObject.wrap(buf, this.context.getMeta());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((readLen = ((Integer)this.context.getMeta().java_io_InputStream_read.invokeDirectVirtual(inputStream, guestBuf, 0, buf.length)).intValue()) != -1) {
            byte[] bytes = (byte[])guestBuf.unwrap(this.context.getLanguage());
            outputStream.write(bytes, 0, readLen);
        }
        byte[] byArray = outputStream.toByteArray();
        outputStream.close();
        this.context.getMeta().java_io_InputStream_close.invokeDirectVirtual(inputStream);
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        byte[] byArray2 = new byte[]{};
                        this.context.getMeta().java_io_InputStream_close.invokeDirectVirtual(inputStream);
                        return byArray2;
                    }
                }
                catch (Throwable throwable3) {
                    this.context.getMeta().java_io_InputStream_close.invokeDirectVirtual(inputStream);
                    throw throwable3;
                }
            }
        }
    }

    private void searchConstantPoolForDirectInnerAnonymousClassNames(ClassInfo classInfo, Set<Symbol<Symbol.Name>> innerNames) throws ParserException.ClassFormatError {
        byte[] bytes = classInfo.getBytes();
        assert (bytes != null);
        ConstantPoolPatcher.getDirectInnerAnonymousClassNames(classInfo.getName(), bytes, innerNames, this.context);
    }

    private Symbol<Symbol.Name> getOuterClassName(Symbol<Symbol.Name> innerName) {
        String strName = innerName.toString();
        assert (strName.contains("$"));
        return this.context.getNames().getOrCreate(strName.substring(0, strName.lastIndexOf(36)));
    }

    private void matchClassInfo(HotSwapClassInfo hotSwapInfo, List<ObjectKlass> removedInnerClasses, Map<StaticObject, Map<Symbol<Symbol.Name>, Symbol<Symbol.Name>>> renamingRules) throws RedefinitionNotSupportedException {
        ObjectKlass klass = hotSwapInfo.getKlass();
        this.fetchMissingInnerClasses(hotSwapInfo);
        if (klass == null) {
            HotSwapClassInfo outerInfo = hotSwapInfo.getOuterClassInfo();
            String name = outerInfo.addHotClassMarker();
            hotSwapInfo.rename(this.context.getNames().getOrCreate(name));
            InnerClassRedefiner.addRenamingRule(renamingRules, hotSwapInfo.getClassLoader(), hotSwapInfo.getName(), hotSwapInfo.getNewName(), this.context);
        } else {
            ImmutableClassInfo previousInfo = this.getGlobalClassInfo(klass);
            ArrayList<ImmutableClassInfo> previousInnerClasses = previousInfo.getImmutableInnerClasses();
            ArrayList<HotSwapClassInfo> newInnerClasses = hotSwapInfo.getHotSwapInnerClasses();
            if (hotSwapInfo.isRenamed()) {
                for (HotSwapClassInfo newInnerClass : newInnerClasses) {
                    newInnerClass.outerRenamed(hotSwapInfo.getName().toString(), hotSwapInfo.getNewName().toString());
                }
            }
            if (previousInnerClasses.size() > 0 || newInnerClasses.size() > 0) {
                ArrayList<ImmutableClassInfo> removedClasses = new ArrayList<ImmutableClassInfo>(previousInnerClasses);
                for (HotSwapClassInfo info : newInnerClasses) {
                    ImmutableClassInfo bestMatch = null;
                    int maxScore = 0;
                    for (ImmutableClassInfo removedClass : removedClasses) {
                        int score = info.match(removedClass);
                        if (score <= 0 || score <= maxScore) continue;
                        maxScore = score;
                        bestMatch = removedClass;
                        if (maxScore != 15) continue;
                        break;
                    }
                    if (bestMatch == null) continue;
                    removedClasses.remove(bestMatch);
                    if (!info.getName().equals(bestMatch.getName())) {
                        info.rename(bestMatch.getName());
                        InnerClassRedefiner.addRenamingRule(renamingRules, info.getClassLoader(), info.getName(), info.getNewName(), this.context);
                    }
                    info.setKlass(bestMatch.getKlass());
                }
                for (ImmutableClassInfo removedClass : removedClasses) {
                    if (removedClass.getKlass() == null) continue;
                    removedInnerClasses.add(removedClass.getKlass());
                }
            }
        }
        for (HotSwapClassInfo innerClass : hotSwapInfo.getHotSwapInnerClasses()) {
            this.matchClassInfo(innerClass, removedInnerClasses, renamingRules);
        }
    }

    private static void addRenamingRule(Map<StaticObject, Map<Symbol<Symbol.Name>, Symbol<Symbol.Name>>> renamingRules, StaticObject classLoader, Symbol<Symbol.Name> originalName, Symbol<Symbol.Name> newName, EspressoContext context) {
        Map classLoaderRules = renamingRules.computeIfAbsent(classLoader, k -> new HashMap(4));
        ClassRedefinition.LOGGER.fine(() -> "Renaming inner class: " + String.valueOf(originalName) + " to: " + String.valueOf(newName));
        assert (classLoaderRules.getOrDefault(originalName, newName).equals(newName)) : "rules already contain " + String.valueOf(originalName) + " -> " + String.valueOf(classLoaderRules.get(originalName)) + ", cannot map to " + String.valueOf(newName);
        classLoaderRules.put(originalName, newName);
        Symbol<Symbol.Name> origTypeName = context.getNames().getOrCreate("L" + String.valueOf(originalName) + ";");
        Symbol<Symbol.Name> newTypeName = context.getNames().getOrCreate("L" + String.valueOf(newName) + ";");
        assert (classLoaderRules.getOrDefault(origTypeName, newTypeName).equals(newTypeName)) : "rules already contain " + String.valueOf(origTypeName) + " -> " + String.valueOf(classLoaderRules.get(origTypeName)) + ", cannot map to " + String.valueOf(newTypeName);
        classLoaderRules.put(origTypeName, newTypeName);
        Symbol<Symbol.Name> origSigName = context.getNames().getOrCreate("(L" + String.valueOf(originalName) + ";)V");
        Symbol<Symbol.Name> newSigName = context.getNames().getOrCreate("(L" + String.valueOf(newName) + ";)V");
        assert (classLoaderRules.getOrDefault(origSigName, newSigName).equals(newSigName)) : "rules already contain " + String.valueOf(origSigName) + " -> " + String.valueOf(classLoaderRules.get(origSigName)) + ", cannot map to " + String.valueOf(newSigName);
        classLoaderRules.put(origSigName, newSigName);
    }

    public ImmutableClassInfo getGlobalClassInfo(Klass klass) {
        ImmutableClassInfo result;
        StaticObject classLoader = klass.getDefiningClassLoader();
        Map<Symbol<Symbol.Name>, ImmutableClassInfo> infos = this.innerClassInfoMap.get(classLoader);
        if (infos == null) {
            infos = new HashMap<Symbol<Symbol.Name>, ImmutableClassInfo>(1);
            this.innerClassInfoMap.put(classLoader, infos);
        }
        if ((result = infos.get(klass.getName())) == null) {
            result = ClassInfo.create(klass, this);
            infos.put(klass.getName(), result);
        }
        return result;
    }

    Set<ObjectKlass> findLoadedInnerClasses(Klass klass) {
        HashSet innerClasses;
        Map<Symbol<Symbol.Type>, Set<ObjectKlass>> classLoaderMap = this.innerKlassCache.get(klass.getDefiningClassLoader());
        if (classLoaderMap == null) {
            classLoaderMap = new HashMap<Symbol<Symbol.Type>, Set<ObjectKlass>>();
            ClassRegistry classRegistry = this.context.getRegistries().getClassRegistry(klass.getDefiningClassLoader());
            classRegistry.registerOnLoadListener(new DefineKlassListener(){

                @Override
                public void onKlassDefined(ObjectKlass objectKlass) {
                    InnerClassRedefiner.this.onKlassDefined(objectKlass);
                }
            });
            List<Klass> loadedKlasses = classRegistry.getLoadedKlasses();
            for (Klass loadedKlass : loadedKlasses) {
                Symbol<Symbol.Name> outerClassName;
                if (!(loadedKlass instanceof ObjectKlass)) continue;
                ObjectKlass objectKlass = (ObjectKlass)loadedKlass;
                Matcher matcher = ANON_INNER_CLASS_PATTERN.matcher(loadedKlass.getNameAsString());
                if (!matcher.matches() || (outerClassName = this.getOuterClassName(loadedKlass.getName())) == null || outerClassName.length() <= 0) continue;
                Symbol<Symbol.Type> outerType = this.context.getTypes().fromName(outerClassName);
                Set<ObjectKlass> innerKlasses = classLoaderMap.get(outerType);
                if (innerKlasses == null) {
                    innerKlasses = new HashSet<ObjectKlass>(1);
                    classLoaderMap.put(outerType, innerKlasses);
                }
                innerKlasses.add(objectKlass);
            }
            this.innerKlassCache.put(klass.getDefiningClassLoader(), classLoaderMap);
        }
        return (innerClasses = classLoaderMap.get(klass.getType())) != null ? innerClasses : new HashSet(0);
    }

    private void onKlassDefined(ObjectKlass klass) {
        Matcher matcher = ANON_INNER_CLASS_PATTERN.matcher(klass.getNameAsString());
        if (matcher.matches()) {
            Map<Symbol<Symbol.Type>, Set<ObjectKlass>> classLoaderMap = this.innerKlassCache.get(klass.getDefiningClassLoader());
            Symbol<Symbol.Name> outerName = this.getOuterClassName(klass.getName());
            Symbol<Symbol.Type> outerType = this.context.getTypes().fromName(outerName);
            Set<ObjectKlass> innerKlasses = classLoaderMap.get(outerType);
            if (innerKlasses == null) {
                innerKlasses = new HashSet<ObjectKlass>(1);
                classLoaderMap.put(outerType, innerKlasses);
            }
            innerKlasses.add(klass);
        }
    }

    public void commit(HotSwapClassInfo[] infos) {
        Map<Symbol<Symbol.Name>, ImmutableClassInfo> classLoaderMap;
        StaticObject classLoader;
        for (HotSwapClassInfo info : infos) {
            classLoader = info.getClassLoader();
            classLoaderMap = this.innerClassInfoMap.get(classLoader);
            if (classLoaderMap == null) continue;
            classLoaderMap.remove(info.getNewName());
        }
        for (HotSwapClassInfo hotSwapInfo : infos) {
            classLoader = hotSwapInfo.getClassLoader();
            classLoaderMap = this.innerClassInfoMap.get(classLoader);
            if (classLoaderMap == null) {
                classLoaderMap = new HashMap<Symbol<Symbol.Name>, ImmutableClassInfo>(1);
                this.innerClassInfoMap.put(classLoader, classLoaderMap);
            }
            classLoaderMap.put(hotSwapInfo.getName(), ClassInfo.copyFrom(hotSwapInfo));
        }
    }
}

