/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition.plugins.enums;

import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jdwp.api.MethodHook;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.MethodVariable;
import com.oracle.truffle.espresso.redefinition.plugins.api.InternalRedefinitionPlugin;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class EnumRedefinitionPlugin
extends InternalRedefinitionPlugin {
    private ArrayList<ObjectKlass> enumClassesToRerun = new ArrayList(4);

    @Override
    public boolean shouldRerunClassInitializer(ObjectKlass klass, boolean changed) {
        if (changed && this.getContext().getMeta().java_lang_Enum.isAssignable(klass)) {
            this.enumClassesToRerun.add(klass);
        }
        return false;
    }

    @Override
    public void postClassRedefinition(ObjectKlass[] changedKlasses) {
        for (final ObjectKlass objectKlass : this.enumClassesToRerun) {
            HashMap<Method, 1> hooks = new HashMap<Method, 1>(2);
            for (final Method method : objectKlass.getDeclaredMethods()) {
                if (!method.isConstructor()) continue;
                MethodHook hook = new MethodHook(){
                    final /* synthetic */ EnumRedefinitionPlugin this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public MethodHook.Kind getKind() {
                        return MethodHook.Kind.INDEFINITE;
                    }

                    @Override
                    public boolean onMethodEnter(MethodRef methodRef, MethodVariable[] variables) {
                        MethodVariable nameVar = variables[1];
                        String enumName = objectKlass.getMeta().toHostString((StaticObject)nameVar.getValue());
                        Symbol<Symbol.Name> name = objectKlass.getContext().getNames().getOrCreate(enumName);
                        Field field = objectKlass.lookupField(name, objectKlass.getType());
                        StaticObject existingEnumConstant = field.getObject(objectKlass.getStatics());
                        if (StaticObject.notNull(existingEnumConstant)) {
                            Object[] args = new Object[variables.length];
                            args[0] = existingEnumConstant;
                            for (int i = 1; i < variables.length; ++i) {
                                args[i] = variables[i].getValue();
                            }
                            method.removeActiveHook(this);
                            method.invokeDirectSpecial(args);
                            method.addMethodHook(this);
                        }
                        return false;
                    }

                    @Override
                    public boolean onMethodExit(MethodRef m, Object returnValue) {
                        return false;
                    }
                };
                hooks.put(method, hook);
                method.addMethodHook(hook);
            }
            objectKlass.reRunClinit();
            for (Map.Entry entry : hooks.entrySet()) {
                Method method = (Method)entry.getKey();
                MethodHook hook = (MethodHook)entry.getValue();
                method.removeActiveHook(hook);
            }
        }
        for (ObjectKlass changedKlass : changedKlasses) {
            for (Field declaredField : changedKlass.getDeclaredFields()) {
                if (!declaredField.getNameAsString().startsWith("$SWITCH_TABLE$")) continue;
                declaredField.set(changedKlass.getStatics(), StaticObject.NULL);
            }
        }
        this.enumClassesToRerun.clear();
    }
}

