/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition.plugins.impl;

import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

final class ExternalPluginHandler {
    private static final String RERUN_CLINIT = "shouldRerunClassInitializer";
    private static final String POST_HOTSWAP = "postHotSwap";
    private final InteropLibrary interopLibrary;
    private final StaticObject guestHandler;

    private ExternalPluginHandler(StaticObject handler, InteropLibrary library) {
        this.guestHandler = handler;
        this.interopLibrary = library;
    }

    public static ExternalPluginHandler create(StaticObject guestHandler) throws IllegalArgumentException {
        boolean invocable;
        InteropLibrary library = InteropLibrary.getUncached((Object)guestHandler);
        boolean bl = invocable = library.isMemberInvocable((Object)guestHandler, RERUN_CLINIT) && library.isMemberInvocable((Object)guestHandler, POST_HOTSWAP);
        if (!invocable) {
            throw new IllegalArgumentException("guest handler does not implement expected API");
        }
        return new ExternalPluginHandler(guestHandler, library);
    }

    public boolean shouldRerunClassInitializer(Klass klass, boolean changed) {
        try {
            return (Boolean)this.interopLibrary.invokeMember((Object)this.guestHandler, RERUN_CLINIT, new Object[]{klass.mirror(), changed});
        }
        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            klass.getContext().getLogger().severe(() -> ExternalPluginHandler.lambda$shouldRerunClassInitializer$0((InteropException)e));
            return false;
        }
    }

    public void postHotSwap(Klass[] changedKlasses) {
        Meta meta = changedKlasses[0].getMeta();
        try {
            StaticObject[] guestClasses = new StaticObject[changedKlasses.length];
            for (int i = 0; i < guestClasses.length; ++i) {
                guestClasses[i] = changedKlasses[i].mirror();
            }
            StaticObject array = StaticObject.createArray(meta.java_lang_Class_array, guestClasses, meta.getContext());
            this.interopLibrary.invokeMember((Object)this.guestHandler, POST_HOTSWAP, new Object[]{array});
        }
        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            ClassRedefinition.LOGGER.severe(() -> ExternalPluginHandler.lambda$postHotSwap$0((InteropException)e));
        }
    }

    private static /* synthetic */ String lambda$postHotSwap$0(InteropException e) {
        return ExternalPluginHandler.class.getName() + ": postHotSwap: " + e.getMessage();
    }

    private static /* synthetic */ String lambda$shouldRerunClassInitializer$0(InteropException e) {
        return ExternalPluginHandler.class.getName() + ": shouldRerunClassInitializer: " + e.getMessage();
    }
}

