/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ref;

import com.oracle.truffle.espresso.ref.EspressoPhantomReference;
import com.oracle.truffle.espresso.ref.EspressoSoftReference;
import com.oracle.truffle.espresso.ref.EspressoWeakReference;
import com.oracle.truffle.espresso.ref.FinalizationSupport;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public interface EspressoReference {
    public @JavaType(value=Reference.class) StaticObject getGuestReference();

    public StaticObject get();

    public void clear();

    public static EspressoReference createWeak(EspressoContext context, @JavaType(value=WeakReference.class) StaticObject guestReference, @JavaType(value=Object.class) StaticObject referent) {
        return new EspressoWeakReference(guestReference, referent, context.getReferenceQueue());
    }

    public static EspressoReference createSoft(EspressoContext context, @JavaType(value=SoftReference.class) StaticObject guestReference, @JavaType(value=Object.class) StaticObject referent) {
        return new EspressoSoftReference(guestReference, referent, context.getReferenceQueue());
    }

    public static EspressoReference createPhantom(EspressoContext context, @JavaType(value=PhantomReference.class) StaticObject guestReference, @JavaType(value=Object.class) StaticObject referent) {
        return new EspressoPhantomReference(guestReference, referent, context.getReferenceQueue());
    }

    public static EspressoReference createFinal(EspressoContext context, @JavaType(internalName="Ljava/lang/ref/FinalReference;") StaticObject guestReference, @JavaType(value=Object.class) StaticObject referent) {
        if (!context.getEspressoEnv().UseHostFinalReference) {
            return EspressoReference.createWeak(context, guestReference, referent);
        }
        return FinalizationSupport.createEspressoFinalReference(context, guestReference, referent);
    }
}

