/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.resolver;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.meta.EspressoError;

public enum CallSiteType {
    Static,
    Special,
    Virtual,
    Interface;


    public static CallSiteType fromOpCode(int opcode) {
        switch (opcode) {
            case 184: {
                return Static;
            }
            case 183: {
                return Special;
            }
            case 182: {
                return Virtual;
            }
            case 185: {
                return Interface;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere(Bytecodes.nameOf(opcode));
    }

    public static CallSiteType fromRefKind(int refKind) {
        switch (refKind) {
            case 5: {
                return Virtual;
            }
            case 6: {
                return Static;
            }
            case 7: 
            case 8: {
                return Special;
            }
            case 9: {
                return Interface;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("refKind: " + refKind);
    }
}

