/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.resolver;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.meta.EspressoError;

public enum FieldAccessType {
    GetStatic(true, false),
    PutStatic(true, true),
    GetInstance(false, false),
    PutInstance(false, true);

    private final boolean isStatic;
    private final boolean isPut;

    private FieldAccessType(boolean isStatic, boolean isPut) {
        this.isStatic = isStatic;
        this.isPut = isPut;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isPut() {
        return this.isPut;
    }

    public static FieldAccessType fromOpCode(int opcode) {
        switch (opcode) {
            case 178: {
                return GetStatic;
            }
            case 179: {
                return PutStatic;
            }
            case 180: {
                return GetInstance;
            }
            case 181: {
                return PutInstance;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere(Bytecodes.nameOf(opcode));
    }

    public static FieldAccessType fromRefKind(int refKind) {
        switch (refKind) {
            case 1: {
                return GetInstance;
            }
            case 2: {
                return GetStatic;
            }
            case 3: {
                return PutInstance;
            }
            case 4: {
                return PutStatic;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("refkind: " + refKind);
    }
}

