/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.resolver;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.constantpool.Resolution;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.resolver.CallKind;
import com.oracle.truffle.espresso.resolver.CallSiteType;
import com.oracle.truffle.espresso.resolver.FieldAccessType;
import com.oracle.truffle.espresso.resolver.ResolvedCall;
import java.util.Locale;

final class LinkResolverImpl {
    private static final String AN_INTERFACE = "an interface";
    private static final String A_CLASS = "a class";
    private static final String STATIC = "static";
    private static final String NON_STATIC = "non-static";
    private static final String INIT = "<init>";
    private static final String CLINIT = "<clinit>";

    LinkResolverImpl() {
    }

    @CompilerDirectives.TruffleBoundary
    public static Field resolveFieldSymbol(Meta meta, ObjectKlass accessingKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, Klass symbolicHolder, boolean accessCheck, boolean loadingConstraints) {
        Field f = symbolicHolder.lookupField(name, type);
        if (f == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchFieldError, name.toString());
        }
        if (accessCheck) {
            Resolution.memberDoAccessCheck(accessingKlass, symbolicHolder, f, meta);
        }
        if (loadingConstraints) {
            f.checkLoadingConstraints(accessingKlass.getDefiningClassLoader(), f.getDeclaringKlass().getDefiningClassLoader());
        }
        return f;
    }

    public static Field resolveFieldAccess(Meta meta, Field field, FieldAccessType fieldAccessType, Klass currentKlass, Method currentMethod) {
        if (fieldAccessType.isStatic() != field.isStatic()) {
            throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_IncompatibleClassChangeError, "Expected %s field %s.%s", fieldAccessType.isStatic() ? STATIC : NON_STATIC, field.getDeclaringKlass().getName(), field.getName());
        }
        if (fieldAccessType.isPut() && field.isFinalFlagSet()) {
            boolean enforceInitializerCheck;
            if (field.getDeclaringKlass() != currentKlass) {
                throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_IllegalAccessError, "Update to %s final field %s.%s attempted from a different class (%s) than the field's declaring class", fieldAccessType.isStatic() ? STATIC : NON_STATIC, field.getDeclaringKlass().getName(), field.getName(), currentKlass.getName());
            }
            boolean bl = enforceInitializerCheck = meta.getLanguage().getSpecComplianceMode() == EspressoOptions.SpecComplianceMode.STRICT || field.getDeclaringKlass().getMajorVersion() >= 53;
            if (!(!enforceInitializerCheck || fieldAccessType.isStatic() && currentMethod.isClassInitializer() || !fieldAccessType.isStatic() && currentMethod.isConstructor())) {
                throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_IllegalAccessError, "Update to %s final field %s.%s attempted from a different method (%s) than the initializer method %s ", fieldAccessType.isStatic() ? STATIC : NON_STATIC, field.getDeclaringKlass().getName(), field.getName(), currentMethod.getName(), fieldAccessType.isStatic() ? CLINIT : INIT);
            }
        }
        return field;
    }

    @CompilerDirectives.TruffleBoundary
    public static Method resolveMethodSymbol(Meta meta, ObjectKlass accessingKlass, Symbol<Symbol.Name> name, Symbol<Symbol.Signature> signature, Klass symbolicHolder, boolean interfaceLookup, boolean accessCheck, boolean loadingConstraints) {
        Method resolved;
        if (interfaceLookup != symbolicHolder.isInterface()) {
            String expected = interfaceLookup ? AN_INTERFACE : A_CLASS;
            String found = interfaceLookup ? A_CLASS : AN_INTERFACE;
            meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, EspressoError.cat("Resolution failure for ", symbolicHolder.getExternalName(), ".\n", "Is ", found, ", but ", expected, " was expected."));
        }
        if ((resolved = symbolicHolder.isInterface() ? ((ObjectKlass)symbolicHolder).resolveInterfaceMethod(name, signature) : symbolicHolder.lookupMethod(name, signature)) == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchMethodError, symbolicHolder.getNameAsString() + "." + String.valueOf(name) + String.valueOf(signature));
        }
        if (accessCheck) {
            Resolution.memberDoAccessCheck(accessingKlass, symbolicHolder, resolved, meta);
        }
        if (loadingConstraints && !resolved.isPolySignatureIntrinsic()) {
            resolved.checkLoadingConstraints(accessingKlass.getDefiningClassLoader(), resolved.getDeclaringKlass().getDefiningClassLoader());
        }
        return resolved;
    }

    public static ResolvedCall resolveCallSite(Meta meta, Klass currentKlass, Method symbolicResolution, CallSiteType callSiteType, Klass symbolicHolder) {
        Method resolved = symbolicResolution;
        return new ResolvedCall(switch (callSiteType) {
            case CallSiteType.Static -> {
                if (!resolved.isStatic()) {
                    throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_IncompatibleClassChangeError, "Expected static method '%s.%s%s'", resolved.getDeclaringKlass().getName(), resolved.getName(), resolved.getRawSignature());
                }
                yield CallKind.STATIC;
            }
            case CallSiteType.Interface -> {
                if (resolved.isStatic() || meta.getJavaVersion().java8OrEarlier() && resolved.isPrivate()) {
                    throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_IncompatibleClassChangeError, "Expected instance not static method '%s.%s%s'", resolved.getDeclaringKlass().getName(), resolved.getName(), resolved.getRawSignature());
                }
                if (resolved.getITableIndex() < 0) {
                    if (resolved.isPrivate()) {
                        if (!$assertionsDisabled && !meta.getJavaVersion().java9OrLater()) {
                            throw new AssertionError();
                        }
                        yield CallKind.DIRECT;
                    }
                    if (!$assertionsDisabled && resolved.getVTableIndex() < 0) {
                        throw new AssertionError();
                    }
                    yield CallKind.VTABLE_LOOKUP;
                }
                yield CallKind.ITABLE_LOOKUP;
            }
            case CallSiteType.Virtual -> {
                if (resolved.isStatic()) {
                    throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_IncompatibleClassChangeError, "Expected instance method '%s.%s%s'", resolved.getDeclaringKlass().getName(), resolved.getName(), resolved.getRawSignature());
                }
                if (resolved.isFinalFlagSet() || resolved.getDeclaringKlass().isFinalFlagSet() || resolved.isPrivate()) {
                    yield CallKind.DIRECT;
                }
                yield CallKind.VTABLE_LOOKUP;
            }
            case CallSiteType.Special -> {
                if (resolved.isConstructor() && resolved.getDeclaringKlass().getName() != symbolicHolder.getName()) {
                    throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_NoSuchMethodError, "%s.%s%s", resolved.getDeclaringKlass().getName(), resolved.getName(), resolved.getRawSignature());
                }
                if (resolved.isStatic()) {
                    throw LinkResolverImpl.throwBoundary(meta, meta.java_lang_IncompatibleClassChangeError, "Expected instance not static method '%s.%s%s'", resolved.getDeclaringKlass().getName(), resolved.getName(), resolved.getRawSignature());
                }
                if (!resolved.isConstructor() && !symbolicHolder.isInterface() && symbolicHolder != currentKlass && currentKlass.getSuperKlass() != null && symbolicHolder != currentKlass.getSuperKlass() && symbolicHolder.isAssignableFrom(currentKlass)) {
                    resolved = currentKlass.getSuperKlass().lookupMethod(resolved.getName(), resolved.getRawSignature(), Klass.LookupMode.INSTANCE_ONLY);
                }
                yield CallKind.DIRECT;
            }
            default -> {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.unimplemented("Resolution for " + String.valueOf((Object)callSiteType));
            }
        }, resolved);
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException throwBoundary(Meta meta, ObjectKlass exceptionKlass, String messageFormat, Object ... args) {
        throw meta.throwExceptionWithMessage(exceptionKlass, String.format(Locale.ENGLISH, messageFormat, args));
    }
}

