/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.resolver;

import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.resolver.CallKind;
import java.util.Objects;

public final class ResolvedCall {
    private final CallKind callKind;
    private final Method resolved;

    public ResolvedCall(CallKind callKind, Method resolved) {
        this.callKind = Objects.requireNonNull(callKind);
        this.resolved = Objects.requireNonNull(resolved);
    }

    public Object call(Object ... args) {
        return switch (this.callKind) {
            default -> throw new IncompatibleClassChangeError();
            case CallKind.STATIC -> this.resolved.invokeDirectStatic(args);
            case CallKind.DIRECT -> this.resolved.invokeDirect(args);
            case CallKind.VTABLE_LOOKUP -> this.resolved.invokeDirectVirtual(args);
            case CallKind.ITABLE_LOOKUP -> this.resolved.invokeDirectInterface(args);
        };
    }

    public Method getResolvedMethod() {
        return this.resolved;
    }

    public CallKind getCallKind() {
        return this.callKind;
    }
}

