/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.jni.RawBuffer;
import com.oracle.truffle.espresso.jvmti.JvmtiPhase;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graalvm.options.OptionMap;

final class AgentLibraries
extends ContextAccessImpl {
    private static final String AGENT_ONLOAD = "Agent_OnLoad";
    private static final NativeSignature ONLOAD_SIGNATURE = NativeSignature.create(NativeType.INT, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER);
    private final List<AgentLibrary> agents = new ArrayList<AgentLibrary>(0);
    private final InteropLibrary interop = InteropLibrary.getUncached();

    AgentLibraries(EspressoContext context) {
        super(context);
    }

    TruffleObject lookupSymbol(String mangledName) {
        for (AgentLibrary agent : this.agents) {
            TruffleObject symbol = this.getNativeAccess().lookupSymbol(agent.lib, mangledName);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    boolean isEmpty() {
        return this.agents.isEmpty();
    }

    void initialize() {
        this.getVM().getJvmti().enterPhase(JvmtiPhase.ONLOAD);
        for (AgentLibrary agent : this.agents) {
            TruffleObject onLoad = this.lookupOnLoad(agent);
            if (onLoad == null) {
                throw this.getContext().abort("Unable to locate Agent_OnLoad in agent " + agent.name);
            }
            try {
                RawBuffer optionBuffer = RawBuffer.getNativeString(agent.options);
                try {
                    Object ret = this.interop.execute((Object)onLoad, new Object[]{this.getContext().getVM().getJavaVM(), optionBuffer.pointer(), RawPointer.nullInstance()});
                    assert (this.interop.fitsInInt(ret));
                    if (this.interop.asInt(ret) == 0) continue;
                    throw this.getContext().abort("Agent_OnLoad call for agent " + agent.name + " returned with error: " + this.interop.asInt(ret));
                }
                finally {
                    if (optionBuffer == null) continue;
                    optionBuffer.close();
                }
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
        this.getVM().getJvmti().enterPhase(JvmtiPhase.PRIMORDIAL);
    }

    void registerAgents(OptionMap<String> map, boolean isAbsolutePath) {
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.registerAgent(name, value, isAbsolutePath);
        }
    }

    void registerAgent(String name, String value, boolean isAbsolutePath) {
        this.agents.add(new AgentLibrary(name, value, isAbsolutePath));
    }

    private TruffleObject lookupOnLoad(AgentLibrary agent) {
        TruffleObject library;
        if (agent.isAbsolutePath) {
            library = this.getNativeAccess().loadLibrary(Paths.get(agent.name, new String[0]));
        } else {
            library = this.getNativeAccess().loadLibrary(this.getContext().getVmProperties().bootLibraryPath(), agent.name, false);
            if (library == null) {
                library = this.getNativeAccess().loadLibrary(this.getContext().getVmProperties().javaLibraryPath(), agent.name, false);
            }
        }
        if (library == null) {
            throw this.getContext().abort("Could not locate library for agent " + agent.name);
        }
        agent.lib = library;
        return this.getNativeAccess().lookupAndBindSymbol(library, AGENT_ONLOAD, ONLOAD_SIGNATURE, true, true);
    }

    private static class AgentLibrary {
        final String name;
        final String options;
        final boolean isAbsolutePath;
        TruffleObject lib;

        AgentLibrary(String name, String options, boolean isAbsolutePath) {
            this.name = name;
            this.options = options;
            this.isAbsolutePath = isAbsolutePath;
        }
    }
}

