/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.classfile.ClasspathEntry;
import com.oracle.truffle.espresso.classfile.ClasspathFile;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.JImageHelper;
import com.oracle.truffle.espresso.substitutions.JImageExtensions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Classpath {
    public static final String JAVA_BASE = "java.base";
    private static final byte[] CLASS_SUFFIX = ".class".getBytes(StandardCharsets.UTF_8);
    private final List<ClasspathEntry> entries;

    public static ClasspathEntry createEntry(String name) {
        File pathFile = new File(name);
        if (pathFile.isDirectory()) {
            return new Directory(pathFile);
        }
        if (pathFile.isFile()) {
            JImageHelper helper;
            EspressoContext context = EspressoContext.get(null);
            if (context.getJavaVersion().modulesEnabled() && (helper = context.createJImageHelper(name)) != null) {
                return new Modules(pathFile, helper, context.getLanguage().getJImageExtensions());
            }
            try {
                ZipFile zipFile = new ZipFile(pathFile);
                return new Archive(pathFile, zipFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new PlainFile(pathFile);
    }

    public List<ClasspathEntry> entries() {
        return this.entries;
    }

    public Classpath(String[] paths) {
        ClasspathEntry[] entryArray = new ClasspathEntry[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            entryArray[i] = Classpath.createEntry(path);
        }
        this.entries = Arrays.asList(entryArray);
    }

    public Classpath(List<ClasspathEntry> entries) {
        this.entries = entries;
    }

    public Classpath(String paths) {
        this(paths.split(File.pathSeparator));
    }

    public Classpath prepend(ClasspathEntry entry) {
        ArrayList<ClasspathEntry> newEntries = new ArrayList<ClasspathEntry>(this.entries.size());
        newEntries.add(entry);
        newEntries.addAll(this.entries);
        return new Classpath(newEntries);
    }

    public ClasspathFile readClassFile(Symbol<Symbol.Type> type) {
        byte[] archiveNameBytes = new byte[type.length() - 2 + CLASS_SUFFIX.length];
        for (int i = 1; i < type.length() - 1; ++i) {
            byte b = type.byteAt(i);
            archiveNameBytes[i - 1] = b == 46 ? 47 : b;
        }
        System.arraycopy(CLASS_SUFFIX, 0, archiveNameBytes, type.length() - 2, CLASS_SUFFIX.length);
        ByteSequence archiveName = ByteSequence.wrap(archiveNameBytes);
        for (ClasspathEntry entry : this.entries()) {
            ClasspathFile classpathFile = entry.readFile(archiveName);
            if (classpathFile == null) continue;
            return classpathFile;
        }
        return null;
    }

    public static byte[] readZipEntry(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        byte[] bytes = new byte[(int)zipEntry.getSize()];
        try (BufferedInputStream zipStream = new BufferedInputStream(zipFile.getInputStream(zipEntry), bytes.length);){
            int n;
            for (int offset = 0; offset < bytes.length; offset += n) {
                n = ((InputStream)zipStream).read(bytes, offset, bytes.length - offset);
                if (n > 0) continue;
                throw EspressoError.shouldNotReachHere();
            }
        }
        return bytes;
    }

    public String toString() {
        if (this.entries == null || this.entries.isEmpty()) {
            return "";
        }
        String s = this.entries.toString().replace(", ", File.pathSeparator);
        return s.substring(1, s.length() - 1);
    }

    public static final class Directory
    extends ClasspathEntry {
        private static final boolean REPLACE_SEPARATOR = File.separatorChar != '/';
        private final File directory;

        public Directory(File directory) {
            this.directory = directory.getAbsoluteFile();
        }

        @Override
        public ClasspathFile readFile(ByteSequence archiveName) {
            File file;
            String fsPath = archiveName.toString();
            if (REPLACE_SEPARATOR) {
                fsPath = fsPath.replace('/', File.separatorChar);
            }
            if ((file = new File(this.directory, fsPath)).exists()) {
                try {
                    return new ClasspathFile(Files.readAllBytes(file.toPath()), this, archiveName);
                }
                catch (IOException ioException) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public File file() {
            return this.directory;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    }

    static final class Modules
    extends ClasspathEntry {
        private final File file;
        private final JImageHelper helper;
        private final JImageExtensions extensions;

        Modules(File file, JImageHelper helper, JImageExtensions extensions) {
            this.file = file;
            this.helper = helper;
            this.extensions = extensions;
        }

        @Override
        public File file() {
            return this.file;
        }

        @Override
        public ClasspathFile readFile(ByteSequence archiveName) {
            byte[] classBytes = null;
            if (this.extensions != null) {
                classBytes = this.extensions.getClassBytes(archiveName);
            }
            if (classBytes == null) {
                classBytes = this.helper.getClassBytes(archiveName);
            }
            if (classBytes == null) {
                return null;
            }
            return new ClasspathFile(classBytes, this, archiveName);
        }
    }

    static final class Archive
    extends ClasspathEntry {
        private final File file;
        private final ZipFile zipFile;

        Archive(File file, ZipFile zipFile) {
            this.file = file;
            this.zipFile = zipFile;
        }

        @Override
        public ClasspathFile readFile(ByteSequence archiveName) {
            try {
                ZipEntry zipEntry = this.zipFile.getEntry(archiveName.toString());
                if (zipEntry != null) {
                    return new ClasspathFile(Classpath.readZipEntry(this.zipFile, zipEntry), this, archiveName);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public File file() {
            return this.file;
        }

        @Override
        public boolean isArchive() {
            return true;
        }
    }

    static final class PlainFile
    extends ClasspathEntry {
        private final File file;

        PlainFile(File file) {
            this.file = file;
        }

        @Override
        public ClasspathFile readFile(ByteSequence archiveName) {
            return null;
        }

        @Override
        public File file() {
            return this.file;
        }
    }
}

