/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jdwp.api.CallFrame;
import com.oracle.truffle.espresso.jdwp.api.FieldRef;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.ModuleRef;
import com.oracle.truffle.espresso.jdwp.api.MonitorStackInfo;
import com.oracle.truffle.espresso.jdwp.api.RedefineInfo;
import com.oracle.truffle.espresso.jdwp.api.TagConstants;
import com.oracle.truffle.espresso.jdwp.api.VMEventListenerImpl;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BciProvider;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNode;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.redefinition.ChangePacket;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import com.oracle.truffle.espresso.redefinition.HotSwapClassInfo;
import com.oracle.truffle.espresso.redefinition.InnerClassRedefiner;
import com.oracle.truffle.espresso.redefinition.RedefinitionNotSupportedException;
import com.oracle.truffle.espresso.redefinition.plugins.impl.RedefinitionPluginHandler;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;

public final class JDWPContextImpl
implements JDWPContext {
    public static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", JDWPContextImpl.class);
    private static final InteropLibrary UNCACHED = InteropLibrary.getUncached();
    private static final long SUSPEND_TIMEOUT = 100L;
    private final EspressoContext context;
    private final Ids<Object> ids;
    private ClassRedefinition classRedefinition;
    private final InnerClassRedefiner innerClassRedefiner;
    private RedefinitionPluginHandler redefinitionPluginHandler;
    private final ArrayList<ReloadingAction> classInitializerActions = new ArrayList(1);
    private DebuggerController controller;
    private VMEventListenerImpl vmEventListener;

    public JDWPContextImpl(EspressoContext context) {
        this.context = context;
        this.ids = new Ids<StaticObject>(StaticObject.NULL);
        this.innerClassRedefiner = new InnerClassRedefiner(context);
    }

    public void jdwpInit(TruffleLanguage.Env env, Object mainThread, VMEventListenerImpl eventListener) {
        Debugger debugger = (Debugger)env.lookup((InstrumentInfo)env.getInstruments().get("debugger"), Debugger.class);
        this.controller = (DebuggerController)env.lookup((InstrumentInfo)env.getInstruments().get("jdwp"), DebuggerController.class);
        this.vmEventListener = eventListener;
        eventListener.activate(mainThread, this.controller, this);
        this.controller.initialize(debugger, this.context.getEspressoEnv().JDWPOptions, this, mainThread, eventListener);
        this.redefinitionPluginHandler = RedefinitionPluginHandler.create(this.context);
        this.classRedefinition = this.context.createClassRedefinition(this.ids, this.redefinitionPluginHandler);
    }

    public void finalizeContext() {
        if (this.context.getEspressoEnv().JDWPOptions != null && this.controller != null) {
            this.controller.disposeDebugger(false);
        }
    }

    @Override
    public void replaceController(DebuggerController newController) {
        this.controller = newController;
        this.vmEventListener.replaceController(newController);
    }

    @Override
    public Ids<Object> getIds() {
        return this.ids;
    }

    @Override
    public boolean isString(Object string) {
        return Meta.isString(string);
    }

    @Override
    public boolean isValidThread(Object thread, boolean checkTerminated) {
        StaticObject staticObject;
        if (thread instanceof StaticObject && this.context.getMeta().java_lang_Thread.isAssignableFrom((staticObject = (StaticObject)thread).getKlass())) {
            if (checkTerminated) {
                return this.getThreadStatus(thread) != State.TERMINATED.value;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidThreadGroup(Object threadGroup) {
        if (threadGroup instanceof StaticObject) {
            StaticObject staticObject = (StaticObject)threadGroup;
            return this.context.getMeta().java_lang_ThreadGroup.isAssignableFrom(staticObject.getKlass());
        }
        return false;
    }

    @Override
    public Object getNullObject() {
        return StaticObject.NULL;
    }

    @Override
    public KlassRef[] findLoadedClass(String slashName) {
        if (slashName.length() == 1) {
            switch (slashName) {
                case "I": {
                    return new KlassRef[]{this.context.getMeta()._int};
                }
                case "Z": {
                    return new KlassRef[]{this.context.getMeta()._boolean};
                }
                case "S": {
                    return new KlassRef[]{this.context.getMeta()._short};
                }
                case "C": {
                    return new KlassRef[]{this.context.getMeta()._char};
                }
                case "B": {
                    return new KlassRef[]{this.context.getMeta()._byte};
                }
                case "J": {
                    return new KlassRef[]{this.context.getMeta()._long};
                }
                case "D": {
                    return new KlassRef[]{this.context.getMeta()._double};
                }
                case "F": {
                    return new KlassRef[]{this.context.getMeta()._float};
                }
            }
            throw new IllegalStateException("invalid primitive component type " + slashName);
        }
        if (slashName.startsWith("[")) {
            int dimensions = 0;
            for (char c : slashName.toCharArray()) {
                if ('[' != c) break;
                ++dimensions;
            }
            String componentRawName = slashName.substring(dimensions);
            if (componentRawName.length() == 1) {
                switch (componentRawName) {
                    case "I": {
                        return new KlassRef[]{this.context.getMeta()._int.getArrayClass(dimensions)};
                    }
                    case "Z": {
                        return new KlassRef[]{this.context.getMeta()._boolean.getArrayClass(dimensions)};
                    }
                    case "S": {
                        return new KlassRef[]{this.context.getMeta()._short.getArrayClass(dimensions)};
                    }
                    case "C": {
                        return new KlassRef[]{this.context.getMeta()._char.getArrayClass(dimensions)};
                    }
                    case "B": {
                        return new KlassRef[]{this.context.getMeta()._byte.getArrayClass(dimensions)};
                    }
                    case "J": {
                        return new KlassRef[]{this.context.getMeta()._long.getArrayClass(dimensions)};
                    }
                    case "D": {
                        return new KlassRef[]{this.context.getMeta()._double.getArrayClass(dimensions)};
                    }
                    case "F": {
                        return new KlassRef[]{this.context.getMeta()._float.getArrayClass(dimensions)};
                    }
                }
                throw new RuntimeException("invalid primitive component type " + componentRawName);
            }
            String componentType = componentRawName.substring(1, componentRawName.length() - 1);
            Symbol<Symbol.Type> type = this.context.getTypes().fromClassGetName(componentType);
            Klass[] klassRefs = this.context.getRegistries().findLoadedClassAny(type);
            KlassRef[] result = new KlassRef[klassRefs.length];
            for (int i = 0; i < klassRefs.length; ++i) {
                result[i] = klassRefs[i].getArrayClass(dimensions);
            }
            return result;
        }
        Symbol<Symbol.Type> type = this.context.getTypes().fromClassGetName(slashName);
        return this.context.getRegistries().findLoadedClassAny(type);
    }

    @Override
    public KlassRef[] getAllLoadedClasses() {
        return this.context.getRegistries().getAllLoadedClasses();
    }

    @Override
    public List<? extends KlassRef> getInitiatedClasses(Object classLoader) {
        return this.context.getRegistries().getLoadedClassesByLoader((StaticObject)classLoader);
    }

    @Override
    public boolean isValidClassLoader(Object object) {
        if (object instanceof StaticObject) {
            StaticObject loader = (StaticObject)object;
            return InterpreterToVM.instanceOf(loader, this.context.getMeta().java_lang_ClassLoader);
        }
        return false;
    }

    @Override
    public Object asGuestThread(Thread hostThread) {
        return this.context.getGuestThreadFromHost(hostThread);
    }

    @Override
    public Thread asHostThread(Object thread) {
        return this.context.getThreadAccess().getHost((StaticObject)thread);
    }

    @Override
    public boolean isVirtualThread(Object thread) {
        return this.context.getThreadAccess().isVirtualThread((StaticObject)thread);
    }

    @Override
    public boolean isSingleSteppingDisabled() {
        return this.context.getLanguage().getThreadLocalState().isSteppingDisabled();
    }

    @Override
    public Object allocateInstance(KlassRef klass) {
        return this.context.getAllocator().createNew((ObjectKlass)klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void steppingInProgress(Thread t, boolean value) {
        Object previous = null;
        try {
            previous = this.controller.enterTruffleContext();
            this.context.getLanguage().getThreadLocalStateFor(t).setSteppingInProgress(value);
        }
        finally {
            this.controller.leaveTruffleContext(previous);
        }
    }

    @Override
    public Object[] getAllGuestThreads() {
        StaticObject[] activeThreads = this.context.getActiveThreads();
        ArrayList<StaticObject> result = new ArrayList<StaticObject>(activeThreads.length);
        for (StaticObject activeThread : activeThreads) {
            if ("Ljava/lang/ref/Reference$ReferenceHandler;".equals(activeThread.getKlass().getType().toString()) || "Ljava/lang/ref/Finalizer$FinalizerThread;".equals(activeThread.getKlass().getType().toString())) continue;
            result.add(activeThread);
        }
        return result.toArray(new StaticObject[result.size()]);
    }

    @Override
    public String getStringValue(Object object) {
        if (object instanceof StaticObject) {
            StaticObject staticObject = (StaticObject)object;
            return (String)InteropLibrary.getUncached().toDisplayString((Object)staticObject, false);
        }
        return object.toString();
    }

    @Override
    public MethodRef getMethodFromRootNode(RootNode root) {
        if (root != null && root instanceof EspressoRootNode) {
            return ((EspressoRootNode)root).getMethodVersion();
        }
        return null;
    }

    @Override
    public KlassRef getRefType(Object object) {
        if (object instanceof StaticObject) {
            return ((StaticObject)object).getKlass();
        }
        throw new IllegalStateException("object " + String.valueOf(object) + " is not a static object");
    }

    @Override
    public KlassRef getReflectedType(Object classObject) {
        StaticObject staticObject;
        if (classObject instanceof StaticObject && (staticObject = (StaticObject)classObject).getKlass().getType() == Symbol.Type.java_lang_Class) {
            return (KlassRef)this.context.getMeta().HIDDEN_MIRROR_KLASS.getHiddenObject(staticObject);
        }
        return null;
    }

    @Override
    public KlassRef[] getNestedTypes(KlassRef klass) {
        if (klass instanceof ObjectKlass) {
            ObjectKlass objectKlass = (ObjectKlass)klass;
            ArrayList<Klass> result = new ArrayList<Klass>();
            List<Symbol<Symbol.Name>> nestedTypeNames = objectKlass.getNestedTypeNames();
            StaticObject classLoader = objectKlass.getDefiningClassLoader();
            for (Symbol<Symbol.Name> nestedType : nestedTypeNames) {
                Symbol<Symbol.Type> type = this.context.getTypes().fromClassGetName(nestedType.toString());
                Klass loadedKlass = this.context.getRegistries().findLoadedClass(type, classLoader);
                if (loadedKlass == null || loadedKlass == klass) continue;
                result.add(loadedKlass);
            }
            return result.toArray(new KlassRef[0]);
        }
        return null;
    }

    @Override
    public byte getTag(Object object) {
        if (object == null) {
            return 76;
        }
        int tag = 76;
        if (object instanceof StaticObject) {
            StaticObject staticObject = (StaticObject)object;
            if (object == StaticObject.NULL) {
                return (byte)tag;
            }
            tag = staticObject.getKlass().getTagConstant();
            if (tag == 76) {
                if (staticObject.getKlass() == this.context.getMeta().java_lang_String) {
                    tag = 115;
                } else if (staticObject.getKlass().isArray()) {
                    tag = 91;
                } else if (this.context.getMeta().java_lang_Thread.isAssignableFrom(staticObject.getKlass())) {
                    tag = 116;
                } else if (this.context.getMeta().java_lang_ThreadGroup.isAssignableFrom(staticObject.getKlass())) {
                    tag = 103;
                } else if (staticObject.getKlass() == this.context.getMeta().java_lang_Class) {
                    tag = 99;
                } else if (this.context.getMeta().java_lang_ClassLoader.isAssignableFrom(staticObject.getKlass())) {
                    tag = 108;
                }
            }
        } else if (JDWPContextImpl.isBoxedPrimitive(object.getClass())) {
            tag = TagConstants.getTagFromPrimitive(object);
        }
        return (byte)tag;
    }

    private static boolean isBoxedPrimitive(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || Character.class == clazz || Boolean.class == clazz;
    }

    @Override
    public String getThreadName(Object thread) {
        return this.context.getThreadAccess().getThreadName((StaticObject)thread);
    }

    @Override
    public int getThreadStatus(Object thread) {
        return this.context.getThreadAccess().getState((StaticObject)thread);
    }

    @Override
    public Object getThreadGroup(Object thread) {
        return this.context.getThreadAccess().getThreadGroup((StaticObject)thread);
    }

    @Override
    public Object[] getTopLevelThreadGroups() {
        return new Object[]{this.context.getMainThreadGroup()};
    }

    @Override
    public int getArrayLength(Object array) {
        StaticObject staticObject = (StaticObject)array;
        EspressoLanguage language = this.context.getLanguage();
        if (staticObject.isForeignObject()) {
            try {
                long arrayLength = UNCACHED.getArraySize(staticObject.rawForeignObject(language));
                if (arrayLength > Integer.MAX_VALUE) {
                    return -1;
                }
                return (int)arrayLength;
            }
            catch (UnsupportedMessageException e) {
                return -1;
            }
        }
        return staticObject.length(language);
    }

    @Override
    public <T> T getUnboxedArray(Object array) {
        StaticObject staticObject = (StaticObject)array;
        EspressoLanguage language = staticObject.getKlass().getContext().getLanguage();
        return staticObject.unwrap(language);
    }

    @Override
    public boolean isArray(Object object) {
        if (object instanceof StaticObject) {
            StaticObject staticObject = (StaticObject)object;
            return staticObject.isArray();
        }
        return false;
    }

    @Override
    public boolean verifyArrayLength(Object array, int maxIndex) {
        return maxIndex <= this.getArrayLength(array);
    }

    @Override
    public byte getArrayComponentTag(Object array) {
        StaticObject staticObject = (StaticObject)array;
        assert (((StaticObject)array).isArray());
        ArrayKlass arrayKlass = (ArrayKlass)staticObject.getKlass();
        if (arrayKlass.getDimension() > 1) {
            return 91;
        }
        return TagConstants.toTagConstant(arrayKlass.getComponentType().getJavaKind());
    }

    @Override
    public Object getStaticFieldValue(FieldRef field) {
        return field.getValue(((ObjectKlass)field.getDeclaringKlass()).tryInitializeAndGetStatics());
    }

    @Override
    public void setStaticFieldValue(FieldRef field, Object value) {
        field.setValue(((ObjectKlass)field.getDeclaringKlass()).tryInitializeAndGetStatics(), value);
    }

    @Override
    public Object getArrayValue(Object array, int index) {
        Object value;
        StaticObject arrayRef = (StaticObject)array;
        if (arrayRef.isForeignObject()) {
            value = ForeignArrayUtils.readForeignArrayElement(arrayRef, index, this.context.getLanguage(), this.context.getMeta(), InteropLibrary.getUncached(), BranchProfile.create());
            if (!(value instanceof StaticObject)) {
                if (value instanceof String) {
                    return this.context.getMeta().toGuestString((String)value);
                }
                throw new IllegalStateException("foreign object conversion not supported");
            }
        } else if (((ArrayKlass)arrayRef.getKlass()).getComponentType().isPrimitive()) {
            Object boxedArray = this.getUnboxedArray(array);
            value = Array.get(boxedArray, index);
        } else {
            value = arrayRef.get(this.context.getLanguage(), index);
        }
        return value;
    }

    @Override
    public void setArrayValue(Object array, int index, Object value) {
        StaticObject arrayRef = (StaticObject)array;
        byte tag = this.getTag(value);
        switch (tag) {
            case 90: {
                this.context.getInterpreterToVM().setArrayByte(this.context.getLanguage(), (Boolean)value != false ? (byte)1 : 0, index, arrayRef);
                break;
            }
            case 66: {
                this.context.getInterpreterToVM().setArrayByte(this.context.getLanguage(), (Byte)value, index, arrayRef);
                break;
            }
            case 83: {
                this.context.getInterpreterToVM().setArrayShort(this.context.getLanguage(), (Short)value, index, arrayRef);
                break;
            }
            case 67: {
                this.context.getInterpreterToVM().setArrayChar(this.context.getLanguage(), ((Character)value).charValue(), index, arrayRef);
                break;
            }
            case 73: {
                this.context.getInterpreterToVM().setArrayInt(this.context.getLanguage(), (Integer)value, index, arrayRef);
                break;
            }
            case 70: {
                this.context.getInterpreterToVM().setArrayFloat(this.context.getLanguage(), ((Float)value).floatValue(), index, arrayRef);
                break;
            }
            case 74: {
                this.context.getInterpreterToVM().setArrayLong(this.context.getLanguage(), (Long)value, index, arrayRef);
                break;
            }
            case 68: {
                this.context.getInterpreterToVM().setArrayDouble(this.context.getLanguage(), (Double)value, index, arrayRef);
                break;
            }
            case 76: 
            case 91: 
            case 115: {
                this.context.getInterpreterToVM().setArrayObject(this.context.getLanguage(), (StaticObject)value, index, arrayRef);
                break;
            }
            default: {
                throw new RuntimeException("should not reach here: " + tag);
            }
        }
    }

    @Override
    public Object newArray(KlassRef klass, int length) {
        ArrayKlass arrayKlass = (ArrayKlass)klass;
        Klass componentType = arrayKlass.getComponentType();
        if (componentType.isPrimitive()) {
            return this.context.getAllocator().createNewPrimitiveArray(componentType, length);
        }
        return this.context.getAllocator().createNewReferenceArray(componentType, length);
    }

    @Override
    public Object toGuestString(String string) {
        return this.context.getMeta().toGuestString(string);
    }

    @Override
    public Object getGuestException(Throwable exception) {
        if (exception instanceof EspressoException) {
            EspressoException ex = (EspressoException)((Object)exception);
            return ex.getGuestException();
        }
        throw new RuntimeException("unknown exception type: " + String.valueOf(exception.getClass()), exception);
    }

    @Override
    public CallFrame[] getStackTrace(Object thread) {
        Thread hostThread = this.asHostThread(thread);
        if (Thread.currentThread() == hostThread) {
            return this.controller.getCallFrames(thread);
        }
        CollectStackFramesAction action = new CollectStackFramesAction(thread);
        Future future = this.context.getEnv().submitThreadLocal(new Thread[]{hostThread}, (ThreadLocalAction)action);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            return action.result;
        }
        catch (ExecutionException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
        catch (InterruptedException | TimeoutException e) {
            future.cancel(true);
            return new CallFrame[0];
        }
    }

    @Override
    public boolean isInstanceOf(Object object, KlassRef klass) {
        StaticObject staticObject = (StaticObject)object;
        return klass.isAssignable(staticObject.getKlass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopThread(Object guestThread, Object guestThrowable) {
        Object previous = null;
        try {
            previous = this.controller.enterTruffleContext();
            this.context.getThreadAccess().stop((StaticObject)guestThread, (StaticObject)guestThrowable);
        }
        finally {
            this.controller.leaveTruffleContext(previous);
        }
    }

    @Override
    public void interruptThread(Object thread) {
        Object previous = null;
        try {
            previous = this.controller.enterTruffleContext();
            this.context.interruptThread((StaticObject)thread);
        }
        finally {
            this.controller.leaveTruffleContext(previous);
        }
    }

    @Override
    public boolean systemExitImplemented() {
        return true;
    }

    @Override
    public void exit(int exitCode) {
        Object previous = null;
        try {
            previous = this.controller.enterTruffleContext();
            this.context.truffleExit(null, exitCode);
        }
        finally {
            this.controller.leaveTruffleContext(previous);
        }
    }

    @Override
    public List<Path> getClassPath() {
        return this.context.getVmProperties().classpath();
    }

    @Override
    public List<Path> getBootClassPath() {
        return this.context.getVmProperties().bootClasspath();
    }

    @Override
    public int getCatchLocation(MethodRef method, Object guestException, int bci) {
        if (guestException instanceof StaticObject) {
            Method.MethodVersion guestMethod = (Method.MethodVersion)method;
            return guestMethod.getMethod().getCatchLocation(bci, (StaticObject)guestException);
        }
        return -1;
    }

    @Override
    public int getNextBCI(RootNode callerRoot, Frame frame) {
        if (callerRoot instanceof EspressoRootNode) {
            EspressoRootNode espressoRootNode = (EspressoRootNode)callerRoot;
            int bci = (int)this.readBCIFromFrame(callerRoot, frame);
            if (bci >= 0) {
                BytecodeStream bs = new BytecodeStream(espressoRootNode.getMethodVersion().getOriginalCode());
                return bs.nextBCI(bci);
            }
        }
        return -1;
    }

    @Override
    public long readBCIFromFrame(RootNode root, Frame frame) {
        if (root instanceof EspressoRootNode) {
            EspressoRootNode rootNode = (EspressoRootNode)root;
            if (frame != null) {
                return rootNode.readBCI(frame);
            }
        }
        return -1L;
    }

    @Override
    public CallFrame locateObjectWaitFrame() {
        Object currentThread = this.asGuestThread(Thread.currentThread());
        ObjectKlass klass = this.context.getMeta().java_lang_Object;
        Method.MethodVersion method = this.context.getMeta().java_lang_Object_wait.getMethodVersion();
        return new CallFrame(this.ids.getIdAsLong(currentThread), 1, this.ids.getIdAsLong(klass), method, this.ids.getIdAsLong(method), 0L, null, null, null, null, null, LOGGER);
    }

    @Override
    public Object getMonitorOwnerThread(Object object) {
        EspressoLock lock;
        Thread ownerThread;
        if (object instanceof StaticObject && (ownerThread = (lock = ((StaticObject)object).getLock(this.context)).getOwnerThread()) != null) {
            return this.asGuestThread(ownerThread);
        }
        return null;
    }

    @Override
    public int getMonitorEntryCount(Object monitorOwnerThread, Object monitor) {
        if (!(monitor instanceof StaticObject)) {
            return -1;
        }
        StaticObject theMonitor = (StaticObject)monitor;
        Thread hostThread = this.asHostThread(monitorOwnerThread);
        if (Thread.currentThread() == hostThread) {
            EspressoLock lock = theMonitor.getLock(this.context);
            return lock.getEntryCount();
        }
        GetMonitorEntryCountAction action = new GetMonitorEntryCountAction(theMonitor);
        Future future = this.context.getEnv().submitThreadLocal(new Thread[]{hostThread}, (ThreadLocalAction)action);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            return action.result;
        }
        catch (ExecutionException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
        catch (InterruptedException | TimeoutException e) {
            future.cancel(true);
            return 1;
        }
    }

    @Override
    public MonitorStackInfo[] getOwnedMonitors(CallFrame[] callFrames) {
        ArrayList<MonitorStackInfo> result = new ArrayList<MonitorStackInfo>();
        int stackDepth = 0;
        for (CallFrame callFrame : callFrames) {
            EspressoRootNode espressoRootNode;
            RootNode rootNode = callFrame.getRootNode();
            if (rootNode instanceof EspressoRootNode && (espressoRootNode = (EspressoRootNode)rootNode).usesMonitors()) {
                StaticObject[] monitors;
                for (StaticObject monitor : monitors = espressoRootNode.getMonitorsOnFrame(callFrame.getFrame())) {
                    if (monitor == null) continue;
                    result.add(new MonitorStackInfo(monitor, stackDepth));
                }
            }
            ++stackDepth;
        }
        return result.toArray(new MonitorStackInfo[result.size()]);
    }

    @Override
    public void clearFrameMonitors(CallFrame frame) {
        RootNode rootNode = frame.getRootNode();
        if (rootNode instanceof EspressoRootNode) {
            EspressoRootNode espressoRootNode = (EspressoRootNode)rootNode;
            espressoRootNode.abortInternalMonitors(frame.getFrame());
        }
    }

    @Override
    public Class<? extends TruffleLanguage<?>> getLanguageClass() {
        return EspressoLanguage.class;
    }

    private BciProvider getBciProviderNode(Node node) {
        if (node instanceof BciProvider) {
            BciProvider bciProvider = (BciProvider)node;
            return bciProvider;
        }
        for (Node currentNode = node.getParent(); currentNode != null; currentNode = currentNode.getParent()) {
            if (!(currentNode instanceof BciProvider)) continue;
            return (BciProvider)currentNode;
        }
        Node instrumentableNode = this.getInstrumentableNode(node.getRootNode());
        if (instrumentableNode instanceof BciProvider) {
            BciProvider bciProvider = (BciProvider)instrumentableNode;
            return bciProvider;
        }
        return null;
    }

    @Override
    public long getBCI(Node rawNode, Frame frame) {
        BciProvider bciProvider = this.getBciProviderNode(rawNode);
        if (bciProvider == null) {
            return -1L;
        }
        return bciProvider.getBci(frame);
    }

    @Override
    public Node getInstrumentableNode(RootNode rootNode) {
        if (rootNode instanceof EspressoRootNode) {
            EspressoInstrumentableRootNode baseMethodNode = ((EspressoRootNode)rootNode).getMethodNode();
            if (baseMethodNode instanceof InstrumentableNode.WrapperNode) {
                return ((InstrumentableNode.WrapperNode)baseMethodNode).getDelegateNode();
            }
            return baseMethodNode;
        }
        return rootNode;
    }

    @Override
    public boolean isMemberOf(Object guestObject, KlassRef klass) {
        if (guestObject instanceof StaticObject) {
            StaticObject staticObject = (StaticObject)guestObject;
            return klass.isAssignable(staticObject.getKlass());
        }
        return false;
    }

    @Override
    public ModuleRef[] getAllModulesRefs() {
        return this.context.getRegistries().getAllModuleRefs();
    }

    public void rerunclinit(ObjectKlass oldKlass) {
        this.classInitializerActions.add(new ReloadingAction(oldKlass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int redefineClasses(List<RedefineInfo> redefineInfos) {
        ArrayList<ObjectKlass> changedKlasses = new ArrayList<ObjectKlass>(redefineInfos.size());
        try {
            this.controller.fine(() -> "Redefining " + redefineInfos.size() + " classes");
            this.classRedefinition.begin();
            this.classRedefinition.clearDelegationFields();
            this.classRedefinition.invalidateMissingFields();
            this.doRedefine(redefineInfos, changedKlasses);
            List<RedefineInfo> additional = Collections.synchronizedList(new ArrayList());
            this.classRedefinition.addExtraReloadClasses(redefineInfos, additional);
            this.doRedefine(additional, changedKlasses);
            this.classInitializerActions.forEach(reloadingAction -> {
                try {
                    reloadingAction.fire();
                }
                catch (Throwable t) {
                    this.controller.warning(() -> "exception while re-running a class initializer!");
                }
            });
            assert (!changedKlasses.contains(null));
            try {
                this.classRedefinition.runPostRedefinitionListeners(changedKlasses.toArray(new ObjectKlass[changedKlasses.size()]));
            }
            catch (Throwable t) {
                this.controller.severe(() -> JDWPContextImpl.class.getName() + ": redefineClasses: " + t.getMessage());
            }
        }
        catch (RedefinitionNotSupportedException ex) {
            int n = ex.getErrorCode();
            return n;
        }
        finally {
            this.classRedefinition.end();
        }
        return 0;
    }

    private void doRedefine(List<RedefineInfo> redefineInfos, List<ObjectKlass> changedKlasses) throws RedefinitionNotSupportedException {
        ArrayList<ObjectKlass> removedInnerClasses = new ArrayList<ObjectKlass>(0);
        ArrayList<ObjectKlass> invalidatedClasses = new ArrayList<ObjectKlass>();
        ArrayList<ObjectKlass> redefinedClasses = new ArrayList<ObjectKlass>();
        HotSwapClassInfo[] matchedInfos = this.innerClassRedefiner.matchAnonymousInnerClasses(redefineInfos, removedInnerClasses);
        List<ChangePacket> changePackets = this.classRedefinition.detectClassChanges(matchedInfos);
        Collections.sort(changePackets, new HierarchyComparator());
        for (ChangePacket packet : changePackets) {
            this.controller.fine(() -> "Redefining class " + String.valueOf(packet.info.getNewName()));
            int result = this.classRedefinition.redefineClass(packet, invalidatedClasses, redefinedClasses);
            if (result == 0) continue;
            throw new RedefinitionNotSupportedException(result);
        }
        Collections.sort(invalidatedClasses, new SubClassHierarchyComparator());
        for (ObjectKlass invalidatedClass : invalidatedClasses) {
            if (redefinedClasses.contains(invalidatedClass)) continue;
            this.controller.fine(() -> "Refreshing invalidated class " + String.valueOf(invalidatedClass.getName()));
            invalidatedClass.swapKlassVersion(this.ids);
        }
        changedKlasses.addAll(invalidatedClasses);
        for (ChangePacket changePacket : changePackets) {
            ObjectKlass klass = changePacket.info.getKlass();
            if (klass == null) continue;
            changedKlasses.add(klass);
            if (!changePacket.info.isRenamed()) continue;
            this.ids.updateId(klass);
        }
        this.innerClassRedefiner.commit(matchedInfos);
        for (ObjectKlass removed : removedInnerClasses) {
            removed.removeByRedefinition();
        }
    }

    public void registerExternalHotSwapHandler(StaticObject handler) {
        this.redefinitionPluginHandler.registerExternalHotSwapHandler(handler);
    }

    private final class CollectStackFramesAction
    extends ThreadLocalAction {
        CallFrame[] result;
        final Object guestThread;

        CollectStackFramesAction(Object guestThread) {
            super(false, false);
            this.guestThread = guestThread;
        }

        protected void perform(ThreadLocalAction.Access access) {
            this.result = JDWPContextImpl.this.controller.getCallFrames(this.guestThread);
        }
    }

    private final class GetMonitorEntryCountAction
    extends ThreadLocalAction {
        int result;
        StaticObject monitor;

        GetMonitorEntryCountAction(StaticObject monitor) {
            super(false, false);
            this.monitor = monitor;
        }

        protected void perform(ThreadLocalAction.Access access) {
            EspressoLock lock = this.monitor.getLock(JDWPContextImpl.this.context);
            this.result = lock.getEntryCount();
        }
    }

    private final class ReloadingAction {
        private ObjectKlass klass;

        private ReloadingAction(ObjectKlass klass) {
            this.klass = klass;
        }

        private void fire() {
            this.klass.reRunClinit();
        }
    }

    private static class HierarchyComparator
    implements Comparator<ChangePacket> {
        private HierarchyComparator() {
        }

        @Override
        public int compare(ChangePacket packet1, ChangePacket packet2) {
            ObjectKlass k1 = packet1.info.getKlass();
            ObjectKlass k2 = packet2.info.getKlass();
            if (k1 == null || k2 == null || k1.equals(k2)) {
                return 0;
            }
            if (k1.isAssignableFrom(k2)) {
                return -1;
            }
            if (k2.isAssignableFrom(k1)) {
                return 1;
            }
            Matcher m1 = InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(k1.getNameAsString());
            Matcher m2 = InnerClassRedefiner.ANON_INNER_CLASS_PATTERN.matcher(k2.getNameAsString());
            if (!m1.matches()) {
                return -1;
            }
            if (m2.matches()) {
                return 0;
            }
            return 1;
        }
    }

    private static class SubClassHierarchyComparator
    implements Comparator<ObjectKlass> {
        private SubClassHierarchyComparator() {
        }

        @Override
        public int compare(ObjectKlass k1, ObjectKlass k2) {
            if (k1.equals(k2)) {
                return 0;
            }
            if (k1.isAssignableFrom(k2)) {
                return -1;
            }
            if (k2.isAssignableFrom(k1)) {
                return 1;
            }
            return 0;
        }
    }
}

