/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.jni.RawBuffer;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoProperties;
import java.nio.ByteBuffer;

final class JImageLibrary
extends ContextAccessImpl {
    private static final String VERSION_STRING = "11.0";
    private static final String LIBJIMAGE_NAME = "jimage";
    private static final String OPEN = "JIMAGE_Open";
    private static final String CLOSE = "JIMAGE_Close";
    private static final String PACKAGE_TO_MOODULE = "JIMAGE_PackageToModule";
    private static final String FIND_RESOURCE = "JIMAGE_FindResource";
    private static final String GET_RESOURCE = "JIMAGE_GetResource";
    private static final NativeSignature OPEN_SIGNATURE = NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.POINTER);
    private static final NativeSignature CLOSE_SIGNATURE = NativeSignature.create(NativeType.VOID, NativeType.POINTER);
    private static final NativeSignature PACKAGE_TO_MODULE_SIGNATURE = NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.POINTER);
    private static final NativeSignature FIND_RESOURCE_SIGNATURE = NativeSignature.create(NativeType.LONG, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER);
    private static final NativeSignature GET_RESOURCE_SIGNATURE = NativeSignature.create(NativeType.LONG, NativeType.POINTER, NativeType.LONG, NativeType.POINTER, NativeType.LONG);
    private static final NativeSignature RESOURCE_ITERATOR_SIGNATURE = NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER, NativeType.POINTER);
    private static final NativeSignature RESOURCE_PATH_SIGNATURE = NativeSignature.create(NativeType.BOOLEAN, NativeType.POINTER, NativeType.LONG, NativeType.POINTER, NativeType.LONG);
    private final InteropLibrary uncached;
    private final RawBuffer javaBaseBuffer;
    private final RawBuffer versionBuffer;
    private final RawBuffer emptyStringBuffer;
    private final TruffleObject open;
    private final TruffleObject close;
    private final TruffleObject packageToModule;
    private final TruffleObject findResource;
    private final TruffleObject getResource;

    JImageLibrary(EspressoContext context) {
        super(context);
        EspressoProperties props = this.getContext().getVmProperties();
        TruffleObject jimageLibrary = this.getNativeAccess().loadLibrary(props.bootLibraryPath(), LIBJIMAGE_NAME, true);
        this.open = this.getNativeAccess().lookupAndBindSymbol(jimageLibrary, OPEN, OPEN_SIGNATURE);
        this.close = this.getNativeAccess().lookupAndBindSymbol(jimageLibrary, CLOSE, CLOSE_SIGNATURE);
        this.packageToModule = this.getNativeAccess().lookupAndBindSymbol(jimageLibrary, PACKAGE_TO_MOODULE, PACKAGE_TO_MODULE_SIGNATURE);
        this.findResource = this.getNativeAccess().lookupAndBindSymbol(jimageLibrary, FIND_RESOURCE, FIND_RESOURCE_SIGNATURE);
        this.getResource = this.getNativeAccess().lookupAndBindSymbol(jimageLibrary, GET_RESOURCE, GET_RESOURCE_SIGNATURE);
        this.javaBaseBuffer = RawBuffer.getNativeString("java.base");
        this.versionBuffer = RawBuffer.getNativeString(VERSION_STRING);
        this.emptyStringBuffer = RawBuffer.getNativeString("");
        this.uncached = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    }

    public TruffleObject open(String name) {
        ByteBuffer error = NativeUtils.allocateDirect(JavaKind.Int.getByteCount());
        try (RawBuffer nameBuffer = RawBuffer.getNativeString(name);){
            TruffleObject truffleObject = (TruffleObject)this.execute(this.open, nameBuffer.pointer(), NativeUtils.byteBufferPointer(error));
            return truffleObject;
        }
    }

    public void close(TruffleObject jimage) {
        this.execute(this.close, jimage);
    }

    public byte[] getClassBytes(TruffleObject jimage, ByteSequence name) {
        ByteBuffer sizeBuffer = NativeUtils.allocateDirect(JavaKind.Long.getByteCount());
        TruffleObject sizePtr = NativeUtils.byteBufferPointer(sizeBuffer);
        long location = this.findLocation(jimage, sizePtr, name);
        if (location == 0L) {
            return null;
        }
        long capacity = sizeBuffer.getLong(0);
        ByteBuffer bytes = NativeUtils.allocateDirect((int)capacity);
        TruffleObject bytesPtr = NativeUtils.byteBufferPointer(bytes);
        this.execute(this.getResource, jimage, location, bytesPtr, capacity);
        byte[] result = new byte[(int)capacity];
        bytes.get(result);
        return result;
    }

    private long findLocation(TruffleObject jimage, TruffleObject sizePtr, ByteSequence name) {
        try (RawBuffer nameBuffer = RawBuffer.getNativeString(name);){
            TruffleObject namePtr = nameBuffer.pointer();
            long location = (Long)this.execute(this.findResource, jimage, this.emptyStringBuffer.pointer(), this.versionBuffer.pointer(), namePtr, sizePtr);
            if (location != 0L) {
                long l = location;
                return l;
            }
            ByteSequence pkg = JImageLibrary.packageFromName(name);
            if (pkg == null) {
                long l = 0L;
                return l;
            }
            if (!this.getContext().modulesInitialized()) {
                TruffleObject moduleName;
                location = (Long)this.execute(this.findResource, jimage, this.javaBaseBuffer.pointer(), this.versionBuffer.pointer(), namePtr, sizePtr);
                if (location != 0L || !this.getContext().metaInitialized()) {
                    long l = location;
                    return l;
                }
                try (RawBuffer pkgBuffer = RawBuffer.getNativeString(pkg);){
                    moduleName = (TruffleObject)this.execute(this.packageToModule, jimage, pkgBuffer.pointer());
                }
                if (this.uncached.isNull((Object)moduleName)) {
                    long pkgBuffer = 0L;
                    return pkgBuffer;
                }
                long pkgBuffer = (Long)this.execute(this.findResource, jimage, moduleName, this.versionBuffer.pointer(), namePtr, sizePtr);
                return pkgBuffer;
            }
            Symbol<Symbol.Name> pkgSymbol = this.getNames().lookup(pkg);
            if (pkgSymbol == null) {
                long pkgBuffer = 0L;
                return pkgBuffer;
            }
            PackageTable.PackageEntry pkgEntry = (PackageTable.PackageEntry)this.getRegistries().getBootClassRegistry().packages().lookup(pkgSymbol);
            if (pkgEntry == null) {
                long l = 0L;
                return l;
            }
            Symbol<Symbol.Name> moduleName = pkgEntry.module().getName();
            if (moduleName == Symbol.Name.java_base) {
                long l = (Long)this.execute(this.findResource, jimage, this.javaBaseBuffer.pointer(), this.versionBuffer.pointer(), namePtr, sizePtr);
                return l;
            }
            String nameAsString = moduleName == null ? "" : moduleName.toString();
            RawBuffer moduleNameBuffer = RawBuffer.getNativeString(nameAsString);
            try {
                long l = (Long)this.execute(this.findResource, jimage, moduleNameBuffer.pointer(), this.versionBuffer.pointer(), namePtr, sizePtr);
                if (moduleNameBuffer != null) {
                    moduleNameBuffer.close();
                }
                return l;
            }
            catch (Throwable throwable) {
                if (moduleNameBuffer != null) {
                    try {
                        moduleNameBuffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static ByteSequence packageFromName(ByteSequence name) {
        int lastSlash = name.lastIndexOf((byte)47);
        if (lastSlash == -1) {
            return null;
        }
        return name.subSequence(0, lastSlash);
    }

    private Object execute(Object target, Object ... args) {
        try {
            return this.uncached.execute(target, args);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }
}

