/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.meta.EspressoError;

public enum OS {
    Darwin,
    Linux,
    Solaris,
    Windows;

    private static final OS current;

    private static OS findCurrent() {
        String name = System.getProperty("os.name");
        if (name.equals("Linux")) {
            return Linux;
        }
        if (name.equals("SunOS")) {
            return Solaris;
        }
        if (name.equals("Mac OS X") || name.equals("Darwin")) {
            return Darwin;
        }
        if (name.startsWith("Windows")) {
            return Windows;
        }
        throw EspressoError.shouldNotReachHere("unknown OS: " + name);
    }

    public static OS getCurrent() {
        return current;
    }

    static {
        current = OS.findCurrent();
    }
}

