/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.VM;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
@Shareable
public class BaseInterop {
    @ExportMessage
    public static boolean isNull(StaticObject object) {
        return StaticObject.isNull(object);
    }

    @ExportMessage
    public static boolean isString(StaticObject object) {
        return StaticObject.notNull(object) && object.getKlass() == object.getKlass().getMeta().java_lang_String;
    }

    @ExportMessage
    public static String asString(StaticObject object) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (!BaseInterop.isString(object)) {
            throw UnsupportedMessageException.create();
        }
        return Meta.toHostStringStatic(object);
    }

    @ExportMessage
    public static boolean isMetaObject(StaticObject object) {
        object.checkNotForeign();
        return !BaseInterop.isNull(object) && object.isMirrorKlass();
    }

    @ExportMessage
    public static Object getMetaQualifiedName(StaticObject object, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (BaseInterop.isMetaObject(object)) {
            return object.getMirrorKlass().getGuestTypeName();
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static Object getMetaSimpleName(StaticObject object, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (BaseInterop.isMetaObject(object)) {
            return object.getKlass().getMeta().java_lang_Class_getSimpleName.invokeDirectSpecial(object);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static boolean isMetaInstance(StaticObject object, Object instance, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (BaseInterop.isMetaObject(object)) {
            return instance instanceof StaticObject && InterpreterToVM.instanceOf((StaticObject)instance, object.getMirrorKlass());
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static boolean hasMetaObject(StaticObject object) {
        if (object.isForeignObject()) {
            return false;
        }
        return !BaseInterop.isNull(object);
    }

    @ExportMessage
    public static Object getMetaObject(StaticObject object, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (BaseInterop.hasMetaObject(object)) {
            return object.getKlass().mirror();
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static boolean hasMetaParents(StaticObject object) {
        if (object.isForeignObject()) {
            return false;
        }
        if (BaseInterop.isMetaObject(object)) {
            Klass mirrorKlass = object.getMirrorKlass();
            if (mirrorKlass.isInterface()) {
                return mirrorKlass.getSuperInterfaces().length > 0;
            }
            return !mirrorKlass.isPrimitive() && mirrorKlass != object.getKlass().getMeta().java_lang_Object;
        }
        return false;
    }

    @ExportMessage
    public static Object getMetaParents(StaticObject object, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (BaseInterop.hasMetaParents(object)) {
            StaticObject[] result;
            Klass klass = object.getMirrorKlass();
            if (klass.isInterface()) {
                ObjectKlass[] superInterfaces = klass.getSuperInterfaces();
                result = new StaticObject[superInterfaces.length];
                for (int i = 0; i < superInterfaces.length; ++i) {
                    result[i] = superInterfaces[i].mirror();
                }
            } else {
                ObjectKlass superClass = klass.getSuperKlass();
                ObjectKlass[] superInterfaces = klass.getSuperInterfaces();
                result = new StaticObject[superInterfaces.length + 1];
                result[0] = superClass.mirror();
                for (int i = 0; i < superInterfaces.length; ++i) {
                    result[i + 1] = superInterfaces[i].mirror();
                }
            }
            return StaticObject.wrap(result, object.getKlass().getMeta());
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static TriState isIdenticalOrUndefined(StaticObject receiver, Object other, @Cached IsIdenticalOrUndefinedImplNode node) {
        return node.execute(receiver, other);
    }

    @ExportMessage
    public static int identityHashCode(StaticObject object) {
        object.checkNotForeign();
        return VM.JVM_IHashCode(object, null);
    }

    @ExportMessage
    public static boolean hasLanguage(StaticObject object) {
        return true;
    }

    @ExportMessage
    public static Class<? extends TruffleLanguage<?>> getLanguage(StaticObject object) {
        return EspressoLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public static Object toDisplayString(StaticObject object, boolean allowSideEffects) {
        if (object.isForeignObject()) {
            if (object.getKlass() == null) {
                return "Foreign receiver: null";
            }
            InteropLibrary interopLibrary = InteropLibrary.getUncached();
            try {
                EspressoLanguage language = object.getKlass().getContext().getLanguage();
                return "Foreign receiver: " + interopLibrary.asString(interopLibrary.toDisplayString(object.rawForeignObject(language), allowSideEffects));
            }
            catch (UnsupportedMessageException e) {
                throw EspressoError.shouldNotReachHere("Interop library failed to convert display string to string");
            }
        }
        if (StaticObject.isNull(object)) {
            return "NULL";
        }
        Klass thisKlass = object.getKlass();
        Meta meta = thisKlass.getMeta();
        if (allowSideEffects) {
            return meta.toHostString((StaticObject)meta.java_lang_Object_toString.invokeDirectVirtual(object));
        }
        if (thisKlass == meta.java_lang_Class) {
            return "class " + thisKlass.getTypeAsString();
        }
        if (thisKlass == meta.java_lang_String) {
            return meta.toHostString(object);
        }
        return thisKlass.getTypeAsString() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    @GenerateUncached
    static abstract class IsIdenticalOrUndefinedImplNode
    extends Node {
        IsIdenticalOrUndefinedImplNode() {
        }

        public abstract TriState execute(StaticObject var1, Object var2);

        @Specialization
        public static TriState doStaticObject(StaticObject receiver, StaticObject other) {
            receiver.checkNotForeign();
            other.checkNotForeign();
            return receiver == other ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(StaticObject receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

