/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ByteBufferInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ByteBufferInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;
import java.nio.ByteOrder;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class ByteBufferInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(ByteBufferInterop.class));
    private static final InteropNodes INSTANCE = new ByteBufferInteropInteropNodes();

    private ByteBufferInteropInteropNodes() {
        super(ByteBufferInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.HasBufferElements, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsBufferWritable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetBufferSize, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadBufferByte, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteBufferByte, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadBufferShort, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteBufferShort, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadBufferInt, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteBufferInt, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadBufferLong, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteBufferLong, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadBufferFloat, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteBufferFloat, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadBufferDouble, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteBufferDouble, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadBuffer, factory, false);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case HasBufferElements: {
                    return ByteBufferInteropInteropNodesFactory.HasBufferElementsNodeGen.create();
                }
                case IsBufferWritable: {
                    return ByteBufferInteropInteropNodesFactory.IsBufferWritableNodeGen.create();
                }
                case GetBufferSize: {
                    return ByteBufferInteropInteropNodesFactory.GetBufferSizeNodeGen.create();
                }
                case ReadBufferByte: {
                    return ByteBufferInteropInteropNodesFactory.ReadBufferByteNodeGen.create();
                }
                case WriteBufferByte: {
                    return ByteBufferInteropInteropNodesFactory.WriteBufferByteNodeGen.create();
                }
                case ReadBufferShort: {
                    return ByteBufferInteropInteropNodesFactory.ReadBufferShortNodeGen.create();
                }
                case WriteBufferShort: {
                    return ByteBufferInteropInteropNodesFactory.WriteBufferShortNodeGen.create();
                }
                case ReadBufferInt: {
                    return ByteBufferInteropInteropNodesFactory.ReadBufferIntNodeGen.create();
                }
                case WriteBufferInt: {
                    return ByteBufferInteropInteropNodesFactory.WriteBufferIntNodeGen.create();
                }
                case ReadBufferLong: {
                    return ByteBufferInteropInteropNodesFactory.ReadBufferLongNodeGen.create();
                }
                case WriteBufferLong: {
                    return ByteBufferInteropInteropNodesFactory.WriteBufferLongNodeGen.create();
                }
                case ReadBufferFloat: {
                    return ByteBufferInteropInteropNodesFactory.ReadBufferFloatNodeGen.create();
                }
                case WriteBufferFloat: {
                    return ByteBufferInteropInteropNodesFactory.WriteBufferFloatNodeGen.create();
                }
                case ReadBufferDouble: {
                    return ByteBufferInteropInteropNodesFactory.ReadBufferDoubleNodeGen.create();
                }
                case WriteBufferDouble: {
                    return ByteBufferInteropInteropNodesFactory.WriteBufferDoubleNodeGen.create();
                }
                case ReadBuffer: {
                    return ByteBufferInteropInteropNodesFactory.ReadBufferNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class ReadBufferNode
    extends InteropMessage.ReadBuffer {
        ReadBufferNode() {
        }

        @Specialization
        static void readBuffer(StaticObject receiver, long byteOffset, byte[] destination, int destinationOffset, int length, @Bind(value="getMeta()") Meta meta, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode readBuffer, @Cached(value="create($parameters)") BranchProfile error) throws InvalidBufferOffsetException {
            ByteBufferInterop.readBuffer(receiver, byteOffset, destination, destinationOffset, length, meta, readBuffer, error);
        }
    }

    static abstract class WriteBufferDoubleNode
    extends InteropMessage.WriteBufferDouble {
        WriteBufferDoubleNode() {
        }

        @Specialization
        static void writeBufferDouble(StaticObject receiver, ByteOrder order, long byteOffset, double value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putDouble") Method putDoubleMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            ByteBufferInterop.writeBufferDouble(receiver, order, byteOffset, value, isReadOnlyMethod, lookup, putDoubleMethod, put, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class ReadBufferDoubleNode
    extends InteropMessage.ReadBufferDouble {
        ReadBufferDoubleNode() {
        }

        @Specialization
        static double readBufferDouble(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getDouble") Method getDoubleMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws InvalidBufferOffsetException {
            return ByteBufferInterop.readBufferDouble(receiver, order, byteOffset, getDoubleMethod, get, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class WriteBufferFloatNode
    extends InteropMessage.WriteBufferFloat {
        WriteBufferFloatNode() {
        }

        @Specialization
        static void writeBufferFloat(StaticObject receiver, ByteOrder order, long byteOffset, float value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putFloat") Method putFloatMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            ByteBufferInterop.writeBufferFloat(receiver, order, byteOffset, value, isReadOnlyMethod, lookup, putFloatMethod, put, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class ReadBufferFloatNode
    extends InteropMessage.ReadBufferFloat {
        ReadBufferFloatNode() {
        }

        @Specialization
        static float readBufferFloat(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getFloat") Method getFloatMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws InvalidBufferOffsetException {
            return ByteBufferInterop.readBufferFloat(receiver, order, byteOffset, getFloatMethod, get, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class WriteBufferLongNode
    extends InteropMessage.WriteBufferLong {
        WriteBufferLongNode() {
        }

        @Specialization
        static void writeBufferLong(StaticObject receiver, ByteOrder order, long byteOffset, long value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putLong") Method putLongMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            ByteBufferInterop.writeBufferLong(receiver, order, byteOffset, value, isReadOnlyMethod, lookup, putLongMethod, put, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class ReadBufferLongNode
    extends InteropMessage.ReadBufferLong {
        ReadBufferLongNode() {
        }

        @Specialization
        static long readBufferLong(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getLong") Method getLongMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws InvalidBufferOffsetException {
            return ByteBufferInterop.readBufferLong(receiver, order, byteOffset, getLongMethod, get, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class WriteBufferIntNode
    extends InteropMessage.WriteBufferInt {
        WriteBufferIntNode() {
        }

        @Specialization
        static void writeBufferInt(StaticObject receiver, ByteOrder order, long byteOffset, int value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putInt") Method putIntMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            ByteBufferInterop.writeBufferInt(receiver, order, byteOffset, value, isReadOnlyMethod, lookup, putIntMethod, put, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class ReadBufferIntNode
    extends InteropMessage.ReadBufferInt {
        ReadBufferIntNode() {
        }

        @Specialization
        static int readBufferInt(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getInt") Method getIntMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws InvalidBufferOffsetException {
            return ByteBufferInterop.readBufferInt(receiver, order, byteOffset, getIntMethod, get, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class WriteBufferShortNode
    extends InteropMessage.WriteBufferShort {
        WriteBufferShortNode() {
        }

        @Specialization
        static void writeBufferShort(StaticObject receiver, ByteOrder order, long byteOffset, short value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putShort") Method putShortMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode put, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            ByteBufferInterop.writeBufferShort(receiver, order, byteOffset, value, isReadOnlyMethod, lookup, putShortMethod, put, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class ReadBufferShortNode
    extends InteropMessage.ReadBufferShort {
        ReadBufferShortNode() {
        }

        @Specialization
        static short readBufferShort(StaticObject receiver, ByteOrder order, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getShort") Method getShortMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode get, @Bind(value="getMeta().java_nio_ByteBuffer_order") Method orderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode orderNode, @Bind(value="getMeta().java_nio_ByteBuffer_setOrder") Method setOrderMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode setOrderNode, @Cached(value="create($parameters)") BranchProfile error) throws InvalidBufferOffsetException {
            return ByteBufferInterop.readBufferShort(receiver, order, byteOffset, getShortMethod, get, orderMethod, orderNode, setOrderMethod, setOrderNode, error);
        }
    }

    static abstract class WriteBufferByteNode
    extends InteropMessage.WriteBufferByte {
        WriteBufferByteNode() {
        }

        @Specialization
        static void writeBufferByte(StaticObject receiver, long byteOffset, byte value, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookup, @Bind(value="getMeta().java_nio_ByteBuffer_putByte") Method putByteAtMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode put, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            ByteBufferInterop.writeBufferByte(receiver, byteOffset, value, isReadOnlyMethod, lookup, putByteAtMethod, put, error);
        }
    }

    static abstract class ReadBufferByteNode
    extends InteropMessage.ReadBufferByte {
        ReadBufferByteNode() {
        }

        @Specialization
        static byte readBufferByte(StaticObject receiver, long byteOffset, @Bind(value="getMeta().java_nio_ByteBuffer_getByte") Method getByteMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode get, @Cached(value="create($parameters)") BranchProfile error) throws InvalidBufferOffsetException {
            return ByteBufferInterop.readBufferByte(receiver, byteOffset, getByteMethod, get, error);
        }
    }

    static abstract class GetBufferSizeNode
    extends InteropMessage.GetBufferSize {
        GetBufferSizeNode() {
        }

        @Specialization
        static long getBufferSize(StaticObject receiver, @Bind(value="getMeta().java_nio_Buffer_limit") Method limitMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode size) {
            return ByteBufferInterop.getBufferSize(receiver, limitMethod, size);
        }
    }

    static abstract class IsBufferWritableNode
    extends InteropMessage.IsBufferWritable {
        IsBufferWritableNode() {
        }

        @Specialization
        static boolean isBufferWritable(StaticObject receiver, @Bind(value="getMeta().java_nio_Buffer_isReadOnly") Method isReadOnlyMethod, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookup) {
            return ByteBufferInterop.isBufferWritable(receiver, isReadOnlyMethod, lookup);
        }
    }

    static abstract class HasBufferElementsNode
    extends InteropMessage.HasBufferElements {
        HasBufferElementsNode() {
        }

        @Specialization
        static boolean hasBufferElements(StaticObject receiver) {
            return ByteBufferInterop.hasBufferElements(receiver);
        }
    }
}

