/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
public class MapInterop
extends EspressoInterop {
    private static boolean containsKey(StaticObject receiver, Object key, InvokeEspressoNode invokeContains) {
        Meta meta = receiver.getKlass().getMeta();
        Method containsKey = MapInterop.getInteropKlass(receiver).itableLookup(meta.java_util_Map, meta.java_util_Map_containsKey.getITableIndex());
        try {
            return (Boolean)invokeContains.execute(containsKey, receiver, new Object[]{key});
        }
        catch (ArityException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    @Shareable
    public static boolean hasHashEntries(StaticObject receiver) {
        assert (InterpreterToVM.instanceOf(receiver, receiver.getKlass().getMeta().java_util_Map));
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isHashEntryReadable"), @ExportMessage(name="isHashEntryModifiable"), @ExportMessage(name="isHashEntryRemovable")})
    public static boolean isHashEntryReadable(StaticObject receiver, Object key, @Cached.Shared(value="contains") @Cached InvokeEspressoNode invoke) {
        return MapInterop.containsKey(receiver, key, invoke);
    }

    @ExportMessage
    public static boolean isHashEntryInsertable(StaticObject receiver, Object key, @Cached.Shared(value="contains") @Cached InvokeEspressoNode invoke) {
        return !MapInterop.containsKey(receiver, key, invoke);
    }

    @ExportMessage
    public static long getHashSize(StaticObject receiver, @Cached.Exclusive @Cached InvokeEspressoNode invoke) throws UnsupportedMessageException {
        if (!MapInterop.hasHashEntries(receiver)) {
            throw UnsupportedMessageException.create();
        }
        Meta meta = receiver.getKlass().getMeta();
        Method size = MapInterop.getInteropKlass(receiver).itableLookup(meta.java_util_Map, meta.java_util_Map_size.getITableIndex());
        try {
            return ((Integer)invoke.execute(size, receiver, StaticObject.EMPTY_ARRAY)).intValue();
        }
        catch (ArityException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    public static Object readHashValue(StaticObject receiver, Object key, @Cached.Exclusive @Cached InvokeEspressoNode invoke, @Cached.Shared(value="contains") @Cached InvokeEspressoNode contains) throws UnknownKeyException {
        boolean isReadable = MapInterop.isHashEntryReadable(receiver, key, contains);
        if (!isReadable) {
            throw UnknownKeyException.create((Object)key);
        }
        Meta meta = receiver.getKlass().getMeta();
        Method get = MapInterop.getInteropKlass(receiver).itableLookup(meta.java_util_Map, meta.java_util_Map_get.getITableIndex());
        try {
            return invoke.execute(get, receiver, new Object[]{key});
        }
        catch (UnsupportedTypeException e) {
            throw UnknownKeyException.create((Object)key);
        }
        catch (ArityException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    public static void writeHashEntry(StaticObject receiver, Object key, Object value, @Cached.Exclusive @Cached InvokeEspressoNode invoke) throws UnknownKeyException, UnsupportedMessageException {
        Meta meta = receiver.getKlass().getMeta();
        Method put = MapInterop.getInteropKlass(receiver).itableLookup(meta.java_util_Map, meta.java_util_Map_put.getITableIndex());
        try {
            invoke.execute(put, receiver, new Object[]{key, value});
        }
        catch (UnsupportedTypeException e) {
            throw UnknownKeyException.create((Object)key);
        }
        catch (ArityException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        catch (EspressoException e) {
            if (InterpreterToVM.instanceOf(e.getGuestException(), receiver.getKlass().getMeta().java_lang_UnsupportedOperationException)) {
                throw UnsupportedMessageException.create((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @ExportMessage
    public static void removeHashEntry(StaticObject receiver, Object key, @Cached.Exclusive @Cached InvokeEspressoNode invoke, @Cached.Shared(value="contains") @Cached InvokeEspressoNode contains) throws UnknownKeyException, UnsupportedMessageException {
        if (!MapInterop.isHashEntryReadable(receiver, key, contains)) {
            throw UnknownKeyException.create((Object)key);
        }
        Meta meta = receiver.getKlass().getMeta();
        Method remove = MapInterop.getInteropKlass(receiver).itableLookup(meta.java_util_Map, meta.java_util_Map_remove.getITableIndex());
        try {
            invoke.execute(remove, receiver, new Object[]{key});
        }
        catch (UnsupportedTypeException e) {
            throw UnknownKeyException.create((Object)key);
        }
        catch (ArityException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        catch (EspressoException e) {
            if (InterpreterToVM.instanceOf(e.getGuestException(), receiver.getKlass().getMeta().java_lang_UnsupportedOperationException)) {
                throw UnsupportedMessageException.create((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @ExportMessage
    public static Object getHashEntriesIterator(StaticObject receiver, @CachedLibrary(limit="1") InteropLibrary setLibrary, @Cached.Exclusive @Cached InvokeEspressoNode invoke) throws UnsupportedMessageException {
        if (!MapInterop.hasHashEntries(receiver)) {
            throw UnsupportedMessageException.create();
        }
        Meta meta = receiver.getKlass().getMeta();
        Method entrySet = MapInterop.getInteropKlass(receiver).itableLookup(meta.java_util_Map, meta.java_util_Map_entrySet.getITableIndex());
        Object set = null;
        try {
            set = invoke.execute(entrySet, receiver, StaticObject.EMPTY_ARRAY);
        }
        catch (ArityException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        assert (set != null);
        assert (setLibrary.hasIterator(set));
        return setLibrary.getIterator(set);
    }
}

