/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage;

import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.runtime.jimage.ImageStringsReader;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ImageLocation {
    private static final int ATTRIBUTE_END = 0;
    private static final int ATTRIBUTE_MODULE = 1;
    private static final int ATTRIBUTE_PARENT = 2;
    private static final int ATTRIBUTE_BASE = 3;
    private static final int ATTRIBUTE_EXTENSION = 4;
    private static final int ATTRIBUTE_OFFSET = 5;
    private static final int ATTRIBUTE_COMPRESSED = 6;
    private static final int ATTRIBUTE_UNCOMPRESSED = 7;
    private static final int ATTRIBUTE_COUNT = 8;
    private final long[] attributes;

    public ImageLocation(long[] attributes) {
        this.attributes = Objects.requireNonNull(attributes);
    }

    static ImageLocation decompress(ByteBuffer bytes, int offset) {
        int data;
        int length;
        Objects.requireNonNull(bytes);
        long[] attributes = new long[8];
        int limit = bytes.limit();
        for (int currentOffset = offset; currentOffset < limit && (data = bytes.get(currentOffset++) & 0xFF) > 7; currentOffset += length) {
            int kind = data >>> 3;
            if (kind >= 8) {
                throw new InternalError("Invalid jimage attribute kind: " + kind);
            }
            length = (data & 7) + 1;
            attributes[kind] = ImageLocation.readValue(length, bytes, currentOffset, limit);
        }
        return new ImageLocation(attributes);
    }

    boolean verify(ByteSequence name, ImageStringsReader strings) {
        Objects.requireNonNull(name);
        int length = name.length();
        int index = 0;
        int moduleOffset = (int)this.attributes[1];
        if (moduleOffset != 0 && length >= 1) {
            int moduleLen = strings.match(moduleOffset, name, 1);
            index = moduleLen + 1;
            if (moduleLen < 0 || index >= length || name.unsignedByteAt(0) != 47 || name.unsignedByteAt(index++) != 47) {
                return false;
            }
        }
        return ImageLocation.verifyName(null, name, index, length, 0, (int)this.attributes[2], (int)this.attributes[3], (int)this.attributes[4], strings);
    }

    private static long readValue(int length, ByteBuffer buffer, int offset, int limit) {
        long value = 0L;
        int currentOffset = offset;
        for (int j = 0; j < length; ++j) {
            value <<= 8;
            if (currentOffset >= limit) {
                throw new InternalError("Missing jimage attribute data");
            }
            value |= (long)(buffer.get(currentOffset++) & 0xFF);
        }
        return value;
    }

    boolean verify(ByteSequence module, ByteSequence name, ImageStringsReader strings) {
        Objects.requireNonNull(module);
        Objects.requireNonNull(name);
        return ImageLocation.verifyName(module, name, 0, name.length(), (int)this.attributes[1], (int)this.attributes[2], (int)this.attributes[3], (int)this.attributes[4], strings);
    }

    private static boolean verifyName(ByteSequence module, ByteSequence name, int index, int length, int moduleOffset, int parentOffset, int baseOffset, int extOffset, ImageStringsReader strings) {
        int baseLen;
        int currentIndex = index;
        if (moduleOffset != 0 && strings.match(moduleOffset, module, 0) != module.length()) {
            return false;
        }
        if (parentOffset != 0) {
            int parentLen = strings.match(parentOffset, name, currentIndex);
            if (parentLen < 0) {
                return false;
            }
            if ((currentIndex += parentLen) >= length || name.unsignedByteAt(currentIndex++) != 47) {
                return false;
            }
        }
        if ((baseLen = strings.match(baseOffset, name, currentIndex)) < 0) {
            return false;
        }
        currentIndex += baseLen;
        if (extOffset != 0) {
            if (currentIndex >= length || name.unsignedByteAt(currentIndex++) != 46) {
                return false;
            }
            int extLen = strings.match(extOffset, name, currentIndex);
            if (extLen < 0) {
                return false;
            }
            currentIndex += extLen;
        }
        return length == currentIndex;
    }

    long getAttribute(int kind) {
        if (kind < 0 || kind >= 8) {
            throw new InternalError("Invalid jimage attribute kind: " + kind);
        }
        return this.attributes[kind];
    }

    public long getContentOffset() {
        return this.getAttribute(5);
    }

    public long getCompressedSize() {
        return this.getAttribute(6);
    }

    public long getUncompressedSize() {
        return this.getAttribute(7);
    }
}

