/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage;

import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.ModifiedUtf8;
import com.oracle.truffle.espresso.classfile.descriptors.Validation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ImageStringsReader {
    public static final int HASH_MULTIPLIER = 16777619;
    public static final int POSITIVE_MASK = Integer.MAX_VALUE;
    private final ByteBuffer strings;

    ImageStringsReader(ByteBuffer strings) {
        this.strings = Objects.requireNonNull(strings);
    }

    public int match(int offset, ByteSequence string, int stringOffset) {
        if (offset < 0 || offset >= this.strings.limit()) {
            throw new IndexOutOfBoundsException(String.format("offset out of bounds: %d not in [0, %d[", offset, this.strings.limit()));
        }
        return ImageStringsReader.stringFromByteBufferMatches(this.strings, offset, string, stringOffset);
    }

    public static int hashCode(ByteSequence s) {
        return ImageStringsReader.hashCode(s, 16777619);
    }

    public static int hashCode(ByteSequence s, int seed) {
        return ImageStringsReader.unmaskedHashCode(s, seed) & Integer.MAX_VALUE;
    }

    public static int hashCode(ByteSequence module, ByteSequence name) {
        return ImageStringsReader.hashCode(module, name, 16777619);
    }

    public static int hashCode(ByteSequence module, ByteSequence name, int seed) {
        int value = seed;
        value = value * 16777619 ^ 0x2F;
        value = ImageStringsReader.unmaskedHashCode(module, value);
        value = value * 16777619 ^ 0x2F;
        value = ImageStringsReader.unmaskedHashCode(name, value);
        return value & Integer.MAX_VALUE;
    }

    public static int unmaskedHashCode(ByteSequence s, int seed) {
        assert (Validation.validModifiedUTF8(s));
        int value = seed;
        for (int i = 0; i < s.length(); ++i) {
            value = value * 16777619 ^ s.byteAt(i) & 0xFF;
        }
        return value;
    }

    static ByteBuffer rawStringFromByteBuffer(ByteBuffer buffer, int startOffset) {
        int limit = buffer.limit();
        int currentOffset = startOffset;
        while (currentOffset < limit) {
            byte ch;
            if ((ch = buffer.get(currentOffset++)) != 0) continue;
            --currentOffset;
            break;
        }
        ByteBuffer stringBuffer = buffer.duplicate();
        stringBuffer.position(startOffset);
        stringBuffer.limit(currentOffset);
        return stringBuffer;
    }

    static String stringFromByteBuffer(ByteBuffer buffer, int startOffset) {
        ByteBuffer raw = ImageStringsReader.rawStringFromByteBuffer(buffer, startOffset);
        try {
            return ModifiedUtf8.toJavaString(raw);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    static int stringFromByteBufferMatches(ByteBuffer buffer, int offset, ByteSequence string, int stringOffset) {
        int limit = buffer.limit();
        int stringCurrent = stringOffset;
        int slen = string.length();
        for (int current = offset; current < limit; ++current) {
            byte ch = buffer.get(current);
            if (ch == 0) {
                return current - offset;
            }
            if (stringCurrent >= slen || string.byteAt(stringCurrent) != ch) break;
            ++stringCurrent;
        }
        return -1;
    }
}

