/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.panama.ArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;

public abstract class AbstractArgumentsCalculator
implements ArgumentsCalculator {
    protected final Platform platform;
    protected final VMStorage[] callIntRegs;
    protected final VMStorage[] callFloatRegs;
    protected final VMStorage intReturn;
    protected final VMStorage floatReturn;

    protected AbstractArgumentsCalculator(Platform platform, VMStorage[] callIntRegs, VMStorage[] callFloatRegs, VMStorage intReturn, VMStorage floatReturn) {
        this.platform = platform;
        this.callIntRegs = callIntRegs;
        this.callFloatRegs = callFloatRegs;
        this.intReturn = intReturn;
        this.floatReturn = floatReturn;
    }

    protected static boolean isInt(Klass type) {
        return switch (type.getJavaKind()) {
            default -> throw new IncompatibleClassChangeError();
            case JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long -> true;
            case JavaKind.Float, JavaKind.Double -> false;
            case JavaKind.Void, JavaKind.Illegal, JavaKind.Object, JavaKind.ReturnAddress -> throw EspressoError.shouldNotReachHere(type.getJavaKind().toString());
        };
    }

    protected static boolean isFloat(Klass type) {
        return switch (type.getJavaKind()) {
            default -> throw new IncompatibleClassChangeError();
            case JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long -> false;
            case JavaKind.Float, JavaKind.Double -> true;
            case JavaKind.Void, JavaKind.Illegal, JavaKind.Object, JavaKind.ReturnAddress -> throw EspressoError.shouldNotReachHere(type.getJavaKind().toString());
        };
    }
}

