/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.SignatureCallNode;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.panama.DowncallStubs;

public class DowncallStubNode
extends Node {
    private final DowncallStubs.DowncallStub downcallStub;
    @Node.Child
    SignatureCallNode signatureCall;
    @Node.Child
    InteropLibrary interop;

    protected DowncallStubNode(DowncallStubs.DowncallStub downcallStub, SignatureCallNode signatureCall) {
        this.downcallStub = downcallStub;
        this.signatureCall = signatureCall;
        if (downcallStub.hasCapture()) {
            this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(2);
        }
    }

    public static DowncallStubNode create(DowncallStubs.DowncallStub stub, NativeAccess access) {
        return new DowncallStubNode(stub, access.createSignatureCall(stub.signature));
    }

    public Object call(Object[] args) {
        EspressoContext context = EspressoContext.get(this);
        TruffleObject target = this.downcallStub.getTarget(args, context);
        try {
            Object result = this.signatureCall.call(target, this.downcallStub.processArgs(args));
            if (this.downcallStub.hasCapture()) {
                this.downcallStub.captureState(args, this.interop, context);
            }
            return result;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }
}

