/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.StorageType;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public record VMStorage(byte type, short segmentMaskOrSize, int indexOrOffset) {
    public StorageType type(Platform platform) {
        return platform.getStorageType(this.type());
    }

    public StubLocation getStubLocation(Platform platform) {
        assert (this.type(platform).isPlaceholder());
        return StubLocation.get(this.indexOrOffset);
    }

    public NativeType asNativeType(Platform platform, Klass klass) {
        return this.type(platform).asNativeType(this.segmentMaskOrSize, klass);
    }

    public static VMStorage fromGuest(StaticObject guestVmStorage, Meta meta) {
        return new VMStorage(meta.jdk_internal_foreign_abi_VMStorage_type.getByte(guestVmStorage), meta.jdk_internal_foreign_abi_VMStorage_segmentMaskOrSize.getShort(guestVmStorage), meta.jdk_internal_foreign_abi_VMStorage_indexOrOffset.getInt(guestVmStorage));
    }

    public static VMStorage[] fromGuestArray(StaticObject guestVmStorageArray, Meta meta) {
        EspressoLanguage language = meta.getLanguage();
        int length = guestVmStorageArray.length(language);
        VMStorage[] result = new VMStorage[length];
        for (int i = 0; i < length; ++i) {
            StaticObject guestVmStorage = (StaticObject)guestVmStorageArray.get(language, i);
            result[i] = VMStorage.fromGuest(guestVmStorage, meta);
        }
        return result;
    }

    public static enum StubLocation {
        TARGET_ADDRESS,
        RETURN_BUFFER,
        CAPTURED_STATE_BUFFER;


        public static StubLocation get(int id) {
            return switch (id) {
                case 0 -> TARGET_ADDRESS;
                case 1 -> RETURN_BUFFER;
                case 2 -> CAPTURED_STATE_BUFFER;
                default -> throw EspressoError.unimplemented("Unknown id: " + id);
            };
        }
    }
}

