/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama.x64;

import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.StorageType;
import com.oracle.truffle.espresso.runtime.panama.x64.X64Regs;
import com.oracle.truffle.espresso.runtime.panama.x64.X64StorageType;

public abstract class X64Platform
extends Platform {
    @Override
    public StorageType getStorageType(byte id) {
        return X64StorageType.get(id);
    }

    @Override
    protected String getIntegerRegisterName(int idx, int maskOrSize) {
        if (maskOrSize == 15) {
            return X64Regs.getIntegerRegisterName(idx);
        }
        return "?INT_REG?[" + idx + ", " + maskOrSize + "]";
    }

    @Override
    protected String getVectorRegisterName(int idx, int maskOrSize) {
        if (maskOrSize == 1) {
            return X64Regs.getVectorRegisterName(idx);
        }
        return "?VEC_REG?[" + idx + ", " + maskOrSize + "]";
    }
}

