/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.jni.NativeEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;

public abstract class CallableFromNative
extends SubstitutionProfiler {
    public static boolean validParameterCount(Factory factory, Method.MethodVersion methodVersion) {
        return factory.parameterCount() == methodVersion.getMethod().getParameterCount() + 1;
    }

    public abstract String generatedBy();

    public abstract Object invoke(NativeEnv var1, Object[] var2);

    public Object invokeDirect(Object env, Object[] args) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Native method should not be reachable for java substitution");
    }

    public static abstract class Factory {
        private final String methodName;
        private final NativeSignature nativeSignature;
        private final int parameterCount;
        private final boolean prependEnv;

        public abstract CallableFromNative create();

        protected Factory(String methodName, NativeSignature nativeSignature, int parameterCount, boolean prependEnv) {
            this.methodName = methodName;
            this.nativeSignature = nativeSignature;
            this.parameterCount = parameterCount;
            this.prependEnv = prependEnv;
        }

        public String methodName() {
            return this.methodName;
        }

        public NativeSignature jniNativeSignature() {
            return this.nativeSignature;
        }

        public int parameterCount() {
            return this.parameterCount;
        }

        public NativeType returnType() {
            return this.nativeSignature.getReturnType();
        }

        public boolean prependEnv() {
            return this.prependEnv;
        }
    }
}

