/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.ArrayList;
import java.util.function.Function;

public final class ModuleExtension {
    private static final ModuleExtension[] ESPRESSO_EXTENSION_MODULES = new ModuleExtension[]{new ModuleExtension("org.graalvm.continuations", "continuations.jar", context -> context.getEspressoEnv().Continuum), new ModuleExtension("espresso.hotswap", "hotswap.jar", context -> context.getEspressoEnv().JDWPOptions != null), new ModuleExtension("espresso.polyglot", "espresso-polyglot.jar", context -> context.getEspressoEnv().Polyglot)};
    private static final ModuleExtension[] EMPTY_MODULE_EXTENSION_ARRAY = new ModuleExtension[0];
    private final String moduleName;
    private final String jarName;
    private final Function<EspressoContext, Boolean> isEnabled;
    private final boolean platform;

    private ModuleExtension(String moduleName, String jarName, Function<EspressoContext, Boolean> isEnabled) {
        this(moduleName, jarName, isEnabled, false);
    }

    private ModuleExtension(String moduleName, String jarName, Function<EspressoContext, Boolean> isEnabled, boolean platform) {
        this.moduleName = moduleName;
        this.jarName = jarName;
        this.isEnabled = isEnabled;
        this.platform = platform;
    }

    public static ModuleExtension[] getAllExtensions(EspressoContext context) {
        return ModuleExtension.getExtensions(null, context);
    }

    public static ModuleExtension[] getBootExtensions(EspressoContext context) {
        return ModuleExtension.getExtensions(false, context);
    }

    public static ModuleExtension[] getPlatformExtensions(EspressoContext context) {
        return ModuleExtension.getExtensions(true, context);
    }

    @CompilerDirectives.TruffleBoundary
    private static ModuleExtension[] getExtensions(Boolean platform, EspressoContext context) {
        ArrayList<ModuleExtension> modules = new ArrayList<ModuleExtension>(ESPRESSO_EXTENSION_MODULES.length);
        for (ModuleExtension me : ESPRESSO_EXTENSION_MODULES) {
            if (!me.isEnabled.apply(context).booleanValue() || platform != null && platform != me.platform) continue;
            modules.add(me);
        }
        return modules.toArray(EMPTY_MODULE_EXTENSION_ARRAY);
    }

    public String moduleName() {
        return this.moduleName;
    }

    public String jarName() {
        return this.jarName;
    }

    public boolean isPlatform() {
        return this.platform;
    }
}

