/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.interop.MethodArgsUtils;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import java.util.Set;

@EspressoSubstitutions
public final class Target_com_oracle_truffle_espresso_polyglot_Polyglot {
    @Substitution(isTrivial=true)
    public static boolean isForeignObject(@JavaType(value=Object.class) StaticObject object) {
        return object.isForeignObject();
    }

    @CompilerDirectives.TruffleBoundary
    private static EspressoException rethrowExceptionAsEspresso(ObjectKlass exceptionKlass, String additionalMessage, Throwable originalException) {
        throw exceptionKlass.getMeta().throwExceptionWithMessage(exceptionKlass, additionalMessage + originalException.getMessage());
    }

    @CompilerDirectives.TruffleBoundary
    private static Source getSource(String languageId, String code) {
        return Source.newBuilder((String)languageId, (CharSequence)code, (String)"(eval)").build();
    }

    @CompilerDirectives.TruffleBoundary
    private static void validateLanguage(String languageId, Meta meta) {
        Set publicLanguages = meta.getContext().getEnv().getPublicLanguages().keySet();
        if (!publicLanguages.contains(languageId)) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "No language for id " + languageId + " found. Supported languages are: " + String.valueOf(publicLanguages));
        }
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject eval(@JavaType(value=String.class) StaticObject language, @JavaType(value=String.class) StaticObject code, @Inject Meta meta) {
        Object evalResult;
        CallTarget callTarget;
        String languageId = meta.toHostString(language);
        Target_com_oracle_truffle_espresso_polyglot_Polyglot.validateLanguage(languageId, meta);
        Source source = Target_com_oracle_truffle_espresso_polyglot_Polyglot.getSource(languageId, meta.toHostString(code));
        try {
            callTarget = meta.getContext().getEnv().parsePublic(source, new String[0]);
        }
        catch (Exception e) {
            throw Target_com_oracle_truffle_espresso_polyglot_Polyglot.rethrowExceptionAsEspresso(meta.java_lang_IllegalArgumentException, "Error when parsing the source: ", e);
        }
        try {
            evalResult = callTarget.call(new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof AbstractTruffleException) {
                throw Target_com_oracle_truffle_espresso_polyglot_Polyglot.rethrowExceptionAsEspresso(meta.java_lang_RuntimeException, "Exception during evaluation: ", e);
            }
            throw e;
        }
        if (evalResult instanceof StaticObject) {
            return (StaticObject)evalResult;
        }
        return Target_com_oracle_truffle_espresso_polyglot_Polyglot.createForeignObject(evalResult, meta, InteropLibrary.getUncached());
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject importObject(@JavaType(value=String.class) StaticObject name, @Inject Meta meta) {
        if (!meta.getContext().getEnv().isPolyglotBindingsAccessAllowed()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_SecurityException, "Polyglot bindings are not accessible for this language. Use --polyglot or allowPolyglotAccess when building the context.");
        }
        Object binding = meta.getContext().getEnv().importSymbol(name.toString());
        if (binding == null) {
            return StaticObject.NULL;
        }
        if (binding instanceof StaticObject) {
            return (StaticObject)binding;
        }
        return Target_com_oracle_truffle_espresso_polyglot_Polyglot.createForeignObject(binding, meta, InteropLibrary.getUncached());
    }

    @Substitution
    public static void exportObject(@JavaType(value=String.class) StaticObject name, @JavaType(value=Object.class) StaticObject value, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (!meta.getContext().getEnv().isPolyglotBindingsAccessAllowed()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_SecurityException, "Polyglot bindings are not accessible for this language. Use --polyglot or allowPolyglotAccess when building the context.");
        }
        String bindingName = meta.toHostString(name);
        if (value.isForeignObject()) {
            meta.getContext().getEnv().exportSymbol(bindingName, value.rawForeignObject(language));
        } else {
            meta.getContext().getEnv().exportSymbol(bindingName, (Object)value);
        }
    }

    private static StaticObject createForeignObject(Object object, Meta meta, InteropLibrary interopLibrary) {
        return StaticObject.createForeign(meta.getLanguage(), meta.java_lang_Object, object, interopLibrary);
    }

    @Substitution
    static abstract class CastWithGenerics
    extends SubstitutionNode {
        CastWithGenerics() {
        }

        static EspressoType getEspressoType(StaticObject targetType, Meta meta) {
            if (StaticObject.isNull(targetType)) {
                throw meta.throwException(meta.java_lang_NullPointerException);
            }
            return (EspressoType)meta.polyglot.HIDDEN_TypeLiteral_internalType.getHiddenObject(targetType);
        }

        static ToReference createToEspressoNode(EspressoType type, Meta meta) {
            return ToReference.createToReference(type, meta);
        }

        protected static InstanceOf createInstanceOf(EspressoType superType) {
            return InstanceOf.create(superType.getRawType(), true);
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/TypeLiteral;") StaticObject var2);

        @Specialization(guards={"getEspressoType(targetType, context.getMeta()) == cachedTargetType"}, limit="2")
        static @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Object.class) StaticObject value, @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/TypeLiteral;") StaticObject targetType, @Bind Node node, @Bind(value="get(node)") EspressoContext context, @Cached InlinedBranchProfile nullTargetClassProfile, @Cached InlinedBranchProfile reWrappingProfile, @Cached InlinedBranchProfile errorProfile, @Cached(value="getEspressoType(targetType, context.getMeta())") EspressoType cachedTargetType, @Cached(value="createInstanceOf(cachedTargetType.getRawType())") InstanceOf instanceOfTarget, @Cached(value="createToEspressoNode(cachedTargetType, context.getMeta())") ToReference toEspressoNode) {
            Meta meta = context.getMeta();
            if (StaticObject.isNull(targetType)) {
                nullTargetClassProfile.enter(node);
                throw meta.throwException(meta.java_lang_NullPointerException);
            }
            if (StaticObject.isNull(value) || !value.isForeignObject() && instanceOfTarget.execute(value.getKlass())) {
                return value;
            }
            reWrappingProfile.enter(node);
            try {
                if (value.isForeignObject()) {
                    return toEspressoNode.execute(value.rawForeignObject(EspressoLanguage.get(node)));
                }
                errorProfile.enter(node);
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "%s cannot be cast to %s", value, targetType);
            }
            catch (UnsupportedTypeException e) {
                if (value.isForeignObject() && cachedTargetType.getRawType().isAbstract() && !cachedTargetType.getRawType().isArray() && instanceOfTarget.execute(value.getKlass())) {
                    return value;
                }
                errorProfile.enter(node);
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "%s cannot be cast to %s", value, targetType);
            }
        }

        @Specialization(replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        static @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Object.class) StaticObject value, @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/TypeLiteral;") StaticObject targetType, @Bind Node node, @Cached InstanceOf.Dynamic instanceOfDynamic, @Cached ToReference.DynamicToReference toEspressoNode) {
            Meta meta = EspressoContext.get(node).getMeta();
            if (StaticObject.isNull(targetType)) {
                throw meta.throwException(meta.java_lang_NullPointerException);
            }
            if (StaticObject.isNull(value)) {
                return value;
            }
            EspressoType type = CastWithGenerics.getEspressoType(targetType, meta);
            if (value.isForeignObject()) {
                try {
                    return toEspressoNode.execute(value.rawForeignObject(EspressoLanguage.get(node)), type);
                }
                catch (UnsupportedTypeException e) {
                    if (value.isForeignObject() && type.getRawType().isAbstract() && !type.getRawType().isArray() && instanceOfDynamic.execute(value.getKlass(), type.getRawType())) {
                        return value;
                    }
                    throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "%s cannot be cast to %s", value, type);
                }
            }
            if (instanceOfDynamic.execute(value.getKlass(), type.getRawType())) {
                return value;
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "%s cannot be cast to %s", value, type);
        }
    }

    @Substitution
    static abstract class Cast
    extends SubstitutionNode {
        Cast() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Class.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        protected static InstanceOf createInstanceOf(Klass superType) {
            return InstanceOf.create(superType, true);
        }

        static ToReference createToEspressoNode(EspressoType type, Meta meta) {
            Klass klass = type.getRawType();
            if (klass instanceof PrimitiveKlass) {
                PrimitiveKlass primitiveKlass = (PrimitiveKlass)klass;
                Klass boxedKlass = MethodArgsUtils.primitiveTypeToBoxedType(primitiveKlass);
                assert (boxedKlass != null);
                return ToReference.createToReference(boxedKlass, meta);
            }
            return ToReference.createToReference(type, meta);
        }

        @Specialization(guards={"targetClass.getMirrorKlass() == cachedTargetKlass"}, limit="2")
        static @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Class.class) StaticObject targetClass, @JavaType(value=Object.class) StaticObject value, @Bind Node node, @Cached(value="targetClass.getMirrorKlass()") Klass cachedTargetKlass, @Cached InlinedBranchProfile nullTargetClassProfile, @Cached InlinedBranchProfile reWrappingProfile, @Cached InlinedBranchProfile errorProfile, @Bind(value="getMeta()") Meta meta, @Cached(value="createInstanceOf(cachedTargetKlass)") InstanceOf instanceOfTarget, @Cached(value="createToEspressoNode(cachedTargetKlass, meta)") ToReference toEspresso) {
            if (StaticObject.isNull(targetClass)) {
                nullTargetClassProfile.enter(node);
                throw meta.throwException(meta.java_lang_NullPointerException);
            }
            if (StaticObject.isNull(value) || instanceOfTarget.execute(value.getKlass())) {
                return value;
            }
            reWrappingProfile.enter(node);
            try {
                StaticObject interopObject = value.isForeignObject() ? value.rawForeignObject(EspressoLanguage.get(node)) : value;
                return toEspresso.execute(interopObject);
            }
            catch (UnsupportedTypeException e) {
                errorProfile.enter(node);
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "%s cannot be cast to %s", value, targetClass.getMirrorKlass(meta).getTypeAsString());
            }
        }

        @Specialization(replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        static @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Class.class) StaticObject targetClass, @JavaType(value=Object.class) StaticObject value, @Bind Node node, @Cached InstanceOf.Dynamic instanceOfDynamic, @Cached ToReference.DynamicToReference toEspresso) {
            Meta meta = EspressoContext.get(node).getMeta();
            if (StaticObject.isNull(targetClass)) {
                throw meta.throwException(meta.java_lang_NullPointerException);
            }
            if (StaticObject.isNull(value) || instanceOfDynamic.execute(value.getKlass(), targetClass.getMirrorKlass(meta))) {
                return value;
            }
            Klass mirrorKlass = targetClass.getMirrorKlass(meta);
            try {
                if (mirrorKlass instanceof PrimitiveKlass) {
                    PrimitiveKlass primitiveKlass = (PrimitiveKlass)mirrorKlass;
                    mirrorKlass = MethodArgsUtils.primitiveTypeToBoxedType(primitiveKlass);
                    assert (mirrorKlass != null);
                }
                StaticObject interopObject = value.isForeignObject() ? value.rawForeignObject(EspressoLanguage.get(node)) : value;
                return toEspresso.execute(interopObject, mirrorKlass);
            }
            catch (UnsupportedTypeException e) {
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "%s cannot be cast to %s", value, targetClass.getMirrorKlass(meta).getTypeAsString());
            }
        }
    }
}

