/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.EspressoType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.generics.reflectiveObjects.ParameterizedTypeImpl;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.GetTypeLiteralNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import java.lang.reflect.Type;

@EspressoSubstitutions
public final class Target_com_oracle_truffle_espresso_polyglot_TypeLiteral {

    @Substitution(hasReceiver=true)
    static abstract class ExtractLiteralType
    extends SubstitutionNode {
        static final int LIMIT = 2;

        ExtractLiteralType() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, @JavaType(value=Type.class) StaticObject var2);

        @Specialization
        void doCached(@JavaType(value=Object.class) StaticObject receiver, @JavaType(value=Type.class) StaticObject type, @Bind(value="getContext()") EspressoContext context) {
            assert (type != null);
            context.getMeta().polyglot.HIDDEN_TypeLiteral_internalType.setHiddenObject(receiver, this.extractEspressoType(type, context));
        }

        private EspressoType extractEspressoType(StaticObject type, EspressoContext context) {
            Meta meta = context.getMeta();
            if (meta.java_lang_reflect_ParameterizedType.isAssignableFrom(type.getKlass())) {
                Klass rawType = ExtractLiteralType.rawType(type);
                if (!meta.getContext().isGenericTypeHintsEnabled()) {
                    return rawType;
                }
                EspressoType[] typeArguments = this.typeArguments(type, context);
                return ParameterizedTypeImpl.make(rawType, typeArguments, null);
            }
            if (type.isMirrorKlass()) {
                return type.getMirrorKlass();
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "unsupported type passed");
        }

        private static Klass rawType(StaticObject type) {
            Method method = type.getKlass().lookupDeclaredMethod(Symbol.Name.getRawType, Symbol.Signature.Class, Klass.LookupMode.INSTANCE_ONLY);
            assert (method != null);
            StaticObject rawGuestClass = (StaticObject)method.invokeDirectVirtual(type);
            return rawGuestClass.getMirrorKlass();
        }

        private EspressoType[] typeArguments(StaticObject type, EspressoContext context) {
            Method method = type.getKlass().lookupDeclaredMethod(Symbol.Name.getActualTypeArguments, Symbol.Signature.Type_array, Klass.LookupMode.INSTANCE_ONLY);
            assert (method != null);
            StaticObject typesArray = (StaticObject)method.invokeDirectVirtual(type);
            StaticObject[] types = (StaticObject[])typesArray.unwrap(context.getLanguage());
            EspressoType[] result = new EspressoType[types.length];
            for (int i = 0; i < types.length; ++i) {
                result[i] = this.extractEspressoType(types[i], context);
            }
            return result;
        }
    }

    @Substitution
    public static abstract class GetReifiedType
    extends SubstitutionNode {
        abstract @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/TypeLiteral;") StaticObject execute(@JavaType(value=Object.class) StaticObject var1, int var2);

        @Specialization
        static @JavaType(internalName="Lcom/oracle/truffle/espresso/polyglot/TypeLiteral;") StaticObject doCached(@JavaType(value=Object.class) StaticObject foreignObject, int typeArgumentIndex, @Bind Node node, @Cached GetTypeLiteralNode getTypeLiteralNode, @Cached InlinedBranchProfile notValidForeign, @Cached InlinedBranchProfile invalidIndex) {
            EspressoContext context = EspressoContext.get(node);
            if (StaticObject.isNull(foreignObject)) {
                notValidForeign.enter(node);
                throw context.getMeta().throwNullPointerException();
            }
            if (!foreignObject.isForeignObject()) {
                notValidForeign.enter(node);
                throw context.getMeta().throwExceptionWithMessage(context.getMeta().java_lang_IllegalArgumentException, "Called getReifiedType on a non-foreign object");
            }
            EspressoType[] typeArguments = foreignObject.getTypeArguments(context.getLanguage());
            if (typeArguments == null) {
                return StaticObject.NULL;
            }
            if (0 > typeArgumentIndex || typeArgumentIndex >= typeArguments.length) {
                invalidIndex.enter(node);
                throw context.getMeta().throwExceptionWithMessage(context.getMeta().java_lang_IllegalArgumentException, "invalid index %d for type literal in foreign object with %d type arguments", typeArgumentIndex, typeArguments.length);
            }
            if (!context.isGenericTypeHintsEnabled()) {
                return getTypeLiteralNode.genericObjectTypeLiteral(context);
            }
            EspressoType type = typeArguments[typeArgumentIndex];
            return getTypeLiteralNode.execute(type);
        }
    }
}

