/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.descriptors.ByteSequence;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.resolver.CallSiteType;
import com.oracle.truffle.espresso.resolver.LinkResolver;
import com.oracle.truffle.espresso.resolver.ResolvedCall;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.MethodHandleIntrinsics;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.Pair;

@EspressoSubstitutions
public final class Target_java_lang_invoke_MethodHandleNatives {
    @Substitution
    public static void init(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Object.class) StaticObject ref, @Inject Meta meta, @Inject EspressoLanguage language) {
        Klass targetKlass = ref.getKlass();
        if (targetKlass.getType() == Symbol.Type.java_lang_reflect_Method) {
            Method target = Method.getHostReflectiveMethodRoot(ref, meta);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedMethod(self, target, target.getRefKind(), meta);
        } else if (targetKlass.getType() == Symbol.Type.java_lang_reflect_Field) {
            Field field = Field.getReflectiveFieldRoot(ref, meta);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedField(self, field, Target_java_lang_invoke_MethodHandleNatives.getRefKind(meta.java_lang_invoke_MemberName_flags.getInt(self)), meta, language);
        } else if (targetKlass.getType() == Symbol.Type.java_lang_reflect_Constructor) {
            Method target = Method.getHostReflectiveConstructorRoot(ref, meta);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedMethod(self, target, target.getRefKind(), meta);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("invalid argument for MemberName.init: " + String.valueOf(ref.getKlass()));
        }
    }

    @Substitution
    public static void expand(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta, @Inject EspressoLanguage language, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(self)) {
            profiler.profile(0);
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "MemberName is null");
        }
        boolean haveClazz = !StaticObject.isNull(meta.java_lang_invoke_MemberName_clazz.getObject(self));
        boolean haveName = !StaticObject.isNull(meta.java_lang_invoke_MemberName_name.getObject(self));
        boolean haveType = !StaticObject.isNull(meta.java_lang_invoke_MemberName_type.getObject(self));
        int flags = meta.java_lang_invoke_MemberName_flags.getInt(self);
        switch (flags & 0xF0000) {
            case 65536: 
            case 131072: {
                Method m = (Method)meta.HIDDEN_VMTARGET.getHiddenObject(self);
                if (m == null) {
                    profiler.profile(2);
                    throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Nothing to expand");
                }
                if (!haveClazz) {
                    meta.java_lang_invoke_MemberName_clazz.setObject(self, m.getDeclaringKlass().mirror());
                }
                if (!haveName) {
                    meta.java_lang_invoke_MemberName_name.setObject(self, meta.toGuestString(m.getName()));
                }
                if (haveType) break;
                meta.java_lang_invoke_MemberName_type.setObject(self, meta.toGuestString(m.getRawSignature()));
                break;
            }
            case 262144: {
                Field f;
                StaticObject clazz = meta.java_lang_invoke_MemberName_clazz.getObject(self);
                if (StaticObject.isNull(clazz)) {
                    profiler.profile(3);
                    throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Nothing to expand");
                }
                Klass holder = clazz.getMirrorKlass(meta);
                int slot = Target_sun_misc_Unsafe.guestOffsetToSlot((Long)meta.HIDDEN_VMINDEX.getHiddenObject(self), language);
                boolean isStatic = (flags & 8) != 0;
                try {
                    f = isStatic ? holder.lookupStaticFieldTable(slot) : holder.lookupFieldTable(slot);
                }
                catch (IndexOutOfBoundsException e) {
                    f = null;
                }
                if (f == null) {
                    profiler.profile(4);
                    throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Nothing to expand");
                }
                if (!haveName) {
                    meta.java_lang_invoke_MemberName_name.setObject(self, meta.toGuestString(f.getName()));
                }
                if (haveType) break;
                if (Types.isPrimitive(f.getType())) {
                    Klass k = meta.resolvePrimitive(f.getType());
                    meta.java_lang_invoke_MemberName_type.setObject(self, k.mirror());
                    break;
                }
                meta.java_lang_invoke_MemberName_type.setObject(self, meta.toGuestString(f.getType()));
                break;
            }
            default: {
                profiler.profile(1);
                throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "MemberName is null");
            }
        }
    }

    @Substitution
    public static int getNamedCon(int which, @JavaType(value=Object[].class) StaticObject name, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (name.getKlass() == meta.java_lang_Object_array && name.length(language) > 0 && which < Constants.CONSTANTS.size()) {
            if (which >= Constants.CONSTANTS_BEFORE_16 && !meta.getJavaVersion().java16OrLater()) {
                return 0;
            }
            Pair<String, Integer> pair = Constants.CONSTANTS.get(which);
            meta.getInterpreterToVM().setArrayObject(language, meta.toGuestString((String)pair.getLeft()), 0, name);
            return (Integer)pair.getRight();
        }
        return 0;
    }

    @Substitution
    public static void setCallSiteTargetNormal(@JavaType(value=CallSite.class) StaticObject site, @JavaType(value=MethodHandle.class) StaticObject target, @Inject Meta meta) {
        meta.java_lang_invoke_CallSite_target.setObject(site, target);
    }

    @Substitution
    public static void setCallSiteTargetVolatile(@JavaType(value=CallSite.class) StaticObject site, @JavaType(value=MethodHandle.class) StaticObject target, @Inject Meta meta) {
        meta.java_lang_invoke_CallSite_target.setObject(site, target, true);
    }

    @Substitution
    public static int getMembers(@JavaType(value=Class.class) StaticObject defc, @JavaType(value=String.class) StaticObject matchName, @JavaType(value=String.class) StaticObject matchSig, int matchFlags, @JavaType(value=Class.class) StaticObject originalCaller, int skip, @JavaType(internalName="[Ljava/lang/invoke/MemberName;") StaticObject resultsArr, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (StaticObject.isNull(defc) || StaticObject.isNull(resultsArr)) {
            return -1;
        }
        EspressoContext context = meta.getContext();
        StaticObject[] results = (StaticObject[])resultsArr.unwrap(language);
        Symbol<Symbol.Name> name = null;
        if (!StaticObject.isNull(matchName) && (name = context.getNames().lookup(meta.toHostString(matchName))) == null) {
            return 0;
        }
        String sig = meta.toHostString(matchSig);
        if (sig == null) {
            return 0;
        }
        Klass caller = null;
        if (!StaticObject.isNull(originalCaller) && (caller = originalCaller.getMirrorKlass(meta)) == null) {
            return -1;
        }
        return Target_java_lang_invoke_MethodHandleNatives.findMemberNames(defc.getMirrorKlass(meta), name, sig, matchFlags, caller, skip, results);
    }

    private static int findMemberNames(Klass klass, Symbol<Symbol.Name> name, String sig, int matchFlags, Klass caller, int skip, StaticObject[] results) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.unimplemented();
    }

    @Substitution
    public static void registerNatives() {
    }

    @Substitution
    public static int getConstant(int which) {
        switch (which) {
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Substitution
    public static long objectFieldOffset(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        return (Long)meta.HIDDEN_VMINDEX.getHiddenObject(self);
    }

    @Substitution
    public static long staticFieldOffset(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        return (Long)meta.HIDDEN_VMINDEX.getHiddenObject(self);
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject staticFieldBase(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        return meta.java_lang_invoke_MemberName_clazz.getObject(self).getMirrorKlass(meta).getStatics();
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject getMemberVMInfo(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @Inject Meta meta) {
        Object vmtarget = meta.HIDDEN_VMTARGET.getHiddenObject(self);
        Object vmindex = meta.HIDDEN_VMINDEX.getHiddenObject(self);
        StaticObject[] result = new StaticObject[]{vmindex == null ? meta.boxLong(-2000000L) : meta.boxLong((Long)vmindex), vmtarget == null ? StaticObject.NULL : (vmtarget instanceof Klass ? ((Klass)vmtarget).mirror() : self)};
        return StaticObject.createArray(meta.java_lang_Object_array, result, meta.getContext());
    }

    @Substitution
    public static @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject resolve(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Class.class) StaticObject caller, @Inject Meta meta) {
        return Target_java_lang_invoke_MethodHandleNatives.resolve(self, caller, false, meta);
    }

    @Substitution
    public static @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject resolve(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Class.class) StaticObject caller, boolean speculativeResolve, @Inject Meta meta) {
        try {
            return Target_java_lang_invoke_MethodHandleNatives.resolve(self, caller, 32, meta);
        }
        catch (EspressoException e) {
            if (speculativeResolve) {
                return StaticObject.NULL;
            }
            throw e;
        }
    }

    @Substitution(methodName="resolve")
    public static @JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject resolve(@JavaType(internalName="Ljava/lang/invoke/MemberName;") StaticObject self, @JavaType(value=Class.class) StaticObject caller, int lookupMode, boolean speculativeResolve, @Inject Meta meta) {
        try {
            return Target_java_lang_invoke_MethodHandleNatives.resolve(self, caller, lookupMode, meta);
        }
        catch (EspressoException e) {
            EspressoException error = e;
            int refKind = Target_java_lang_invoke_MethodHandleNatives.getRefKind(meta.java_lang_invoke_MemberName_flags.getInt(self));
            if (!Target_java_lang_invoke_MethodHandleNatives.isValidRefKind(refKind)) {
                throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "obsolete MemberName format");
            }
            if (!speculativeResolve) {
                throw error;
            }
            return StaticObject.NULL;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static StaticObject resolve(StaticObject memberName, @JavaType(value=Class.class) StaticObject caller, int lookupMode, Meta meta) {
        if (StaticObject.isNull(memberName)) {
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Member Name is null.");
        }
        if (meta.HIDDEN_VMTARGET.getHiddenObject(memberName) != null) {
            return memberName;
        }
        StaticObject clazz = meta.java_lang_invoke_MemberName_clazz.getObject(memberName);
        StaticObject type = meta.java_lang_invoke_MemberName_type.getObject(memberName);
        StaticObject guestName = meta.java_lang_invoke_MemberName_name.getObject(memberName);
        if (StaticObject.isNull(guestName) || StaticObject.isNull(type) || StaticObject.isNull(clazz)) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Nothing to resolve.");
        }
        Klass resolutionKlass = clazz.getMirrorKlass(meta);
        int flags = meta.java_lang_invoke_MemberName_flags.getInt(memberName);
        if (Integer.bitCount(flags & 0xF0000) != 1) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Invalid MemberName flag format.");
        }
        ByteSequence desc = Target_java_lang_invoke_MethodHandleNatives.asSignature(type, meta);
        Symbol<Symbol.Name> name = Target_java_lang_invoke_MethodHandleNatives.lookupName(meta, meta.toHostString(guestName), Constants.flagHas(flags, 262144) ? meta.java_lang_NoSuchFieldException : meta.java_lang_NoSuchMethodException);
        ObjectKlass callerKlass = StaticObject.isNull(caller) ? null : (ObjectKlass)caller.getMirrorKlass(meta);
        boolean doAccessChecks = callerKlass != null;
        boolean doConstraintsChecks = callerKlass != null && (lookupMode & 0x20) == 0;
        int refKind = Target_java_lang_invoke_MethodHandleNatives.getRefKind(flags);
        if (Constants.flagHas(flags, 262144)) {
            Symbol<Symbol.Type> t = Target_java_lang_invoke_MethodHandleNatives.lookupType(meta, desc);
            Field f = LinkResolver.resolveFieldSymbol(meta, callerKlass, name, t, resolutionKlass, false, doConstraintsChecks);
            Target_java_lang_invoke_MethodHandleNatives.plantResolvedField(memberName, f, refKind, meta, meta.getLanguage());
            return memberName;
        }
        if (Constants.flagHas(flags, 131072)) {
            if (name != Symbol.Name._init_) {
                throw meta.throwException(meta.java_lang_LinkageError);
            }
            refKind = 7;
        } else if (!Constants.flagHas(flags, 65536)) {
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "Unrecognized MemberName format");
        }
        MethodHandleIntrinsics.PolySigIntrinsics mhMethodId = Target_java_lang_invoke_MethodHandleNatives.getPolysignatureIntrinsicID(flags, resolutionKlass, refKind, name);
        if (mhMethodId == MethodHandleIntrinsics.PolySigIntrinsics.InvokeGeneric) {
            throw meta.throwException(meta.java_lang_InternalError);
        }
        Symbol<Symbol.Signature> sig = Target_java_lang_invoke_MethodHandleNatives.lookupSignature(meta, desc, mhMethodId);
        Method m = LinkResolver.resolveMethodSymbol(meta, callerKlass, name, sig, resolutionKlass, resolutionKlass.isInterface(), doAccessChecks, doConstraintsChecks);
        ResolvedCall resolvedCall = LinkResolver.resolveCallSite(meta, callerKlass, m, CallSiteType.fromRefKind(refKind), resolutionKlass);
        Target_java_lang_invoke_MethodHandleNatives.plantResolvedMethod(memberName, resolvedCall, meta);
        return memberName;
    }

    private static MethodHandleIntrinsics.PolySigIntrinsics getPolysignatureIntrinsicID(int flags, Klass resolutionKlass, int refKind, Symbol<Symbol.Name> name) {
        MethodHandleIntrinsics.PolySigIntrinsics iid;
        MethodHandleIntrinsics.PolySigIntrinsics mhMethodId = MethodHandleIntrinsics.PolySigIntrinsics.None;
        if (!(!Constants.flagHas(flags, 65536) || resolutionKlass.getType() != Symbol.Type.java_lang_invoke_MethodHandle && resolutionKlass.getType() != Symbol.Type.java_lang_invoke_VarHandle || refKind != 5 && refKind != 7 && refKind != 6 || (iid = MethodHandleIntrinsics.getId(name, resolutionKlass)) == MethodHandleIntrinsics.PolySigIntrinsics.None || refKind == 6 != iid.isStaticPolymorphicSignature())) {
            mhMethodId = iid;
        }
        return mhMethodId;
    }

    @CompilerDirectives.TruffleBoundary
    private static Symbol<Symbol.Name> lookupName(Meta meta, String name, ObjectKlass exceptionKlass) {
        Symbol<Symbol.Name> methodName;
        try {
            methodName = meta.getNames().lookup(name);
        }
        catch (EspressoError e) {
            methodName = null;
        }
        if (methodName == null) {
            throw meta.throwExceptionWithMessage(exceptionKlass, name);
        }
        return methodName;
    }

    @CompilerDirectives.TruffleBoundary
    private static Symbol<Symbol.Type> lookupType(Meta meta, ByteSequence desc) {
        Symbol<Symbol.Type> t = meta.getLanguage().getTypes().lookup(desc);
        if (t == null) {
            throw meta.throwException(meta.java_lang_NoSuchFieldException);
        }
        return t;
    }

    @CompilerDirectives.TruffleBoundary
    private static Symbol<Symbol.Signature> lookupSignature(Meta meta, ByteSequence desc, MethodHandleIntrinsics.PolySigIntrinsics iid) {
        Symbol<Symbol.Signature> signature = iid != MethodHandleIntrinsics.PolySigIntrinsics.None ? meta.getSignatures().symbolifyValidSignature(desc) : meta.getSignatures().lookupValidSignature(desc);
        if (signature == null) {
            throw meta.throwException(meta.java_lang_NoSuchMethodException);
        }
        return signature;
    }

    private static ByteSequence asSignature(StaticObject typeObject, Meta meta) {
        Klass typeKlass = typeObject.getKlass();
        if (meta.java_lang_invoke_MethodType.isAssignableFrom(typeKlass)) {
            return Target_java_lang_invoke_MethodHandleNatives.methodTypeAsSignature(typeObject, meta);
        }
        if (meta.java_lang_Class.isAssignableFrom(typeKlass)) {
            return typeObject.getMirrorKlass(meta).getType();
        }
        if (meta.java_lang_String.isAssignableFrom(typeKlass)) {
            return ByteSequence.create(meta.toHostString(typeObject));
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    private static ByteSequence methodTypeAsSignature(StaticObject methodType, Meta meta) {
        StaticObject ptypes = meta.java_lang_invoke_MethodType_ptypes.getObject(methodType);
        StaticObject rtype = meta.java_lang_invoke_MethodType_rtype.getObject(methodType);
        return Method.getSignatureFromGuestDescription(ptypes, rtype, meta);
    }

    private static long refKindToVMIndex(int refKind) {
        switch (refKind) {
            case 6: {
                return -1000000L;
            }
            case 5: {
                return 1000000L;
            }
            case 9: {
                return 2000000L;
            }
            case 7: 
            case 8: {
                return -2000000L;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    public static void plantResolvedMethod(StaticObject memberName, Method target, int refKind, Meta meta) {
        int methodFlags = Target_java_lang_invoke_MethodHandleNatives.getMethodFlags(target, refKind);
        Target_java_lang_invoke_MethodHandleNatives.plant(memberName, target, meta, methodFlags);
    }

    public static void plantResolvedMethod(StaticObject memberName, ResolvedCall resolvedCall, Meta meta) {
        int methodFlags = Target_java_lang_invoke_MethodHandleNatives.getMethodFlags(resolvedCall);
        Target_java_lang_invoke_MethodHandleNatives.plant(memberName, resolvedCall.getResolvedMethod(), meta, methodFlags);
    }

    private static void plant(StaticObject memberName, Method target, Meta meta, int methodFlags) {
        meta.HIDDEN_VMTARGET.setHiddenObject(memberName, target);
        meta.HIDDEN_VMINDEX.setHiddenObject(memberName, Target_java_lang_invoke_MethodHandleNatives.refKindToVMIndex(Target_java_lang_invoke_MethodHandleNatives.getRefKind(methodFlags)));
        meta.java_lang_invoke_MemberName_flags.setInt(memberName, methodFlags);
        meta.java_lang_invoke_MemberName_clazz.setObject(memberName, target.getDeclaringKlass().mirror());
    }

    private static void plantResolvedField(StaticObject memberName, Field field, int refKind, Meta meta, EspressoLanguage language) {
        meta.HIDDEN_VMTARGET.setHiddenObject(memberName, field.getDeclaringKlass());
        meta.HIDDEN_VMINDEX.setHiddenObject(memberName, Target_sun_misc_Unsafe.slotToGuestOffset(field.getSlot(), field.isStatic(), language));
        meta.java_lang_invoke_MemberName_flags.setInt(memberName, Target_java_lang_invoke_MethodHandleNatives.getFieldFlags(refKind, field));
        meta.java_lang_invoke_MemberName_clazz.setObject(memberName, field.getDeclaringKlass().mirror());
    }

    private static int getMethodFlags(ResolvedCall call) {
        int flags = call.getResolvedMethod().getMethodModifiers();
        if (call.getResolvedMethod().isCallerSensitive()) {
            flags |= 0x100000;
        }
        if (call.getResolvedMethod().isConstructor() || call.getResolvedMethod().isClassInitializer()) {
            flags |= 0x20000;
            return flags |= 0x8000000;
        }
        flags |= 0x10000;
        switch (call.getCallKind()) {
            case STATIC: {
                flags |= 0x6000000;
                break;
            }
            case DIRECT: {
                flags |= 0x7000000;
                break;
            }
            case VTABLE_LOOKUP: {
                flags |= 0x5000000;
                break;
            }
            case ITABLE_LOOKUP: {
                flags |= 0x9000000;
            }
        }
        return flags;
    }

    private static int getMethodFlags(Method target, int refKind) {
        int res = target.getMethodModifiers();
        if (refKind == 9) {
            if (target.isPrivate() || target.isFinalFlagSet() || target.getDeclaringKlass().isFinalFlagSet()) {
                res |= 0x7010000;
            } else if (target.getDeclaringKlass().isJavaLangObject()) {
                assert (target.getVTableIndex() >= 0);
                res |= 0x5010000;
            } else {
                assert (target.getITableIndex() >= 0);
                res |= 0x9010000;
            }
        } else if (refKind == 5) {
            if (target.isPrivate() || target.isFinalFlagSet() || target.getDeclaringKlass().isFinalFlagSet()) {
                res |= 0x7010000;
            } else {
                assert (target.getVTableIndex() >= 0);
                res |= 0x5010000;
            }
        } else {
            res = target.isStatic() ? (res |= 0x6010000) : (target.isConstructor() || target.isClassInitializer() ? (res |= 0x7020000) : (res |= 0x7010000));
        }
        if (target.isCallerSensitive()) {
            res |= 0x100000;
        }
        return res;
    }

    private static int getFieldFlags(int refKind, Field fd) {
        int res = fd.getModifiers();
        boolean isSetter = refKind <= 4 && refKind > 2;
        res |= 0x40000 | (fd.isStatic() ? 2 : 1) << 24;
        if (isSetter) {
            res += 0x2000000;
        }
        return res;
    }

    public static int getRefKind(int flags) {
        return flags >> 24 & 0xF;
    }

    public static boolean isValidRefKind(int flags) {
        return flags > 0 && flags < 10;
    }

    @Substitution
    public static void clearCallSiteContext(@JavaType(internalName="Ljava/lang/invoke/MethodHandleNatives$CallSiteContext;") StaticObject context) {
    }

    public static final class Constants {
        static final long NONE_INDEX = -3000000L;
        static final long VIRTUAL_INDEX = 1000000L;
        static final long INTERFACE_INDEX = 2000000L;
        static final long STATIC_INDEX = -1000000L;
        static final long SPECIAL_INDEX = -2000000L;
        public static final int MN_IS_METHOD = 65536;
        public static final int MN_IS_CONSTRUCTOR = 131072;
        public static final int MN_IS_FIELD = 262144;
        public static final int MN_IS_TYPE = 524288;
        public static final int MN_CALLER_SENSITIVE = 0x100000;
        public static final int MN_TRUSTED_FINAL = 0x200000;
        public static final int MN_REFERENCE_KIND_SHIFT = 24;
        public static final int MN_REFERENCE_KIND_MASK = 15;
        public static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        public static final int MN_SEARCH_INTERFACES = 0x200000;
        public static final int NESTMATE_CLASS = 1;
        public static final int HIDDEN_CLASS = 2;
        public static final int STRONG_LOADER_LINK = 4;
        public static final int ACCESS_VM_ANNOTATIONS = 8;
        public static final int LM_MODULE = 16;
        public static final int LM_UNCONDITIONAL = 32;
        public static final int LM_TRUSTED = -1;
        public static final int ALL_KINDS = 983040;
        static final List<Pair<String, Integer>> CONSTANTS = new ArrayList<Pair<String, Integer>>();
        static final int CONSTANTS_BEFORE_16;

        private Constants() {
        }

        public static boolean flagHas(int flags, int status) {
            return (flags & status) != 0;
        }

        static {
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_METHOD", (Object)65536));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_CONSTRUCTOR", (Object)131072));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_FIELD", (Object)262144));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_IS_TYPE", (Object)524288));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_CALLER_SENSITIVE", (Object)0x100000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_TRUSTED_FINAL", (Object)0x200000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_SEARCH_SUPERCLASSES", (Object)0x100000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_SEARCH_INTERFACES", (Object)0x200000));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_REFERENCE_KIND_SHIFT", (Object)24));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"MN_REFERENCE_KIND_MASK", (Object)15));
            CONSTANTS_BEFORE_16 = CONSTANTS.size();
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"NESTMATE_CLASS", (Object)1));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"HIDDEN_CLASS", (Object)2));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"STRONG_LOADER_LINK", (Object)4));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"ACCESS_VM_ANNOTATIONS", (Object)8));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"LM_MODULE", (Object)16));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"LM_UNCONDITIONAL", (Object)32));
            CONSTANTS.add((Pair<String, Integer>)Pair.create((Object)"LM_TRUSTED", (Object)-1));
        }
    }
}

