/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Target_sun_reflect_NativeMethodAccessorImpl;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.lang.reflect.Array;

@EspressoSubstitutions
public final class Target_java_lang_reflect_Array {
    @Substitution
    public static @JavaType(value=Object.class) StaticObject newArray(@JavaType(value=Class.class) StaticObject componentType, int length, @Inject Meta meta) {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)componentType)) {
            return Target_java_lang_reflect_Array.newArrayImpl(componentType, length, meta);
        }
        return Target_java_lang_reflect_Array.newArrayBoundary(componentType, length, meta);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    static StaticObject newArrayBoundary(@JavaType(value=Class.class) StaticObject componentType, int length, @Inject Meta meta) {
        return Target_java_lang_reflect_Array.newArrayImpl(componentType, length, meta);
    }

    static StaticObject newArrayImpl(@JavaType(value=Class.class) StaticObject componentType, int length, @Inject Meta meta) {
        if (StaticObject.isNull(componentType)) {
            throw meta.throwNullPointerException();
        }
        Klass component = componentType.getMirrorKlass(meta);
        if (component == meta._void || Types.getArrayDimensions(component.getType()) >= 255) {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        GuestAllocator.AllocationChecks.checkCanAllocateArray(meta, length);
        if (component.isPrimitive()) {
            return meta.getAllocator().createNewPrimitiveArray(component, length);
        }
        return meta.getAllocator().createNewReferenceArray(component, length);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution
    public static @JavaType(value=Object.class) StaticObject multiNewArray(@JavaType(value=Class.class) StaticObject componentType, @JavaType(value=int[].class) StaticObject dimensionsArray, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (StaticObject.isNull(componentType) || StaticObject.isNull(dimensionsArray)) {
            throw meta.throwNullPointerException();
        }
        Klass component = componentType.getMirrorKlass(meta);
        if (component == meta._void || StaticObject.isNull(dimensionsArray)) {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        int[] dimensions = (int[])dimensionsArray.unwrap(language);
        int finalDimensions = dimensions.length;
        if (component.isArray()) {
            finalDimensions += Types.getArrayDimensions(component.getType());
        }
        if (dimensions.length == 0 || finalDimensions > 255) {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        GuestAllocator.AllocationChecks.checkCanAllocateMultiArray(meta, component, dimensions);
        if (dimensions.length == 1) {
            return meta.getAllocator().createNewMultiArray(component, dimensions);
        }
        return meta.getAllocator().createNewMultiArray(component.getArrayClass(dimensions.length - 1), dimensions);
    }

    @Substitution
    public static boolean getBoolean(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(array)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        Klass arrayKlass = array.getKlass();
        if (arrayKlass != meta._boolean_array) {
            profiler.profile(1);
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                return library.asBoolean(library.readArrayElement(array.rawForeignObject(language), (long)index));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getByte(array.unwrap(language), index) != 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    @Substitution
    public static byte getByte(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                return library.asByte(library.readArrayElement(array.rawForeignObject(language), (long)index));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getByte(array.unwrap(language), index);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    @Substitution
    public static char getChar(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                String str = library.asString(library.readArrayElement(array.rawForeignObject(language), (long)index));
                if (str.isEmpty()) {
                    return '\u0000';
                }
                if (str.length() > 1) {
                    throw meta.throwException(meta.java_lang_IllegalArgumentException);
                }
                return str.charAt(0);
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getChar(array.unwrap(language), index);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    @Substitution
    public static short getShort(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                return library.asShort(library.readArrayElement(array.rawForeignObject(language), (long)index));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getShort(array.unwrap(language), index);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    @Substitution
    public static int getInt(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                return library.asInt(library.readArrayElement(array.rawForeignObject(language), (long)index));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getInt(array.unwrap(language), index);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    @Substitution
    public static float getFloat(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                return library.asFloat(library.readArrayElement(array.rawForeignObject(language), (long)index));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getFloat(array.unwrap(language), index);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    @Substitution
    public static double getDouble(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                return library.asDouble(library.readArrayElement(array.rawForeignObject(language), (long)index));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getDouble(array.unwrap(language), index);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    @Substitution
    public static long getLong(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            try {
                InteropLibrary library = InteropLibrary.getUncached();
                return library.asLong(library.readArrayElement(array.rawForeignObject(language), (long)index));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
            }
        }
        try {
            return Array.getLong(array.unwrap(language), index);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            profiler.profile(5);
            throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
        }
    }

    private static EspressoException rethrowAsGuestException(RuntimeException e, Meta meta, SubstitutionProfiler profiler) {
        assert (e instanceof NullPointerException || e instanceof ArrayIndexOutOfBoundsException || e instanceof IllegalArgumentException);
        if (e instanceof NullPointerException) {
            profiler.profile(2);
            throw meta.throwNullPointerException();
        }
        if (e instanceof ArrayIndexOutOfBoundsException) {
            profiler.profile(3);
            throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, e.getMessage());
        }
        if (e instanceof IllegalArgumentException) {
            profiler.profile(4);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, Target_java_lang_reflect_Array.getMessageBoundary(e));
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere(e);
    }

    @CompilerDirectives.TruffleBoundary
    private static String getMessageBoundary(RuntimeException e) {
        return e.getMessage();
    }

    private static void checkNonNullArray(StaticObject array, Meta meta, SubstitutionProfiler profiler) {
        if (StaticObject.isNull(array)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        if (!array.isArray()) {
            profiler.profile(1);
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
    }

    @Substitution
    public static void setBoolean(@JavaType(value=Object.class) StaticObject array, int index, boolean value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(array)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        Klass arrayKlass = array.getKlass();
        if (arrayKlass != meta._boolean_array) {
            profiler.profile(1);
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, value, meta);
        } else {
            try {
                Array.setByte(array.unwrap(language), index, value ? (byte)1 : 0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    @Substitution
    public static void setByte(@JavaType(value=Object.class) StaticObject array, int index, byte value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, value, meta);
        } else {
            try {
                Array.setByte(array.unwrap(language), index, value);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    @Substitution
    public static void setChar(@JavaType(value=Object.class) StaticObject array, int index, char value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, Character.valueOf(value), meta);
        } else {
            try {
                Array.setChar(array.unwrap(language), index, value);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    @Substitution
    public static void setShort(@JavaType(value=Object.class) StaticObject array, int index, short value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, value, meta);
        } else {
            try {
                Array.setShort(array.unwrap(language), index, value);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    @Substitution
    public static void setInt(@JavaType(value=Object.class) StaticObject array, int index, int value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, value, meta);
        } else {
            try {
                Array.setInt(array.unwrap(language), index, value);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    @Substitution
    public static void setFloat(@JavaType(value=Object.class) StaticObject array, int index, float value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, Float.valueOf(value), meta);
        } else {
            try {
                Array.setFloat(array.unwrap(language), index, value);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    @Substitution
    public static void setDouble(@JavaType(value=Object.class) StaticObject array, int index, double value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, value, meta);
        } else {
            try {
                Array.setDouble(array.unwrap(language), index, value);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    @Substitution
    public static void setLong(@JavaType(value=Object.class) StaticObject array, int index, long value, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        Target_java_lang_reflect_Array.checkNonNullArray(array, meta, profiler);
        if (array.isForeignObject()) {
            Target_java_lang_reflect_Array.writeForeignArrayElement(array, language, index, value, meta);
        } else {
            try {
                Array.setLong(array.unwrap(language), index, value);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                profiler.profile(5);
                throw Target_java_lang_reflect_Array.rethrowAsGuestException(e, meta, profiler);
            }
        }
    }

    private static void writeForeignArrayElement(StaticObject array, EspressoLanguage language, int index, Object value, Meta meta) {
        try {
            InteropLibrary library = InteropLibrary.getUncached();
            library.writeArrayElement(array.rawForeignObject(language), (long)index, value);
        }
        catch (UnsupportedMessageException | UnsupportedTypeException e) {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        catch (InvalidArrayIndexException e) {
            throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
        }
    }

    @Substitution
    public static void set(@JavaType(value=Object.class) StaticObject array, int index, @JavaType(value=Object.class) StaticObject value, @Inject EspressoLanguage language, @Inject Meta meta) {
        InterpreterToVM vm = meta.getInterpreterToVM();
        if (StaticObject.isNull(array)) {
            throw meta.throwNullPointerException();
        }
        if (array.isArray()) {
            Object widenValue = Target_sun_reflect_NativeMethodAccessorImpl.checkAndWiden(meta, value, ((ArrayKlass)array.getKlass()).getComponentType());
            if (array.isForeignObject()) {
                try {
                    InteropLibrary library = InteropLibrary.getUncached();
                    library.writeArrayElement(array.rawForeignObject(language), (long)index, widenValue);
                    return;
                }
                catch (UnsupportedMessageException | UnsupportedTypeException e) {
                    throw meta.throwException(meta.java_lang_IllegalArgumentException);
                }
                catch (InvalidArrayIndexException e) {
                    throw meta.throwException(meta.java_lang_ArrayIndexOutOfBoundsException);
                }
            }
            switch (((ArrayKlass)array.getKlass()).getComponentType().getJavaKind()) {
                case Boolean: {
                    vm.setArrayByte(language, (Boolean)widenValue != false ? (byte)1 : 0, index, array);
                    break;
                }
                case Byte: {
                    vm.setArrayByte(language, (Byte)widenValue, index, array);
                    break;
                }
                case Short: {
                    vm.setArrayShort(language, (Short)widenValue, index, array);
                    break;
                }
                case Char: {
                    vm.setArrayChar(language, ((Character)widenValue).charValue(), index, array);
                    break;
                }
                case Int: {
                    vm.setArrayInt(language, (Integer)widenValue, index, array);
                    break;
                }
                case Float: {
                    vm.setArrayFloat(language, ((Float)widenValue).floatValue(), index, array);
                    break;
                }
                case Long: {
                    vm.setArrayLong(language, (Long)widenValue, index, array);
                    break;
                }
                case Double: {
                    vm.setArrayDouble(language, (Double)widenValue, index, array);
                    break;
                }
                case Object: {
                    vm.setArrayObject(language, value, index, array);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw EspressoError.shouldNotReachHere("invalid array type: " + String.valueOf(array));
                }
            }
        } else {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
    }

    @Substitution
    public static @JavaType(value=Object.class) StaticObject get(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject Meta meta) {
        InterpreterToVM vm = meta.getInterpreterToVM();
        if (StaticObject.isNull(array)) {
            throw meta.throwNullPointerException();
        }
        if (array.isArray()) {
            try {
                switch (((ArrayKlass)array.getKlass()).getComponentType().getJavaKind()) {
                    case Boolean: {
                        boolean result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            result = library.asBoolean(library.readArrayElement(array.rawForeignObject(language), (long)index));
                        } else {
                            result = vm.getArrayByte(language, index, array) != 0;
                        }
                        return meta.boxBoolean(result);
                    }
                    case Byte: {
                        byte result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            result = library.asByte(library.readArrayElement(array.rawForeignObject(language), (long)index));
                        } else {
                            result = vm.getArrayByte(language, index, array);
                        }
                        return meta.boxByte(result);
                    }
                    case Short: {
                        short result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            result = library.asShort(library.readArrayElement(array.rawForeignObject(language), (long)index));
                        } else {
                            result = vm.getArrayShort(language, index, array);
                        }
                        return meta.boxShort(result);
                    }
                    case Char: {
                        char result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            String str = library.asString(library.readArrayElement(array.rawForeignObject(language), (long)index));
                            if (str.isEmpty()) {
                                result = '\u0000';
                            } else {
                                if (str.length() > 1) {
                                    throw meta.throwException(meta.java_lang_IllegalArgumentException);
                                }
                                result = str.charAt(0);
                            }
                        } else {
                            result = vm.getArrayChar(language, index, array);
                        }
                        return meta.boxCharacter(result);
                    }
                    case Int: {
                        int result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            result = library.asInt(library.readArrayElement(array.rawForeignObject(language), (long)index));
                        } else {
                            result = vm.getArrayInt(language, index, array);
                        }
                        return meta.boxInteger(result);
                    }
                    case Float: {
                        float result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            result = library.asFloat(library.readArrayElement(array.rawForeignObject(language), (long)index));
                        } else {
                            result = vm.getArrayFloat(language, index, array);
                        }
                        return meta.boxFloat(result);
                    }
                    case Long: {
                        long result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            result = library.asLong(library.readArrayElement(array.rawForeignObject(language), (long)index));
                        } else {
                            result = vm.getArrayLong(language, index, array);
                        }
                        return meta.boxLong(result);
                    }
                    case Double: {
                        double result;
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            result = library.asDouble(library.readArrayElement(array.rawForeignObject(language), (long)index));
                        } else {
                            result = vm.getArrayDouble(language, index, array);
                        }
                        return meta.boxDouble(result);
                    }
                    case Object: {
                        if (array.isForeignObject()) {
                            InteropLibrary library = InteropLibrary.getUncached();
                            Object result = library.readArrayElement(array.rawForeignObject(language), (long)index);
                            return StaticObject.createForeign(language, meta.java_lang_Object, result, InteropLibrary.getUncached((Object)result));
                        }
                        return vm.getArrayObject(language, index, array);
                    }
                }
                CompilerDirectives.transferToInterpreter();
                throw EspressoError.shouldNotReachHere("invalid array type: " + String.valueOf(array));
            }
            catch (UnsupportedMessageException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
            catch (InvalidArrayIndexException e) {
                int length = Target_java_lang_reflect_Array.getForeignArrayLength(array, language, meta);
                throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, InterpreterToVM.outOfBoundsMessage(index, length));
            }
        }
        throw meta.throwException(meta.java_lang_IllegalArgumentException);
    }

    private static int getForeignArrayLength(StaticObject array, EspressoLanguage language, Meta meta) {
        assert (array.isForeignObject());
        try {
            Object foreignObject = array.rawForeignObject(language);
            InteropLibrary library = InteropLibrary.getUncached((Object)foreignObject);
            long arrayLength = library.getArraySize(foreignObject);
            if (arrayLength > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)arrayLength;
        }
        catch (UnsupportedMessageException e) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "can't get array length because foreign object is not an array");
        }
    }
}

