/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.classfile.attributes.Local;
import com.oracle.truffle.espresso.classfile.attributes.LocalVariableTable;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@EspressoSubstitutions
public final class Target_jdk_internal_misc_ScopedMemoryAccess {
    @Substitution
    public static void registerNatives() {
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution
    public static boolean closeScope0(@JavaType(internalName="Ljdk/internal/foreign/MemorySessionImpl;") StaticObject session, @Inject EspressoContext context) {
        CloseScopedMemoryAction action = new CloseScopedMemoryAction(session);
        Future future = context.getEnv().submitThreadLocal(null, (ThreadLocalAction)action);
        TruffleSafepoint.setBlockedThreadInterruptible(null, f -> {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }, (Object)future);
        return !action.found;
    }

    private static final class CloseScopedMemoryAction
    extends ThreadLocalAction {
        static final int MAX_CRITICAL_STACK_DEPTH = 10;
        final StaticObject value;
        boolean found;

        protected CloseScopedMemoryAction(StaticObject value) {
            super(false, false);
            this.value = value;
        }

        protected void perform(ThreadLocalAction.Access access) {
            assert (access.getThread() == Thread.currentThread());
            Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){
                int count;

                public Object visitFrame(FrameInstance frameInstance) {
                    RootNode rootNode;
                    if (this.count >= 10) {
                        return this;
                    }
                    CallTarget callTarget = frameInstance.getCallTarget();
                    if (callTarget instanceof RootCallTarget && (rootNode = ((RootCallTarget)callTarget).getRootNode()) instanceof EspressoRootNode) {
                        EspressoRootNode espressoNode = (EspressoRootNode)rootNode;
                        ++this.count;
                        Method method = espressoNode.getMethod();
                        if (method.isScoped()) {
                            Local[] locals;
                            Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                            int bci = espressoNode.readBCI(frame);
                            assert (method.getLocalVariableTable() != LocalVariableTable.EMPTY_LVT);
                            for (Local local : locals = method.getLocalVariableTable().getLocalsAt(bci)) {
                                if (!local.getJavaKind().isObject() || EspressoFrame.getLocalObject(frame, local.getSlot()) != value) continue;
                                found = true;
                                return this;
                            }
                        }
                    }
                    return null;
                }
            });
        }
    }
}

