/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.ModuleExtension;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.VersionFilter;
import java.util.Set;

@EspressoSubstitutions
final class Target_jdk_internal_module_ModuleLoaderMap {
    Target_jdk_internal_module_ModuleLoaderMap() {
    }

    private static StaticObject getModules(ModuleExtension[] moduleExtensions, DirectCallNode original, EspressoContext context) {
        Meta meta = context.getMeta();
        @JavaType(value=Set.class) StaticObject originalResult = (StaticObject)original.call(new Object[0]);
        ModuleExtension[] extensions = moduleExtensions;
        if (extensions.length == 0) {
            return originalResult;
        }
        return Target_jdk_internal_module_ModuleLoaderMap.addModules(meta, originalResult, extensions);
    }

    @CompilerDirectives.TruffleBoundary
    private static StaticObject addModules(Meta meta, StaticObject originalResult, ModuleExtension[] extensions) {
        Method add = ((ObjectKlass)originalResult.getKlass()).itableLookup(meta.java_util_Set, meta.java_util_Set_add.getITableIndex());
        for (ModuleExtension me : extensions) {
            add.invokeDirect(originalResult, meta.toGuestString(me.moduleName()));
        }
        return originalResult;
    }

    @Substitution(versionFilter=VersionFilter.Java11OrEarlier.class)
    static abstract class PlatformModules
    extends SubstitutionNode {
        PlatformModules() {
        }

        abstract @JavaType(value=Set.class) StaticObject execute();

        @Specialization
        static @JavaType(value=Set.class) StaticObject doDefault(@Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().jdk_internal_module_ModuleLoaderMap_platformModules.getCallTargetNoSubstitution())") DirectCallNode original) {
            return Target_jdk_internal_module_ModuleLoaderMap.getModules(ModuleExtension.getPlatformExtensions(context), original, context);
        }
    }

    @Substitution(versionFilter=VersionFilter.Java11OrEarlier.class)
    static abstract class BootModules
    extends SubstitutionNode {
        BootModules() {
        }

        abstract @JavaType(value=Set.class) StaticObject execute();

        @Specialization
        static @JavaType(value=Set.class) StaticObject doDefault(@Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().jdk_internal_module_ModuleLoaderMap_bootModules.getCallTargetNoSubstitution())") DirectCallNode original) {
            return Target_jdk_internal_module_ModuleLoaderMap.getModules(ModuleExtension.getBootExtensions(context), original, context);
        }
    }
}

