/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.ContinuableMethodWithBytecode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoThreadLocalState;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.vm.VM;
import com.oracle.truffle.espresso.vm.continuation.HostFrameRecord;
import com.oracle.truffle.espresso.vm.continuation.UnwindContinuationException;
import java.util.ArrayList;
import java.util.Collections;

@EspressoSubstitutions
public final class Target_org_graalvm_continuations_ContinuationImpl {
    @Substitution(hasReceiver=true)
    static void suspend0(StaticObject self, @Inject EspressoLanguage language, @Inject Meta meta) {
        EspressoThreadLocalState tls = language.getThreadLocalState();
        if (tls.isContinuationSuspensionBlocked()) {
            throw meta.throwExceptionWithMessage(meta.continuum.org_graalvm_continuations_IllegalContinuationStateException, "Suspension is currently blocked by the presence of unsupported frames on the stack. Check for synchronized blocks, native calls and VM intrinsics in the stack trace of this exception.");
        }
        tls.disableSingleStepping(true);
        throw new UnwindContinuationException(self);
    }

    @Substitution(hasReceiver=true)
    static void materialize0(StaticObject self, @Inject Meta meta) {
        HostFrameRecord hfr = (HostFrameRecord)meta.continuum.HIDDEN_CONTINUATION_FRAME_RECORD.getHiddenObject(self, true);
        if (hfr == null) {
            return;
        }
        if (!StaticObject.isNull(meta.continuum.org_graalvm_continuations_ContinuationImpl_stackFrameHead.getObject(self))) {
            throw meta.throwExceptionWithMessage(meta.continuum.org_graalvm_continuations_IllegalMaterializedRecordException, "Somehow, both guest and host records are alive at the same time.");
        }
        StaticObject guestRecord = hfr.copyToGuest(meta);
        meta.continuum.HIDDEN_CONTINUATION_FRAME_RECORD.setHiddenObject(self, null, true);
        meta.continuum.org_graalvm_continuations_ContinuationImpl_stackFrameHead.setObject(self, guestRecord);
    }

    @Substitution(hasReceiver=true)
    static void dematerialize0(StaticObject self, @Inject Meta meta, @Inject EspressoContext context) {
        StaticObject guestRecord = meta.continuum.org_graalvm_continuations_ContinuationImpl_stackFrameHead.getObject(self);
        if (StaticObject.isNull(guestRecord)) {
            return;
        }
        if (meta.continuum.HIDDEN_CONTINUATION_FRAME_RECORD.getHiddenObject(self, true) != null) {
            throw meta.throwExceptionWithMessage(meta.continuum.org_graalvm_continuations_IllegalMaterializedRecordException, "Somehow, both guest and host records are alive at the same time.");
        }
        HostFrameRecord hfr = HostFrameRecord.copyFromGuest(self, meta, context);
        meta.continuum.org_graalvm_continuations_ContinuationImpl_stackFrameHead.setObject(self, StaticObject.NULL);
        meta.continuum.HIDDEN_CONTINUATION_FRAME_RECORD.setHiddenObject(self, hfr, true);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    static @JavaType(value=StackTraceElement[].class) StaticObject getRecordedFrames0(StaticObject self, @Inject EspressoContext context, @Inject Meta meta) {
        HostFrameRecord hfr = (HostFrameRecord)meta.continuum.HIDDEN_CONTINUATION_FRAME_RECORD.getHiddenObject(self, true);
        if (hfr == null) {
            return StaticObject.NULL;
        }
        ArrayList<StaticObject> trace = new ArrayList<StaticObject>();
        while (hfr != null) {
            StaticObject ste = meta.java_lang_StackTraceElement.allocateInstance(context);
            VM.fillInElement(ste, new VM.EspressoStackElement(hfr.methodVersion.getMethod(), hfr.bci()), meta);
            trace.add(ste);
            hfr = hfr.next;
        }
        Collections.reverse(trace);
        return StaticObject.wrap(trace.toArray(StaticObject.EMPTY_ARRAY), meta);
    }

    @Substitution(hasReceiver=true)
    static abstract class Start0
    extends SubstitutionNode {
        Start0() {
        }

        abstract boolean execute(StaticObject var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        boolean start0(StaticObject self, @Bind(value="getMeta()") Meta meta, @Bind(value="getLanguage()") EspressoLanguage lang, @Cached(value="create(meta.continuum.org_graalvm_continuations_ContinuationImpl_run.getCallTarget())") DirectCallNode runCall) {
            EspressoThreadLocalState tls = lang.getThreadLocalState();
            if (tls.isInContinuation()) {
                throw meta.throwExceptionWithMessage(meta.continuum.org_graalvm_continuations_IllegalContinuationStateException, "Cannot resume a continuation while already running in a continuation.");
            }
            try (EspressoThreadLocalState.ContinuationScope scope = tls.continuationScope();){
                runCall.call(new Object[]{self});
                boolean bl = false;
                return bl;
            }
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class Resume0
    extends SubstitutionNode {
        Resume0() {
        }

        abstract boolean execute(StaticObject var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean resume0(StaticObject self, @Bind(value="getLanguage()") EspressoLanguage lang, @Bind(value="getMeta()") Meta meta, @Cached ContinuableMethodWithBytecode.ResumeNextContinuationNode rewind) {
            EspressoThreadLocalState tls = lang.getThreadLocalState();
            if (tls.isInContinuation()) {
                throw meta.throwExceptionWithMessage(meta.continuum.org_graalvm_continuations_IllegalContinuationStateException, "Cannot resume a continuation while already running in a continuation.");
            }
            HostFrameRecord stack = Resume0.getHFR(self, meta);
            if (stack == null) {
                throw meta.throwExceptionWithMessage(meta.continuum.org_graalvm_continuations_IllegalContinuationStateException, "Continuation was not properly dematerialized.");
            }
            assert (stack.verify(meta, false));
            meta.continuum.HIDDEN_CONTINUATION_FRAME_RECORD.setHiddenObject(self, null, true);
            try (EspressoThreadLocalState.ContinuationScope scope = tls.continuationScope();){
                tls.disableSingleStepping(true);
                rewind.execute(stack);
                boolean bl = false;
                return bl;
            }
        }

        private static HostFrameRecord getHFR(StaticObject self, Meta meta) {
            return (HostFrameRecord)meta.continuum.HIDDEN_CONTINUATION_FRAME_RECORD.getHiddenObject(self, true);
        }
    }
}

