/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.VersionFilter;
import java.util.WeakHashMap;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@EspressoSubstitutions
public final class Target_sun_misc_Signal {
    private static final TruffleLogger logger = TruffleLogger.getLogger((String)"java", (String)"sun.misc.Signal");

    @CompilerDirectives.TruffleBoundary
    @Substitution(versionFilter=VersionFilter.Java8OrEarlier.class)
    public static int findSignal(@JavaType(value=String.class) StaticObject name, @Inject Meta meta) {
        if (StaticObject.isNull(name)) {
            throw meta.throwNullPointerException();
        }
        try {
            return new Signal(meta.toHostString(name)).getNumber();
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(versionFilter=VersionFilter.Java8OrEarlier.class)
    public static void raise(@JavaType(value=Signal.class) StaticObject signal, @Inject Meta meta) {
        if (StaticObject.isNull(signal)) {
            throw meta.throwNullPointerException();
        }
        Signal hostSignal = Target_sun_misc_Signal.asHostSignal(signal, meta);
        logger.finer(() -> "raising " + String.valueOf(hostSignal));
        try {
            Signal.raise(hostSignal);
        }
        catch (IllegalArgumentException e) {
            logger.fine(() -> "failed to raise " + String.valueOf(hostSignal) + ": " + e.getMessage());
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, meta.toGuestString(e.getMessage()));
        }
    }

    private static Signal asHostSignal(StaticObject signal, Meta meta) {
        StaticObject guestName = meta.sun_misc_Signal_name.getObject(signal);
        return new Signal(meta.toHostString(guestName));
    }

    private static StaticObject asGuestSignal(Signal signal, Meta meta) {
        StaticObject guestSignal = meta.sun_misc_Signal.allocateInstance(meta.getContext());
        meta.sun_misc_Signal_init_String.invokeDirectSpecial(guestSignal, meta.toGuestString(signal.getName()));
        return guestSignal;
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(versionFilter=VersionFilter.Java8OrEarlier.class)
    public static @JavaType(value=SignalHandler.class) StaticObject handle(@JavaType(value=Signal.class) StaticObject signal, @JavaType(value=SignalHandler.class) StaticObject handler, @Inject Meta meta) {
        if (StaticObject.isNull(signal)) {
            throw meta.throwNullPointerException();
        }
        if (!meta.getContext().getEspressoEnv().EnableSignals) {
            logger.fine(() -> "failed to setup handler for " + String.valueOf(Target_sun_misc_Signal.asHostSignal(signal, meta)) + ": signal handling is disabled ");
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Signal API is disabled");
        }
        Signal hostSignal = Target_sun_misc_Signal.asHostSignal(signal, meta);
        SignalHandler hostHandler = Target_sun_misc_Signal.asHostHandler(handler, meta);
        logger.finer(() -> "setting up handler for " + String.valueOf(hostSignal) + ": " + String.valueOf(hostHandler));
        try {
            SignalHandler oldHandler = Signal.handle(hostSignal, hostHandler);
            return Target_sun_misc_Signal.asGuestHandler(oldHandler, meta);
        }
        catch (IllegalArgumentException e) {
            logger.fine(() -> "failed to setup handler for " + String.valueOf(hostSignal) + ": " + e.getMessage());
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, meta.toGuestString(e.getMessage()));
        }
    }

    private static StaticObject asGuestHandler(SignalHandler handler, Meta meta) {
        if (handler == null) {
            return StaticObject.NULL;
        }
        if (handler instanceof HostSignalHandler) {
            return ((HostSignalHandler)handler).guestHandler;
        }
        if (handler == SignalHandler.SIG_DFL) {
            return meta.sun_misc_SignalHandler_SIG_DFL.getObject(meta.sun_misc_SignalHandler.tryInitializeAndGetStatics());
        }
        if (handler == SignalHandler.SIG_IGN) {
            return meta.sun_misc_SignalHandler_SIG_IGN.getObject(meta.sun_misc_SignalHandler.tryInitializeAndGetStatics());
        }
        throw EspressoError.shouldNotReachHere();
    }

    private static SignalHandler asHostHandler(StaticObject handler, Meta meta) {
        if (StaticObject.isNull(handler)) {
            return null;
        }
        if (meta.sun_misc_NativeSignalHandler.isAssignableFrom(handler.getKlass())) {
            long rawHandler = meta.sun_misc_NativeSignalHandler_handler.getLong(handler);
            if (rawHandler == 0L) {
                return SignalHandler.SIG_DFL;
            }
            if (rawHandler == 1L) {
                return SignalHandler.SIG_IGN;
            }
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, meta.toGuestString("Unsupported: arbitrary native signal handlers"));
        }
        return HostSignalHandler.get(meta, handler);
    }

    private static final class HostSignalHandler
    implements SignalHandler {
        private final Meta meta;
        private final StaticObject guestHandler;

        HostSignalHandler(Meta meta, StaticObject guestHandler) {
            this.meta = meta;
            this.guestHandler = guestHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SignalHandler get(Meta meta, StaticObject handler) {
            SignalHandler hostHandler;
            WeakHashMap<StaticObject, SignalHandler> hostSignalHandlers;
            WeakHashMap<StaticObject, SignalHandler> weakHashMap = hostSignalHandlers = meta.getContext().getHostSignalHandlers();
            synchronized (weakHashMap) {
                hostHandler = hostSignalHandlers.get(handler);
                if (hostHandler == null) {
                    hostHandler = new HostSignalHandler(meta, handler);
                    hostSignalHandlers.put(handler, hostHandler);
                }
            }
            return hostHandler;
        }

        @Override
        public void handle(Signal sig) {
            Object prev = this.meta.getContext().getEnv().getContext().enter(null);
            try {
                this.meta.sun_misc_SignalHandler_handle.invokeDirectInterface(this.guestHandler, Target_sun_misc_Signal.asGuestSignal(sig, this.meta));
            }
            finally {
                this.meta.getContext().getEnv().getContext().leave(null, prev);
            }
        }
    }
}

